/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/**************************************************************************
**  Copyright (C) 2000, Hewlett-Packard Co. All rights reserved.
**
**  File name:  test.c
**  Summary:    Linux device driver handler - test program.
**  Product:    Motherboard Management Controller API and driver
**  Created by: magoga - T&T, based in WinNT implementation
**  Owner:
**
**  START AUTOMATIC VERSION CONTROL INFORMATION
**  DO NOT MANUALLY EDIT THIS SECTION!
**  $Workfile:    $
**  $Revision: 1.2 $
**  $Date: 2001/04/24 13:22:06 $
**  $Author: hamilton $
**  END AUTOMATIC VERSION CONTROL INFORMATION
**
**  Description:
**              Just a quick test for the driver.
**
***************************************************************************
**  START AUTOMATIC VERSION CONTROL LOG
**  DO NOT MANUALLY EDIT THIS SECTION!
**  $Log: test.c,v $
**  Revision 1.2  2001/04/24 13:22:06  hamilton
**  - Added copyright notice;
**  - Changed Makefile for compiling in rh70.
**
**  Revision 1.1.1.1  2000/08/21 18:45:45  hamilton
**  Initial import.
**
**  Revision 1.1.1.1  2000/08/21 12:49:14  hamilton
**  Initial import.
**
**
**  END AUTOMATIC VERSION CONTROL LOG
**************************************************************************/

#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>

#define IOCTL_MMC_SEND_RCV                0x01
#define IOCTL_MMC_GET_KERNEL_VERSION      0x02
#define IOCTL_MMC_PORT_READ_DATA          0x03
#define IOCTL_MMC_PORT_READ_STATUS        0x04
#define IOCTL_MMC_PORT_READ_FLAG          0x05
#define IOCTL_MMC_PORT_WRITE_DATA         0x06
#define IOCTL_MMC_PORT_WRITE_STATUS       0x07
#define IOCTL_MMC_PORT_WRITE_FLAG         0x08

typedef char            INT8;
typedef unsigned char   UINT8;
typedef short           INT16;
typedef unsigned short  UINT16;


struct _KERNEL_VERSION
{
    UINT16      retcode; 
    char        oem_name[8];
	char        version_letter; // 1 ascii character
    UINT8       version_major;  // 1 byte major version number (0-99)
    UINT8       version_minor;  // 1 byte minor version number (0-99)
} __attribute__ ((packed));

typedef struct _KERNEL_VERSION KERNEL_VERSION;
typedef struct _KERNEL_VERSION *PKERNEL_VERSION;

struct _SEND_RCV    
{
   UINT16       retcode; 
   UINT8*       input;
   UINT8        ilen;
   UINT8*       output;
   UINT8        olen;
} __attribute__ ((packed));

typedef struct _SEND_RCV SEND_RCV;
typedef struct _SEND_RCV *PSEND_RCV;


static int nDriverFD;

/*******************************************************************
 ** TunnelOpenDriver - Opens the driver
 **
 **  Description:
 **              Calls the driver open function
 **
 **  Prototype:
 **              int TunnelOpenDriver(void)
 **
 **  Return value:
 **              MMC_SUCCESS    Driver open successfully
 **              EINUSE         Driver in use by another party
 **              ENOHARDWARE    MMC hardware was not found
 **              EDEVDRV        Device driver failure
 **
 **  Globals used: none.
 **  Globals modified: none.
 **
 *******************************************************************/
int TunnelOpenDriver(void)
{
    printf("TunnelOpenDriver().\n");
    if ((nDriverFD = open("/dev/mmcdev", O_RDWR)) < 0) {
        if (errno == EBUSY)
		    printf("EINUSE.\n");
        else if (errno == ENODEV)
            printf("ENOHARDWARE.\n");
        else
            printf("EDEVDRV.\n");
		return -1;
    }
    else {
        printf("MMC_SUCCESS.\n");
		return 0;
	}
} // TunnelOpenDriver

/********************************************************************
 ** TunnelCloseDriver - Closes the driver
 **
 **  Description:
 **              Calls the driver close function
 **
 **  Prototype:
 **              int TunnelCloseDriver(void)
 **  Return value:
 **              MMC_SUUCCES    Driver closed successfully
 **              ENOT_IN_USE    Driver was not opened
 **
 **  Globals used: none.
 **  Globals modified: none.
 **
 *******************************************************************/
int TunnelCloseDriver(void)
{
    printf("TunnelCloseDriver().\n");
    if (close(nDriverFD) < 0) {
	    printf("EDEVDRV.\n");
		return -1;
	}
    else {
        printf("MMC_SUCCESS.\n");
		return 0;
	}
} // TunnelCloseDriver

/********************************************************************
 ** TunnelGetVersionNumber - Gets driver version info
 **
 **  Description:
 **              Calls the driver get version info
 **
 **  Prototype:  int TunnelGetVersion(oem_name, version_letter, version_major,
 **                                   version_minor)
 **                                   char *oem_name - char[8] always filled with "HP"
 **                                   char *version_letter - one letter designating version number
 **                                   UINT8 *version_major - byte indicating major version number
 **                                   UINT8 *version_minor - byte indicating minor version number
 **
 **  Return value:
 **              MMC_SUCCESS    No error during execution of operation
 **              EDEVDRV        Device driver failure
 **
 **  Globals used: none.
 **  Globals modified: none.
 **
 *******************************************************************/
int TunnelGetVersionNumber(char *oem_name, char *version_letter,
                           UINT8 *version_major, UINT8 *version_minor)
{
    KERNEL_VERSION kernel_version;

    printf("TunnelGetVersionNumber().\n");
    if (ioctl(nDriverFD, IOCTL_MMC_GET_KERNEL_VERSION, &kernel_version) < 0) {
        printf("EDEVDRV. errno=%d\n", errno);
        return -1;
    }

    strcpy(oem_name, kernel_version.oem_name);

    *version_letter = kernel_version.version_letter;
    *version_major  = kernel_version.version_major;
    *version_minor  = kernel_version.version_minor;
   
    printf("ret = %x.\n", kernel_version.retcode);
    return 0;
} // TunnelGetVersion

/********************************************************************
 ** TunnelSendReceive - sends and receive a message to the driver
 **
 **  Description:
 **               Calls the driver SendReceive function
 **
 **  Prototype:
 **               int TunnelSendReceive(input, ilen, output, olen)
 **                                     UINT8 *input - input message
 **                                     int ilen - length of input message
 **                                     UINT8 *output - output message
 **                                     int olen - length of output message
 **  Return value:
 **               MMC_SUCCESS   No error during execution of operation
 **               EDEVDRV       Device driver failure
 **               EABORTED      Some error message was signaled by the code
 **               EBUFFER       Output buffer not large enough to receive data
 **
 **  Globals used: none.
 **  Globals modified: none.
 **
 *******************************************************************/
int TunnelSendReceive(UINT8 *input, int ilen, UINT8 *output, int *olen)
{
    int result;
    SEND_RCV sr;

    printf("TunnelSendReceive().\n");
    sr.input = input;
    sr.ilen = ilen;
    sr.output = output;
    sr.olen = *olen;

    result = ioctl(nDriverFD, IOCTL_MMC_SEND_RCV, &sr);

    *olen = sr.olen;

    if (result < 0) {
        printf("EDEVDRV. errno=%d\n", errno);
        return -1;
    }
    else {
        printf("ret = %x.\n", sr.retcode);
        return 0;
    }
} // TunnelSendReceive


main()
{
    unsigned char *inbuffer;
    unsigned char *outbuffer;
    int ilen, olen;
    int i;

    if (TunnelOpenDriver() < 0)
        exit(1);

    inbuffer = malloc(3);
    ilen = 3;

    inbuffer[0] = 0x18;
	inbuffer[1] = 0;				// Software ID
    inbuffer[2] = 0x1;

    outbuffer = malloc(10);
    olen = 10;

    if (TunnelSendReceive(inbuffer, ilen, outbuffer, &olen) < 0)
        exit(1);

    for (i=0; i<olen; i++)
        printf("outbuffer[%i] %2x\n", i, outbuffer[i]);

    TunnelCloseDriver();
}
