/**************************************************************************
**  Copyright (C) 2001, Hewlett-Packard Co. All rights reserved.
**
**  File name:  prmc.h
**  Summary:    Linux specific driver header info
**  Product:    pRMC driver
**  Owner:      
**
**  Description:
**              Provides structures and #defines for the Linux pRMC driver
**
**  Exports:
**      
**
**  START AUTOMATIC VERSION CONTROL INFORMATION
**  DO NOT MANUALLY EDIT THIS SECTION!
**  $Workfile:    $
**  $Revision: 1.1 $
**  $Date: 2001/09/14 20:16:14 $
**  $Author: eduardo $
**  END AUTOMATIC VERSION CONTROL INFORMATION
**
***************************************************************************
**  START AUTOMATIC VERSION CONTROL LOG
**  DO NOT MANUALLY EDIT THIS SECTION!                                                                  
**
**  $Log:
**
**************************************************************************/

#define IOCTL_PRMC_SEND_RCV               0x01

/* Device driver errors: */
#define MMC_SUCCESS             0
#define EDEVDRV                 0x100   /* Device Driver failure -- */
                		        /* ISA-BMC level error */
#define ETIMEOUT                0x101   /* Driver unable to get response before timing out */
#define EINUSE                  0x102   /* Driver was already opened */
#define ENOHARDWARE             0x103   /* No hardware was found during "Open" */
#define EMEMORY                 0x104   /* Indicates low memory -- unable to allocate space for buffers */
#define EPARAMS                 0x105   /* Parameter(s) incorrectly loaded -- possibly out of range */
#define EBADDATA                0x106   /* Driver returned data of incorrect size or some return */
                			/* parameters were wrong -- the data may be invalid */
#define EBUFFER                 0x107   /* the output buffer size was inadequate to hold all the returned */
                			/* data */
#define EINFWXFERMODE           0x108   /* The MMC was already in firmware transfer mode */
#define ENOTINFWXFERMODE        0x109   /* The MMC hasn't been set to firmware transfer mode */
#define EABORTED                0x110   /* The BIOS (?) aborted this function -- can retry without a problem */

#ifndef __min                                                                                       
    #define __min(a,b) (((a) < (b)) ? (a) : (b))                                                    
#endif

struct _PRMC_SEND_RCV    
{
   unsigned short retcode; 
   unsigned char *input;
   unsigned int ilen;
   unsigned char* output;
   unsigned int olen;
} __attribute__ ((packed));

typedef struct _PRMC_SEND_RCV PRMC_SEND_RCV;
typedef struct _PRMC_SEND_RCV *pPRMC_SEND_RCV;

