#ifndef _SHOW_SEL_H_
#define _SHOW_SEL_H_

// shell
#include <malloc.h>
// shell

#include "dev_sel.h"
#include "msg_sel.h"

typedef unsigned int Index;
typedef unsigned char Byte;
typedef int Flag;

#define ThresholdEvent(TRIGGER)	EventIsType ((TRIGGER), rgThresholdTriggers)
#define DigitalEvent(TRIGGER)		EventIsType ((TRIGGER), rgDigitalTriggers  )
#define DiscreteEvent(TRIGGER)	EventIsType ((TRIGGER), rgDiscreteTriggers )
#define strnicmp(a,b,c)			strncasecmp(a,b,c)

#define HPELFMT_NO_DATA			"[No Data]"
#define HPELFMT_BAD_FORMAT		"[Bad Format]"
#define HPELFMT_NOT_DETECTED		"[Not Detected]"

#define ESCAPE_CHARACTER      '%'
#define BYTE_CHARACTER        'b'
#define UPPER_CHARACTER       'u'
#define LOWER_CHARACTER       'l'
#define CONVERTED_READING     "cr"
#define CONVERTED_THRESHOLD   "ct"
#define LOCATION_STRING       "ls"
#define SENSOR_NUMBER         "sn"
#define STRING_CHARACTER      's'
#define INTEGER_CHARACTER     'i'
#define HEX_CHARACTER         'x'
#define MASK_CHARACTER        'm'
#define CONCAT_CHARACTER      '\\'
#define STRING_DELIMITER      "!"
#define SECTION_DELIMITER     '['
#define SPACE_CHARACTER       ' '
#define TAB_CHARACTER         '\t'

extern const struct MSG_INFO_SEL s_SelInfo[ MSG_INFO_SEL_LENGTH ];

Flag EventIsType (Byte eventTrigger, Byte *prgTriggers);
void MapData1_2to3 (SEL *pSEL);
void MapTrigger_2to3 (SEL *pSEL);
void MapEventRecord2to3 (SEL *pSEL);
void GetToken( char *szToken, SEL *selEntry, void *pOutput, size_t iSizeOut );
int  ReadKey( SEL *selEntry, char *lpszDestination, UINT32 *lpdwByteCount );
int  SEL_ShowEvent( char *buf, int iIndex, SEL *selEntry, int count );

#endif
