/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/**************************************************************************
**  Copyright (C) 1997-1999, Hewlett-Packard Co. All rights reserved.
**
**  File name:  era_cmd.h
**  Summary:    ERA Command Definitions
**
**************************************************************************/

#ifndef _ERA_CMD_H_
#define _ERA_CMD_H_

#include	"imb_std.h"	/* IMB OS-Dependent Standard Types */
#include	"imb_cmd.h"	/* IMB Common Command Definitions */

/* ERA NetFn (IMB_NF_ERA_) Commands */
#define ERA_GET_ERA_DEVICE_ID		0x01
#define	ERA_SMI_READY			0x0E
#define ERA_GOT_SYSTEM_MEMORY		0x10
#define ERA_GET_SYSTEM_MEMORY		0x11
#define ERA_GOT_SYSTEM_TIME		0x12
#define ERA_GET_SYSTEM_TIME		0x13
#define ERA_GOT_SCREEN_DATA		0x14
#define ERA_GET_SCREEN_DATA		0x15
#define ERA_GOT_CRTC_REGISTERS		0x16
#define ERA_GET_CRTC_REGISTERS		0x17
#define ERA_GOT_KEYSTROKES		0x18
#define ERA_SEND_KEYSTROKES		0x19
#define	ERA_ACK_REDIRECTION_STATE	0x1A
#define	ERA_SET_REDIRECTION_STATE	0x1B
#define ERA_SET_CONFIG			0x20
#define ERA_GET_CONFIG			0x21
#define ERA_RESET_CONFIG		0x22
#define ERA_GET_CONFIG_SIZE		0x23
#define ERA_SET_SERIAL_MUX		0x24
#define ERA_GET_SERIAL_MUX		0x25
#define ERA_SERIAL_HEARTBEAT		0x26
#define ERA_SET_BOOT_TYPE		0x28
#define ERA_GET_BOOT_TYPE		0x29
#define ERA_SEND_PAGE			0x2A
#define ERA_OOB_SESSION_STATUS		0x2B
#define ERA_MANUFACTURING_MODE		0x2E
#define ERA_COPY_SCREEN_DATA		0x35
#define ERA_COPY_CRTC_REGISTERS		0x37
#define	ERA_TYPE_KEYSTROKE		0x39
/*
 * Request BIOS to pulse NMI to cause a core dump.  This is for MMC's internal
 * use.  When MMC receives a CHASSIS_CONTROL command with a controlCommand of
 * CHAS_PULSE_FP_NMI, the MMC will put this command into the SMM buffer.  The
 * BIOS will then pick up the command and actually do the NMI.
 */
#define	PULSE_NMI			0x41

/* Masks for ERA NetFn Commands w/ SMM interaction */
#define	ERA_SMM_RANGE_MASK		0xF1
#define	ERA_SMM_RANGE_REQ_VALUE		0x11
#define	ERA_SMM_RANGE_RESP_VALUE	0x10

/* ERA-NetFn-specific completionCode values */
/*   the MUX cannot be switched because it is currently in use */
#define ERA_CC_SERIAL_IN_USE		0x80
/*   the MUX cannot be switched because ERA_C_COM_PORT config disallows it */
#define ERA_CC_COM_PORT_USE_DISALLOWED	0x81

/* ERA_GET_ERA_DEVICE_ID */
typedef void ERA_Q_GET_ERA_DEVICE_ID;

#define ERA_GEDI_DT_ERA			0xEA

typedef struct EraSGetEraDeviceId {
    UINT8   completionCode;	/* IMB_CC_ */
    UINT8   deviceType;		/* ERA_GEDI_DT_ERA (0xEA) */
    UINT8   hardwareVersion;	/* V.      */
    UINT8   firmwareUpdate;	/*  .RR.   */
    UINT8   firmwareFixLevel;   /*     .FF */
} ERA_S_GET_ERA_DEVICE_ID;


/* ERA_SMI_READY */
#define	ERA_SR_INITIALIZED	0x00
typedef struct EraQSmiReady {
    UINT8   smiReadyState;
} ERA_Q_SMI_READY;

typedef struct EraSSmiReady {
    UINT8   completionCode;	/* IMB_CC_ */
} ERA_S_SMI_READY;


/* ERA_GOT_SYSTEM_MEMORY */
typedef struct EraQGotSystemMemory {
    UINT8   systemData[2];	/* LSB first */
} ERA_Q_GOT_SYSTEM_MEMORY;

/* special case: no response */
typedef void ERA_S_GOT_SYSTEM_MEMORY;


/* ERA_GET_SYSTEM_MEMORY */
#define ERA_GSM_AM_II_11	0x04	/* Indexed I/O: 1 8-bit index port */
#define ERA_GSM_AM_II_21	0x05	/* Indexed I/O: 2 8-bit index ports */
#define ERA_GSM_AM_II_12	0x06	/* Indexed I/O: 1 16-bit index port */
#define ERA_GSM_AM_PM		0x80	/* Physical Memory: 32-bit addr */

typedef struct EraQGetSystemMemory {
    UINT8   accessMethod;	/* ERA_GSM_AM_ */
    union {
        struct {		/* Indexed I/O access */
	    UINT16  indexOffset;
	    UINT16  indexAddr;
	    UINT16  dataAddr;
	} ia;
	UINT32  address;	/* Memory address access */
    } a;
} ERA_Q_GET_SYSTEM_MEMORY;

typedef struct EraSGetSystemMemory {
    UINT8   completionCode;	/* IMB_CC_ */
} ERA_S_GET_SYSTEM_MEMORY;


/* ERA_GOT_SYSTEM_TIME */
typedef struct EraQGotSystemTime {
    /* little-endian seconds since 00:00:00 1 January 1970 in local time */
    UINT32  timestamp;
} ERA_Q_GOT_SYSTEM_TIME;

/* special case: no response */
typedef void ERA_S_GOT_SYSTEM_TIME;


/* ERA_GET_SYSTEM_TIME */
typedef void ERA_Q_GET_SYSTEM_TIME;

typedef struct EraSGetSystemTime {
    UINT8   completionCode;	/* IMB_CC_ */
} ERA_S_GET_SYSTEM_TIME;


/* ERA_GOT_SCREEN_DATA */
#define ERA_GSD_RC_NO_ERROR	0x00	/* next byte pairs hold screen data */
#define ERA_GSD_RC_GRAPHICS_MODE 0x01
#define ERA_GSD_RC_READ_ERROR	0x02
#define ERA_GSD_RC_BAD_CHAR_OFFSET 0x03
#define ERA_GSD_RC_EXPLICIT_DELTA 0x7f	/* next 2 bytes hold delta length */
#define ERA_GSD_RC_ENCODED_DELTA 0x80	/* 7 ls bits hold delta length */

typedef struct EraQGotScreenData {
    UINT8   resultCode;		/* ERA_GSD_RC_ */
    UINT8   screenData[IMB_MAX_DATA_LEN-1];
} ERA_Q_GOT_SCREEN_DATA;

/* special case: no response */
typedef ERA_S_GOT_SCREEN_DATA;


/* ERA_GET_SCREEN_DATA */
typedef struct EraQGetScreenData {
    UINT8   charOffsetLo;	/* little-endian 12-bit unsigned quantity */
    UINT8   charOffsetHi:4;
    UINT8   reserved:2;
    UINT8   crtcFlag:1;		/* non-zero to read & store CRTC registers */
    UINT8   delta:1;
} ERA_Q_GET_SCREEN_DATA;

typedef struct EraSGetScreenData {
    UINT8   completionCode;	/* IMB_CC_ */
} ERA_S_GET_SCREEN_DATA;


/* ERA_GOT_CRTC_REGISTERS */
typedef struct EraQGotCrtcRegisters {
    UINT8   crtcStatusRegister;
    UINT8   scanlinesPerChar;
    UINT16  screenStartAddr;	/* little-endian 16-bit unsigned I/O addr */
    UINT16  cursorLocation;	/* little-endian 16-bit unsigned char offset */
} ERA_Q_GOT_CRTC_REGISTERS;

/* special case: no response */
typedef void ERA_S_GOT_CRTC_REGISTERS;


/* ERA_GET_CRTC_REGISTERS */
typedef struct EraQGetCrtcRegisters {
    UINT8   storedFlag:1;	/* zero to read registers now */
    UINT8   storeFlag:1;	/* non-zero to store registers now */
    UINT8   reserved:6;
} ERA_Q_GET_CRTC_REGISTERS;

typedef struct EraSGetCrtcRegisters {
    UINT8   completionCode;	/* IMB_CC_ */
} ERA_S_GET_CRTC_REGISTERS;


/* ERA_GOT_KEYSTROKES */
typedef void ERA_Q_GOT_KEYSTROKES;

/* special case: no response */
typedef void ERA_S_GOT_KEYSTROKES;


/* ERA_SEND_KEYSTROKES */
typedef struct EraQSendKeystrokes {
    /* (current implementation only allows one keystroke at a time) */
    UINT8   keystrokes[IMB_MAX_DATA_LEN];
} ERA_Q_SEND_KEYSTROKES;

typedef struct EraSSendKeystrokes {
    UINT8   completionCode;	/* IMB_CC_ */
} ERA_S_SEND_KEYSTROKES;


/* ERA_ACK_REDIRECTION_STATE */
typedef void ERA_Q_ACK_REDIRECTION_STATE;

/* special case: no response */
typedef void ERA_S_ACK_REDIRECTION_STATE;

/* ERA_SET_REDIRECTION_STATE */
#define	ERA_SRS_REDIRECTION_OFF	0x00
#define	ERA_SRS_REDIRECTION_ON	0x01
typedef struct EraQSetRedirectionState {
    UINT8   redirectionState;
} ERA_Q_SET_REDIRECTION_STATE;

typedef struct EraSSetRedirectionState {
    UINT8   completionCode;	/* IMB_CC_ */
} ERA_S_SET_REDIRECTION_STATE;


/* ERA_SET_CONFIG */
typedef struct EraQSetConfig {
    UINT8   tag;		/* EC_ */
    UINT8   arrayIndex;
    UINT8   dataFragmentIndex:6;
    UINT8   dataFragmentStart:1; /* the first dataFragmentIndex accessed */
    UINT8   dataFragmentDone:1;	/* the last dataFragmentIndex to be accessed */
    UINT8   configData[IMB_MAX_DATA_LEN-3];
} ERA_Q_SET_CONFIG;

typedef struct EraSSetConfig {
    UINT8   completionCode;	/* IMB_CC_ */
} ERA_S_SET_CONFIG;


/* ERA_GET_CONFIG */
typedef struct EraQGetConfig {
    UINT8   tag;		/* EC_ */
    UINT8   arrayIndex;
    UINT8   dataFragmentIndex:6;
    UINT8   dataFragmentStart:1; /* the first dataFragmentIndex accessed */
    UINT8   dataFragmentDone:1;	/* the last dataFragmentIndex to be accessed */
} ERA_Q_GET_CONFIG;

typedef struct EraSGetConfig {
    UINT8   completionCode;	/* IMB_CC_ */
    UINT8   tag;		/* EC_ */
    UINT8   arrayIndex;
    UINT8   dataFragmentIndex:6;
    UINT8   reserved:1;
    UINT8   dataFragmentLast:1;	/* the last dataFragmentIndex stored */
    UINT8   configData[IMB_MAX_DATA_LEN-4];
} ERA_S_GET_CONFIG;


/* ERA_RESET_CONFIG */
typedef struct EraQResetConfig {
    UINT8   password[3];	/* "ERA" */
} ERA_Q_RESET_CONFIG;

typedef struct EraSResetConfig {
    UINT8   completionCode;	/* IMB_CC_ */
} ERA_S_RESET_CONFIG;


/* ERA_GET_CONFIG_SIZE */
typedef struct EraQGetConfigSize {
    UINT8   tag;		/* EC_ */
} ERA_Q_GET_CONFIG_SIZE;

typedef struct EraSGetConfigSize {
    UINT8   completionCode;	/* IMB_CC_ */
    UINT8   tag;		/* EC_ */
    UINT8   maxArrayIndex;
    UINT8   dataFragmentSize;
    UINT8   dataSize;
} ERA_S_GET_CONFIG_SIZE;


/* ERA_SET_SERIAL_MUX */
#define ERA_MUX_ERA		0	/* controlled by ERA */
#define ERA_MUX_SYSTEM		1	/* controlled by system COMx */
#define	ERA_MUX_COOP		2	/* cooperative ERA/COMx application */

/*
 *  use the OobSessionStatus command to determine whether the system COMx
 *  controls the serial line because due to a switch performed via the
 *  OOB (remote serial) interface.
 */

typedef struct ERA_QSetSerialMux {
    UINT8   mux;		/* ERA_MUX_ */
} ERA_Q_SET_SERIAL_MUX;

typedef struct ERA_SSetSerialMux {
    UINT8   completionCode;	/* IMB_CC_ & ERA_SSM_CC_ */
} ERA_S_SET_SERIAL_MUX;


/* ERA_GET_SERIAL_MUX */
typedef void ERA_Q_GET_SERIAL_MUX;

typedef struct ERA_SGetSerialMux {
    UINT8   completionCode;	/* IMB_CC_ */
    UINT8   mux;		/* ERA_MUX_ */
} ERA_S_GET_SERIAL_MUX;


/* ERA_SERIAL_HEARTBEAT */
typedef void ERA_Q_SERIAL_HEARTBEAT;

typedef struct EraSSerialHeartbeat {
    UINT8   completionCode;	/* IMB_CC_ */
} ERA_S_SERIAL_HEARTBEAT;


/* ERA_SET_NOTIFICATION */
typedef struct EraQSetNotification {
    UINT8   notifyEnable;
} ERA_Q_SET_NOTIFICATION;

typedef struct EraSSetNotification {
    UINT8   completionCode;	/* IMB_CC_ */
} ERA_S_SET_NOTIFICATION;


/* ERA_GET_NOTIFICATION */
typedef void ERA_Q_GET_NOTIFICATION;

typedef struct EraSGetNotification {
    UINT8   completionCode;	/* IMB_CC_ */
    UINT8   notifyEnable;
} ERA_S_GET_NOTIFICATION;


/* ERA_SEND_PAGE */
typedef struct EraQSendPage {
    UINT8   administrator;	/* 0..7, or 0xff for "all" */
    UINT16  errorCode;		/* little-endian error code */
    UINT8   alphaText[IMB_MAX_DATA_LEN-3];
} ERA_Q_SEND_PAGE;

typedef struct EraSSendPage {
    UINT8   completionCode;	/* IMB_CC_ */
} ERA_S_SEND_PAGE;


/* ERA_OOB_SESSION_STATUS */
#define ERA_OSS_NO_CONNECTION 0	/* the OOB port is not in use */
#define ERA_OSS_SYSTEM	      1	/* a server app. has the OOB's MUXed port */
#define ERA_OSS_CONNECTED     2	/* the OOB UI is negotiating a login */
#define ERA_OSS_ERA	      3	/* the OOB UI is running */
#define ERA_OSS_CONSOLE	      4	/* the OOB is in use for console redirection */
#define ERA_OSS_PASSTHRU      5	/* the OOB user yielded the OOB's MUXed port */
#define ERA_OSS_COOP	      6	/* a cooperative server app. has the port */
#define ERA_OSS_NOTIFICATION  7	/* paging notification is in progress */

typedef void ERA_Q_OOB_SESSION_STATUS;

typedef struct EraSOobSessionStatus {
    UINT8   completionCode;	/* IMB_CC_ */
    UINT8   sessionStatus;
    UINT8   userName[IMB_MAX_DATA_LEN-2];
} ERA_S_OOB_SESSION_STATUS;


/* ERA_GET_BOOT_TYPE */
#define ERA_BT_NORMAL_BOOT	0
#define ERA_BT_UTILITY_BOOT	1

typedef struct EraQSetBootType {
    UINT8   bootType;		/* ERA_BT_ */
} ERA_Q_SET_BOOT_TYPE;

typedef struct EraSSetBootType {
    UINT8   completionCode;	/* IMB_CC_ */
} ERA_S_SET_BOOT_TYPE;


/* ERA_GET_BOOT_TYPE */
typedef void ERA_Q_GET_BOOT_TYPE;

typedef struct EraSGetBootType {
    UINT8   completionCode;	/* IMB_CC_ */
    UINT8   bootType;		/* ERA_BT_ */
} ERA_S_GET_BOOT_TYPE;


/* ERA_MANUFACTURING_MODE */
#define	ERA_MANMODE_NONE	0	/* no mode (exits or prompts) */
#define	ERA_MANMODE_H_BLAST	'1'	/* blast 'H' out serial port, */
					/*   preceeded by options string */

typedef struct EraQManufacturingMode {
    UINT8   test;
    UINT8   options[IMB_MAX_DATA_LEN-1];
} ERA_Q_MANUFACTURING_MODE;

typedef struct EraSManufacturingMode {
    UINT8   completionCode;	/* IMB_CC_ */
} ERA_S_MANUFACTURING_MODE;



/*
**  ERA Config Commands
**
**  Get Config
**	Command:    ERA_GET_CONFIG
**	Data 1:     <ERA_C_> tag
**      Data 2:     <ERA_C_> array index [e.g., key code or user number]
**	Data 3:     <ERA_C_> fragment [0: 1st xx bytes, 1: 2nd xx bytes, ...]
**
**  Set Config
**	Command:    ERA_SET_CONFIG
**	Data 1:     <ERA_C_> tag
**      Data 2:     <ERA_C_> array index [e.g., key code or user number]
**	Data 3:     <ERA_C_> fragment [0: 1st xx bytes, 1: 2nd xx bytes, ...]
**	Data 4..23: Data for record
*/

/** <ERA_C_> tags **/

/* Era Configuration */
#define ERA_C_SERVER_ID		0x01	/* LSB 32-bit integer */ 
#define ERA_C_SERVER_NAME	0x02	/* [ECL_SERVER_NAME] */
#define ERA_C_AUTOLOGOUT	0x03	/* LSB 32-bit integer */
#define ERA_C_BAUD		0x04	/* LSB 32-bit integer */
#define ERA_C_COM_PORT		0x05	/* 8-bit integer: 0,0xff,1..n */
#define ERA_C_INIT_ID		0x06
#define ERA_C_INIT_STRING	0x07	/* [ECL_INIT_STRING] */
#define ERA_C_UTIL_PARTITION	0x08	/* ERA_UTILP_XXX */
#define ERA_C_MODEM_CONNECTION	0x09	/* ERA_MODEMC_XXX */
#define ERA_C_LOCALE		0x0A	/* 2 char ISO 639, 2 char ISO 3166 */
#define ERA_C_KEYBOARD_CODE	0x0B	/* 2 char array */
#define ERA_C_ALT_CODE_PAGE	0x0C	/* ERA_CODEP_XXX */
#define	ERA_C_DIRECT_FLAGS	0x0D	/* ERA_PAGEF_XXX */
#define	ERA_C_PAGER1_MAP_NAME	0x0E	/* [ECL_MAP_NAME] */

#define	ERA_C_PRIMARY_KEY_QUAL	0x10	/* [256] */
#define	ERA_C_SPECIAL_KEY_QUAL	0x11	/* [ECL_SPECIAL_KEY_QUAL] */
#define	ERA_C_PRIMARY_KEY_CODE	0x12	/* [256] */
#define	ERA_C_SPECIAL_KEY_CODE	0x13	/* [ECL_SPECIAL_KEY_QUAL] */
#define	ERA_C_ALT_TO_PRIMARY	0x14	/* [256] */
#define	ERA_C_PRIMARY_TO_ALT	0x15	/* [256] */
#define	ERA_C_PRIMARY_TO_PAGER1	0x16	/* [256] */

#define	ERA_C_PAGING_CRITERIA	0x1F	/* [256] (indexed by Sensor Type) */

/* Era Configuration -- User attributes */
#define ERA_CU_NAME		0x20	/* [<ERA_CU_NAME len>] */
#define ERA_CU_PASSWORD		0x21	/* [<ERA_CU_PASSWORD len>] */
#define ERA_CU_DIALBACK		0x22	/* [<ERA_CU_DIALBACK len>] */
#define ERA_CU_PAGER_NUM	0x23	/* [<ERA_CU_PAGER_NUM len>] */
#define ERA_CU_FLAGS		0x24	/* (reserved: 8 bits of flags) */
#define ERA_CU_PAGER_MODE	0x25	/* ERA_UPAGERM_XXX */
#define ERA_CU_PAGER_DELAY	0x26	/* (has always been zero) */

#define ERA_CU_TAP_FRAME	0x28	/* ERA_FRAME_XXX */
#define	ERA_CU_TAP_FLAGS	0x29	/* ERA_PAGEF_XXX */
#define ERA_CU_TAP_INIT		0x2A	/* [<ERA_CU_TAP_INIT len>] */
#define ERA_CU_TAP_ID		0x2B	/* [<ERA_CU_TAP_ID len>] */
#define ERA_CU_TAP_PASSWORD	0x2C	/* [<ERA_CU_TAP_PASSWORD len>] */
#define ERA_CU_TERM_CHARSET	0x2D	/* ERA_UTERMC_XXX */
#define ERA_CU_TERM_LINES	0x2E	/* ERA_UTERML_XXX */
#define ERA_CU_TERM_COLOR	0x2F	/* ERA_UTERMC_XXX */

/* ERA_C_COM_PORT */
#define	ERA_COM_PORT_ERA_ONLY	0x00	/* ERA always owns the MUX */

/* ERA_C_UTIL_PARTITION */
#define ERA_UTILP_MISSING	0
#define ERA_UTILP_EXISTS	1

/* ERA_C_MODEM_CONNECTION */
#define ERA_MODEMC_DIRECT	0
#define ERA_MODEMC_PULSE	1
#define ERA_MODEMC_TONE		2

/* ERA_C_LOCALE */
#define	ERA_LOC_US_ENGLISH	"enUS"	/* (not currently modifyable) */
#define	ERA_LOC_FRENCH		"frFR"
#define	ERA_LOC_GERMAN		"deDE"
#define	ERA_LOC_ITALIAN		"itIT"
#define	ERA_LOC_SPANISH		"esES"

/* ERA_C_CODE_PAGE */
#define ERA_CODEP_850		850	/* almost 437 */
#define ERA_CODEP_LATIN_1	1252	/* ISO Latin 1 */

/* ERA_C_KEYMAP_CODE */
#define	ERA_KMAP_US		0x7375	/* 'us' */

/* ERA_C_DIRECT_FLAGS */
/* ERA_C_TAP_FLAGS */
/* no map: use 8-bit primary set for display, 6 bit vanilla for alpha paging */
#define	ERA_PAGEF_MAP_PRIM	0x00
/* map to 8-bit ERA_C_PRIMARY_TO_ALT/_PAGER1 alternate set */
#define	ERA_PAGEF_MAP_ALT	0x01
#define	ERA_PAGEF_MAP_MASK	0x01	/* (may increase later) */

#define	ERA_PAGEF_ENGLISH	0x40	/* use english (vs. native) language */
#define	ERA_PAGEF_DISABLE	0x80	/* inhibit (direct) paging */

/*
 * ERA_C_PAGING_CRITERIA elements are associated w/ Sensor Types.
 * The elements contain two nibbles, whose values can independently
 * take on one of those listed here.
 * The high nibble indicates what event threshold will cause the
 * server to power off.
 * The low nibble indicates what event threshold will trigger
 * pager notification.
 */
#define	ERA_SEV_UNKNOWN		0x0	/* reserved, do not use */
#define	ERA_SEV_OK		0x1	/* == ALWAYS */
#define	ERA_SEV_RECOVERING	0x2
#define	ERA_SEV_STATUS		0x3	/* monitor, informational */
#define	ERA_SEV_NON_CRITICAL	0x4
#define	ERA_SEV_CRITICAL	0x5
#define	ERA_SEV_NON_RECOVERABLE	0x6
#define	ERA_SEV_NEVER		0x7

/* ERA_CU_PAGER_MODE */
#define ERA_UPAGERM_DISABLED	0
#define ERA_UPAGERM_ENABLED	1
#define	ERA_UPAGERM_ENABLE_MASK	1
#define	ERA_UPAGERM_TYPE_SHIFT	1	/* (may increase later) */
#define	ERA_UPAGERM_TYPE_MASK	(3<<1)	/* (may increase later) */
#define	ERA_UPAGERM_T_NUMERIC	(0<<1)
#define ERA_UPAGERM_T_TAP	(1<<1)
//#define	ERA_UPAGERM_T_UCP	(2<<1)

#define	ERA_UPAGERM_NONE	ERA_UPAGERM_DISABLED
#define	ERA_UPAGERM_NUMERIC	(ERA_UPAGERM_ENABLED | ERA_UPAGERM_T_NUMERIC)
#define	ERA_UPAGERM_TAP		(ERA_UPAGERM_ENABLED | ERA_UPAGERM_T_TAP)

/* ERA_CU_TAP_FRAME			   data bits, parity, stop bits */
/*      not supported           0x0            7       none       1     */
#define ERA_FRAME_7N2		0x1	/*     7       none       2     */
#define ERA_FRAME_8N1		0x2	/*     8       none       1     */
#define ERA_FRAME_8N2		0x3	/*     8       none       2     */
#define ERA_FRAME_7E1		0x4	/*     7       even       1     */
#define ERA_FRAME_7E2		0x5	/*     7       even       2     */
#define ERA_FRAME_8E1		0x6	/*     8       even       1     */
/*      not supported           0x7            8       even       2     */
#define ERA_FRAME_7O1		0x8	/*     7        odd       1     */
#define ERA_FRAME_7O2		0x9	/*     7        odd       2     */
#define ERA_FRAME_8O1		0xa	/*     8        odd       1     */
/*      not supported           0xb            8        odd       2     */

/* ERA_CU_TERM_CHARSET */
#define ERA_UTERMC_PRIM_CODE	0	/* terminal code matches the PC */
#define ERA_UTERMC_ALT_CODE	1	/* terminal code needs remapping */ 

/* ERA_CU_TERM_COLOR */
#define ERA_UTERMC_COLOR	0	/* terminal supports color */
#define ERA_UTERMC_MONO		1	/* terminal is black & white */

#endif  /* _ERA_CMD_H_ */
