/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/**************************************************************************
**  Copyright (C) 1997-1999, Hewlett-Packard Co. All rights reserved.
**
**  File name:  sd_cmd.h
**  Summary:    IMB Sensor Device Command Definitions
**
**************************************************************************/

#ifndef _SD_CMD_H_
#define _SD_CMD_H_

#include        "imb_std.h"     /* IMB OS-Dependent Standard Types */
#include        "imb_cmd.h"     /* IMB Common Command Definitions */

/* Sensor/Event NetFn (IMB_NF_SENSOR_REQ) Sensor Device Commands */
#define SD_GET_DEVICE_SDR_INFO          0x20u    /* Not Implemented */
#define SD_GET_DEVICE_SDR               0x21u    /* Not Implemented */
#define SD_RESERVE_DEVICE_SDR_REPOSITORY 0X22u   /* Not Implemented */
#define SD_GET_SENSOR_READING_FACTORS   0x23u    /* Not Implemented */
#define SD_SET_SENSOR_HYSTERISIS        0x24u
#define SD_GET_SENSOR_HYSTERISIS        0x25u
#define SD_SET_SENSOR_THRESHOLD         0x26u
#define SD_GET_SENSOR_THRESHOLD         0x27u
#define SD_SET_SENSOR_EVENT_MESSAGE_ENABLE 0x28u
#define SD_GET_SENSOR_EVENT_MESSAGE_ENABLE 0x29u
#define SD_RE_ARM_SENSOR_EVENTS         0x2Au
#define SD_GET_SENSOR_EVENT_STATUS      0x2Bu
#define SD_GET_SENSOR_READING           0x2Du

#define SD_SET_SENSOR_TYPE              0x2Eu    /* new for IPMI 1.0 */
#define SD_GET_SENSOR_TYPE              0x2Fu    /* new for IPMI 1.0 */

/* SD_GET_DEVICE_SDR_INFO */
typedef void SD_Q_GET_DEVICE_SDR_INFO;

#define SD_GDSI_F_DYNAMIC_SENSOR_POPULATION 0x80
#define SD_GDSI_F_LUN3_SENSORS          0x08u
#define SD_GDSI_F_LUN2_SENSORS          0x04u
#define SD_GDSI_F_LUN1_SENSORS          0x02u
#define SD_GDSI_F_LUN0_SENSORS          0x01u

typedef struct Sd09SGetDeviceSdrInfo {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   numberOfSensors;
    UINT8   flags;              /* SD_GDSI_F_ */
    UINT32  sensorPopulationChangeIndicator;
} SD_S_GET_DEVICE_SDR_INFO;


/* SD_GET_DEVICE_SDR */
typedef struct Sd09QGetDeviceSdr {
    UINT16   reservationId;
    UINT16   recordId;
    UINT8   offset;
    UINT8   requestedGetLength;

} SD_Q_GET_DEVICE_SDR;

typedef struct Sd09SGetDeviceSdr {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT16   nextRecordId;
    UINT8   sdrData[IMB_MAX_DATA_LEN-2];
} SD_S_GET_DEVICE_SDR;


/* SDRR_RESERVE_SDR_REPOSITORY */
typedef void SDRR_Q_RESERVE_DEVICE_SDR_REPOSITORY;

typedef struct SdrrSReserveDeviceSdrRepository {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT16  reservationId;
} SDRR_S_RESERVE_DEVICE_SDR_REPOSITORY;


/* SD_GET_SENSOR_READING_FACTORS */
typedef struct Sd09QGetSensorReadingFactors {
    UINT8   sensorNumber;
    UINT8   readingByte;
} SD_Q_GET_SENSOR_READING_FACTORS;

typedef struct Sd09SGetSensorReadingFactors {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   nextReading;
    UINT16  m;                  /* & tolerance */
    UINT16  b;                  /* & accuracy */
    UINT8   accuracy;
    UINT8   exponents;          /* for R & B */
} SD_S_GET_SENSOR_READING_FACTORS;


/* SD_SET_SENSOR_HYSTERISIS */
typedef struct Sd09QSetSensorHysterisis {
    UINT8   sensorNumber;
    UINT8   hysterisisMask;     /* 0xff */
    UINT8   positiveHysterisisValue;
    UINT8   negativeHysterisisValue;
} SD_Q_SET_SENSOR_HYSTERISIS;

typedef struct Sd09SSetSensorHysterisis {
    UINT8   completionCode;     /* IMB_CC_ */
} SD_S_SET_SENSOR_HYSTERISIS;


/* SD_GET_SENSOR_HYSTERISIS */
typedef struct Sd09QGetSensorHysterisis {
    UINT8   sensorNumber;
    UINT8   hysterisisMask;     /* 0xff */
} SD_Q_GET_SENSOR_HYSTERISIS;

typedef struct Sd09SGetSensorHysterisis {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   positiveHysterisisValue;
    UINT8   negativeHysterisisValue;
} SD_S_GET_SENSOR_HYSTERISIS;


/************************ version 0.9 ***********************/
/* SD09_SET_SENSOR_THRESHOLD */
#define ST09_TC_UPPER_FATAL               0x00u    /* critical */
#define ST09_TC_UPPER_WARNING             0x01u    /* non-critical */
#define ST09_TC_LOWER_FATAL               0x02u    /* critical */
#define ST09_TC_LOWER_WARNING             0x03u    /* non-critical */
#define ST09_TC_UPPER_NON_RECOVERABLE     0x04u
#define ST09_TC_LOWER_NON_RECOVERABLE     0x06u

typedef struct Sd09QSetSensorThreshold {
    UINT8   sensorNumber;
    UINT8   thresholdCode;      /* ST_TC_ */
    UINT8   thresholdValue;
} SD09_Q_SET_SENSOR_THRESHOLD;

typedef struct Sd09SSetSensorThreshold {
    UINT8   completionCode;     /* IMB_CC_ */
} SD09_S_SET_SENSOR_THRESHOLD;


/* SD_GET_SENSOR_THRESHOLD */
typedef struct Sd09QGetSensorThreshold {
    UINT8   sensorNumber;
    UINT8   thresholdCode;      /* ST_TC_ */
} SD09_Q_GET_SENSOR_THRESHOLD;

typedef struct Sd09SGetSensorThreshold {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   thresholdValue;
} SD09_S_GET_SENSOR_THRESHOLD;

/*********************** version 1.0 ************************/
/* SD09_SET_SENSOR_THRESHOLD */
#define ST10_TC_UPPER_NON_RECOVERABLE     0x20u
#define ST10_TC_UPPER_FATAL               0x10u    /* critical */
#define ST10_TC_UPPER_WARNING             0x08u    /* non-critical */
#define ST10_TC_LOWER_NON_RECOVERABLE     0x04u
#define ST10_TC_LOWER_FATAL               0x02u    /* critical */
#define ST10_TC_LOWER_WARNING             0x01u    /* non-critical */


typedef struct Sd10QSetSensorThreshold {
    UINT8   sensorNumber;
    UINT8   thresholdMask;      /* ST_TC_ */
    UINT8   lNCThresholdValue;
    UINT8   lCThresholdValue;
    UINT8   lNRThresholdValue;
    UINT8   uNCThresholdValue;
    UINT8   uCThresholdValue;
    UINT8   uNRThresholdValue;
} SD10_Q_SET_SENSOR_THRESHOLD;

typedef struct Sd10SSetSensorThreshold {
    UINT8   completionCode;     /* IMB_CC_ */
} SD10_S_SET_SENSOR_THRESHOLD;


/* SD_GET_SENSOR_THRESHOLD */
typedef struct Sd10QGetSensorThreshold {
    UINT8   sensorNumber;
} SD10_Q_GET_SENSOR_THRESHOLD;

typedef struct Sd10SGetSensorThreshold {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   thresholdMask;      /* ST_TC_ */
    UINT8   lNCThresholdValue;
    UINT8   lCThresholdValue;
    UINT8   lNRThresholdValue;
    UINT8   uNCThresholdValue;
    UINT8   uCThresholdValue;
    UINT8   uNRThresholdValue;
} SD10_S_GET_SENSOR_THRESHOLD;

#if defined(IPMI_VER_10)
#define ST_TC_UPPER_NON_RECOVERABLE  ST10_TC_UPPER_NON_RECOVERABLE
#define ST_TC_UPPER_FATAL  ST10_TC_UPPER_FATAL
#define ST_TC_UPPER_WARNING  ST10_TC_UPPER_WARNING
#define ST_TC_LOWER_NON_RECOVERABLE  ST10_TC_LOWER_NON_RECOVERABLE
#define ST_TC_LOWER_FATAL  ST10_TC_LOWER_FATAL
#define ST_TC_LOWER_WARNING  ST10_TC_LOWER_WARNING

#define SdSetSensorThreshold   Sd10SSetSensorThreshold
#define SD_Q_SET_SENSOR_THRESHOLD  SD10_Q_SET_SENSOR_THRESHOLD
#define SdSetSensorThreshold  Sd10SSetSensorThreshold
#define SD_S_SET_SENSOR_THRESHOLD  SD10_S_SET_SENSOR_THRESHOLD
#define SdQGetSensorThreshold  Sd10QGetSensorThreshold
#define SD_Q_GET_SENSOR_THRESHOLD  SD10_Q_GET_SENSOR_THRESHOLD
#define SdSGetSensorThreshold  Sd10SGetSensorThreshold
#define SD_S_GET_SENSOR_THRESHOLD  SD10_S_GET_SENSOR_THRESHOLD
#endif
#if defined(IPMI_VER_09)
#define ST_TC_UPPER_NON_RECOVERABLE  ST09_TC_UPPER_NON_RECOVERABLE
#define ST_TC_UPPER_FATAL  ST09_TC_UPPER_FATAL
#define ST_TC_UPPER_WARNING  ST09_TC_UPPER_WARNING
#define ST_TC_LOWER_NON_RECOVERABLE  ST09_TC_LOWER_NON_RECOVERABLE
#define ST_TC_LOWER_FATAL  ST09_TC_LOWER_FATAL
#define ST_TC_LOWER_WARNING  ST09_TC_LOWER_WARNING

#define SdQSetSensorThreshold   Sd09QSetSensorThreshold
#define SD_Q_SET_SENSOR_THRESHOLD  SD09_Q_SET_SENSOR_THRESHOLD
#define SdSSetSensorThreshold  Sd09SSetSensorThreshold
#define SD_S_SET_SENSOR_THRESHOLD  SD09_S_SET_SENSOR_THRESHOLD
#define SdQGetSensorThreshold  Sd09QGetSensorThreshold
#define SD_Q_GET_SENSOR_THRESHOLD  SD09_Q_GET_SENSOR_THRESHOLD
#define SdSGetSensorThreshold  Sd09SGetSensorThreshold
#define SD_S_GET_SENSOR_THRESHOLD  SD09_S_GET_SENSOR_THRESHOLD
#endif


/************************ version 0.9 ***********************/
/* definitions for SD09_SET_SENSOR_EVENT_MESSAGE_ENABLE command */
#define SD09_SS_EVM_ENABLE_ALL      0x80u
#define SD09_SS_EVM_ENABLE_SCAN     0x40u
#define SD_SS_EVM_ENABLE_LNR_EVM  0x20u   /* lower non-recoverable */
#define SD_SS_EVM_ENABLE_UNR_EVM  0x10u   /* upper non-recoverable */
#define SD_SS_EVM_ENABLE_LNC_EVM  0x08u   /* lower non-critical    */
#define SD_SS_EVM_ENABLE_UNC_EVM  0x04u   /* upper non-critical    */
#define SD_SS_EVM_ENABLE_LC_EVM   0x02u   /* lower critical        */
#define SD_SS_EVM_ENABLE_UC_EVM   0x01u   /* upper critical        */

/* SD09_SET_SENSOR_EVENT_MESSAGE_ENABLE */
typedef struct Sd09QSetSensorEventMessageEnable {
    UINT8   sensorNumber;
    UINT8   enableBits;
} SD09_Q_SET_SENSOR_EVENT_MESSAGE_ENABLE;

typedef struct Sd09SSetSensorEventMessageEnable {
    UINT8   completionCode;     /* IMB_CC_ */
} SD09_S_SET_SENSOR_EVENT_MESSAGE_ENABLE;


/* SD_GET_SENSOR_EVENT_MESSAGE_ENABLE */
typedef struct Sd09QGetSensorEventMessageEnable {
    UINT8   sensorNumber;
    UINT8   offset;
} SD09_Q_GET_SENSOR_EVENT_MESSAGE_ENABLE;

typedef struct Sd09SGetSensorEventMessageEnable {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   enableBits;
} SD09_S_GET_SENSOR_EVENT_MESSAGE_ENABLE;


/*********************** version 1.0 ************************/
/* definitions for SD10_SET_SENSOR_EVENT_MESSAGE_ENABLE command */
#define SD10_SS_EVM_ENABLE_ALL      0x80u
#define SD10_SS_EVM_ENABLE_SCAN     0x40u
#define SD_SS_EVM_ENABLE_BITS    (SD10_SS_EVM_ENABLE_ALL | SD10_SS_EVM_ENABLE_SCAN)
#define SD_SS_EVM_NO_CHANGE       0x00u
#define SD_SS_EVM_SELECT_ENABLE   0x10u
#define SD_SS_EVM_SELECT_DISABLE  0x20u
#define SD_SS_EVM_SELECT_MASK    (SD_SS_EVM_SELECT_ENABLE | SD_SS_EVM_SELECT_DISABLE)

#define SD_SS_EVM_ENABLE_UNR_GH  0x0800ul   /* upper non-recoverable going high */
#define SD_SS_EVM_ENABLE_UNR_GL  0x0400ul   /* upper non-recoverable going low  */
#define SD_SS_EVM_ENABLE_UC_GH   0x0200ul   /* upper critical going high */
#define SD_SS_EVM_ENABLE_UC_GL   0x0100ul   /* upper critical going low  */
#define SD_SS_EVM_ENABLE_UNC_GH  0x0080ul   /* upper non-critical going high */
#define SD_SS_EVM_ENABLE_UNC_GL  0x0040ul   /* upper non-critical going low  */
#define SD_SS_EVM_ENABLE_LNR_GH  0x0020ul   /* lower non-recoverable going high */
#define SD_SS_EVM_ENABLE_LNR_GL  0x0010ul   /* lower non-recoverable going low  */
#define SD_SS_EVM_ENABLE_LC_GH   0x0008ul   /* lower critical going high */
#define SD_SS_EVM_ENABLE_LC_GL   0x0004ul   /* lower critical going low  */
#define SD_SS_EVM_ENABLE_LNC_GH  0x0002ul   /* lower non-critical going high */
#define SD_SS_EVM_ENABLE_LNC_GL  0x0001ul   /* lower non-critical going low  */

/* SD10_SET_SENSOR_EVENT_MESSAGE_ENABLE */
typedef struct Sd10QSetSensorEventMessageEnable {
    UINT8   sensorNumber;
    UINT8   enableBits;
    UINT8   selectAssertion[2];
    UINT8   selectDeassertion[2];
} SD10_Q_SET_SENSOR_EVENT_MESSAGE_ENABLE;

typedef struct Sd10SSetSensorEventMessageEnable {
    UINT8   completionCode;     /* IMB_CC_ */
} SD10_S_SET_SENSOR_EVENT_MESSAGE_ENABLE;

/* SD_GET_SENSOR_EVENT_MESSAGE_ENABLE */
typedef struct Sd10QGetSensorEventMessageEnable {
    UINT8   sensorNumber;
} SD10_Q_GET_SENSOR_EVENT_MESSAGE_ENABLE;

typedef struct Sd10SGetSensorEventMessageEnable {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   enableBits;
    UINT8   assertionEnabled[2];
    UINT8   deassertionEnabled[2];
} SD10_S_GET_SENSOR_EVENT_MESSAGE_ENABLE;



#if defined(IPMI_VER_10)
#define SD_SS_EVM_ENABLE_ALL  SD10_SS_EVM_ENABLE_ALL
#define SD_SS_EVM_ENABLE_SCAN  SD10_SS_EVM_ENABLE_SCAN

#define SdQSetSensorEventMessageEnable  Sd10QSetSensorEventMessageEnable
#define SD_Q_SET_SENSOR_EVENT_MESSAGE_ENABLE  SD10_Q_SET_SENSOR_EVENT_MESSAGE_ENABLE
#define SdSSetSensorEventMessageEnable  Sd10SSetSensorEventMessageEnable
#define SD_S_SET_SENSOR_EVENT_MESSAGE_ENABLE  SD10_S_SET_SENSOR_EVENT_MESSAGE_ENABLE
#define SdQGetSensorEventMessageEnable  Sd10QGetSensorEventMessageEnable
#define SD_Q_GET_SENSOR_EVENT_MESSAGE_ENABLE  SD10_Q_GET_SENSOR_EVENT_MESSAGE_ENABLE
#define SdSGetSensorEventMessageEnable  Sd10SGetSensorEventMessageEnable
#define SD_S_GET_SENSOR_EVENT_MESSAGE_ENABLE  SD10_S_GET_SENSOR_EVENT_MESSAGE_ENABLE
#endif

#if defined(IPMI_VER_09)
#define SD_SS_EVM_ENABLE_ALL  SD09_SS_EVM_ENABLE_ALL
#define SD_SS_EVM_ENABLE_SCAN  SD09_SS_EVM_ENABLE_SCAN

#define SdQSetSensorEventMessageEnable  Sd09QSetSensorEventMessageEnable
#define SD_Q_SET_SENSOR_EVENT_MESSAGE_ENABLE  SD09_Q_SET_SENSOR_EVENT_MESSAGE_ENABLE
#define SdSSetSensorEventMessageEnable  Sd09SSetSensorEventMessageEnable
#define SD_S_SET_SENSOR_EVENT_MESSAGE_ENABLE  SD09_S_SET_SENSOR_EVENT_MESSAGE_ENABLE
#define SdQGetSensorEventMessageEnable  Sd09QGetSensorEventMessageEnable
#define SD_Q_GET_SENSOR_EVENT_MESSAGE_ENABLE  SD09_Q_GET_SENSOR_EVENT_MESSAGE_ENABLE
#define SdSGetSensorEventMessageEnable  Sd09SGetSensorEventMessageEnable
#define SD_S_GET_SENSOR_EVENT_MESSAGE_ENABLE  SD09_S_GET_SENSOR_EVENT_MESSAGE_ENABLE
#endif

/************************ version 0.9 ***********************/
/* SD_RE_ARM_SENSOR_EVENTS */
typedef struct Sd09QReArmSensorEvents {
    UINT8   sensorNumber;
    UINT8   reArmBits;
} SD09_Q_RE_ARM_SENSOR_EVENTS;

typedef struct Sd09SReArmSensorEvents {
    UINT8   completionCode;     /* IMB_CC_ */
} SD09_S_RE_ARM_SENSOR_EVENTS;


/*********************** version 1.0 ************************/

#define SD_RA_S_ALL_EVENTS    0x80

/* SD_RE_ARM_SENSOR_EVENTS */
typedef struct Sd10QReArmSensorEvents {
    UINT8   sensorNumber;
    UINT8   reArmControl;
    UINT8   reArmAssertion[2];
    UINT8   reArmDeassertion[2];
} SD10_Q_RE_ARM_SENSOR_EVENTS;

typedef struct Sd10SReArmSensorEvents {
    UINT8   completionCode;     /* IMB_CC_ */
} SD10_S_RE_ARM_SENSOR_EVENTS;


#if defined(IPMI_VER_10)
#define SdQReArmSensorEvents  Sd10QReArmSensorEvents
#define SD_Q_RE_ARM_SENSOR_EVENTS  SD10_Q_RE_ARM_SENSOR_EVENTS
#define SdSReArmSensorEvents  Sd10SReArmSensorEvents
#define SD_S_RE_ARM_SENSOR_EVENTS  SD10_S_RE_ARM_SENSOR_EVENTS
#endif

#if defined(IPMI_VER_09)
#define SdQReArmSensorEvents  Sd09QReArmSensorEvents
#define SD_Q_RE_ARM_SENSOR_EVENTS  SD09_Q_RE_ARM_SENSOR_EVENTS
#define SdSReArmSensorEvents  Sd09SReArmSensorEvents
#define SD_S_RE_ARM_SENSOR_EVENTS  SD09_S_RE_ARM_SENSOR_EVENTS
#endif

/************************ version 0.9 ***********************/
/* SD_GET_SENSOR_EVENT_STATUS */
typedef struct Sd09QGetSensorEventStatus {
    UINT8   sensorNumber;
} SD09_Q_GET_SENSOR_EVENT_STATUS;

typedef struct Sd09SGetSensorEventStatus {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   status[2];          /* or [1] */
} SD09_S_GET_SENSOR_EVENT_STATUS;


/*********************** version 1.0 ************************/

/* SD_GET_SENSOR_EVENT_STATUS */
typedef struct Sd10QGetSensorEventStatus {
    UINT8   sensorNumber;
} SD10_Q_GET_SENSOR_EVENT_STATUS;

typedef struct Sd10SGetSensorEventStatus {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   status;
    UINT8   assertionStatus[2];
    UINT8   deassertionStatus[2];
} SD10_S_GET_SENSOR_EVENT_STATUS;


#if defined(IPMI_VER_10)
#define SdQGetSensorEventStatus  Sd10QGetSensorEventStatus
#define SD_Q_GET_SENSOR_EVENT_STATUS SD10_Q_GET_SENSOR_EVENT_STATUS
#define SdSGetSensorEventStatus  Sd10SGetSensorEventStatus
#define SD_S_GET_SENSOR_EVENT_STATUS  SD10_S_GET_SENSOR_EVENT_STATUS
#endif

#if defined(IPMI_VER_09)
#define SdQGetSensorEventStatus  Sd09QGetSensorEventStatus
#define SD_Q_GET_SENSOR_EVENT_STATUS SD09_Q_GET_SENSOR_EVENT_STATUS
#define SdSGetSensorEventStatus  Sd09SGetSensorEventStatus
#define SD_S_GET_SENSOR_EVENT_STATUS  SD09_S_GET_SENSOR_EVENT_STATUS
#endif


/* SD_GET_SENSOR_READING */
typedef struct SdQGetSensorReading {
    UINT8   sensorNumber;
} SD_Q_GET_SENSOR_READING;

#define Sd09QGetSensorReading  SdQGetSensorReading
#define Sd10QGetSensorReading  SdQGetSensorReading
#define SD09_Q_GET_SENSOR_READING  SD_Q_GET_SENSOR_READING
#define SD10_Q_GET_SENSOR_READING  SD_Q_GET_SENSOR_READING

/************************ version 0.9 ***********************/
typedef struct Sd09SGetSensorReading {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   reading[3];         /* or [1] or [2] */
} SD09_S_GET_SENSOR_READING;


/*********************** version 1.0 ************************/
/* readingStatus[0] for threshold sensors */
#define SD_GSR_UPPER_NON_RECOVERABLE    (0x01 << 5)  // at or above UNR
#define SD_GSR_UPPER_CRITICAL           (0x01 << 4)  // at or above UC
#define SD_GSR_UPPER_NON_CRITICAL       (0x01 << 3)  // at or above UNC
#define SD_GSR_LOWER_NON_RECOVERABLE    (0x01 << 2)  // at or below LNR
#define SD_GSR_LOWER_CRITICAL           (0x01 << 1)  // at or below LC
#define SD_GSR_LOWER_NON_CRITICAL        0x01        // at or below LNC

#define SD_GSR_SENSOR_INITIALIZING   0x20

typedef struct Sd10SGetSensorReading {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   readingValue;
    UINT8   sensorStatus;
    UINT8   readingStatus[2];
} SD10_S_GET_SENSOR_READING;

#if defined(IPMI_VER_10)
#define SdQGetSensorReading  Sd10QGetSensorReading
#define SD_Q_GET_SENSOR_READING  SD10_Q_GET_SENSOR_READING
#define SdSGetSensorReading  Sd10SGetSensorReading
#define SD_S_GET_SENSOR_READING  SD10_S_GET_SENSOR_READING
#endif

#if defined(IPMI_VER_09)
#define SdQGetSensorReading  Sd09QGetSensorReading
#define SD_Q_GET_SENSOR_READING  SD09_Q_GET_SENSOR_READING
#define SdSGetSensorReading  Sd09SGetSensorReading
#define SD_S_GET_SENSOR_READING  SD09_S_GET_SENSOR_READING
#endif

#if defined(IPMI_VER_10)

/* SD_SET_SENSOR_TYPE */
typedef struct SdQSetSensorType {
    UINT8   sensorNumber;
    UINT8   sensorType;
    UINT8   eventReadingType;
} SD_Q_SET_SENSOR_TYPE;

typedef struct SdSSetSensorType {
    UINT8   completionCode;     /* IMB_CC_ */
} SD_S_SET_SENSOR_TYPE;


/* SD_GET_SENSOR_TYPE */
typedef struct SdQGetSensorType {
    UINT8   sensorNumber;
} SD_Q_GET_SENSOR_TYPE;

typedef struct SdSGetSensorType {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   sensorType;
    UINT8   eventReadingType;
} SD_S_GET_SENSOR_TYPE;

#endif  /* IPMI_VER_10 */


#endif /* _SD_CMD_H_*/





