/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/**************************************************************************
**  Copyright (C) 1997, Hewlett-Packard Co. All rights reserved.
**
**  File name:  mmcdrv_m.h
**  Summary:    Middle layer of the MMC device driver header
**  Product:    Motherboard Management Controller
**  Owner:      Sonny Talag
**
**  START AUTOMATIC VERSION CONTROL INFORMATION
**  DO NOT MANUALLY EDIT THIS SECTION!
**  $Workfile:   MMCDRV_M.H  
**  $Revision:   1.13  
**  $Date:   20 Oct 1997 23:00:02  
**  $Author:   snichols  
**  END AUTOMATIC VERSION CONTROL INFORMATION
**
**  Description:
**      OS-independent layer of the device driver that manages the message
**      transfer with the MMC.  This layer sits between the OS tunneling
**      functions above and the OS-dependent port input and output
**      functions below.
**
**  Exports:
**  g_dataRegisterAddresses
**  g_flagRegister
**  g_dataRegister
**  g_controlStatusRegister
**  g_driverInUse
***************************************************************************
**  START AUTOMATIC VERSION CONTROL LOG
**  DO NOT MANUALLY EDIT THIS SECTION!
**
**  END AUTOMATIC VERSION CONTROL LOG
**************************************************************************/

extern UINT16 g_dataRegisterAddresses[];
extern UINT16 g_flagRegister;
extern UINT16 g_dataRegister;
extern UINT16 g_controlStatusRegister;

extern int g_driverInUse;

int MMCDRVR_OpenDriver(void);
int MMCDRVR_CloseDriver(void);
int MMCDRVR_SendRcvMessage(UINT8 FAR_PNTR *sbuffer, UINT8 slength, 
	UINT8 FAR_PNTR *rbuffer, UINT8 FAR_PNTR *rlength);
int MMCDRVR_GetVersionNumber(char FAR_PNTR *oem_name, 
	char FAR_PNTR *version_letter, UINT8 FAR_PNTR *version_major, 
	UINT8 FAR_PNTR *version_minor);


