/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/*
//-----------------------------------------------------------------------------
//
// osdepdrv.c - O/S driver dependant code. 
//
// 120294 mlau, copyright Hewlett Packard Co 1994, 1995
// 021094 mlau, added InputByteWDelay, OutputByteWDelay
// 021095 mlau, removed WaitDelay
//
// 031095 mtuttle, added in the Windows NT functionality
// 042797 stalag, removed #includes specific to I2C
// 052897 stalag, reworked the calls to pass integers to avoid compile time 
//                warnings
// 052699 snichols, added support for the Watcom compiler for DOS
//-----------------------------------------------------------------------------
*/

#include "osdepdrv.h"

#if defined _DOS
    #define MS_DOS
#endif

#ifdef MS_DOS
#include "conio.h"                      /* MSDOS sample, for i/o functions */
#endif

#ifdef NLM
#include <conio.h>                      /* netware i/o */
#include <process.h>            /* netware delay */
#endif

#ifdef OS2
#include "drvlib.h"
#include "osdepdrv.h"
#endif

#ifdef LINUX
#include <asm/io.h>
#endif

/*
//-----------------------------------------------------------------------------
//
// UINT8 OutputByte( unsigned port, UINT8 databyte );
//
// input:
//      port            Port number (0x0000 - 0xFFFF)
//      databyte        Output value (0x00 - 0xFF)
// 
// return:
//      The function returns the data output.
// 
// description:
//              Outputs a byte at a port. This function writes byte to specific
// output port. This function will have to be modify internally to satisfy
// different O/S's.  
// 
//-----------------------------------------------------------------------------
*/

UINT8 OutputByte( unsigned port, int databyte ) {

    /* Customize the i/o routines for your o/s  */
    /*                                                                  */
    /* return( output(port, databyte));         */
    /*                                                                  */

#ifdef MS_DOS
#ifdef WATCOM_DOS
    return((UINT8) outp( port, databyte ));
#else
    return((UINT8) _outp( port, databyte ));
#endif // ifdef WATCOM_DOS
#endif // ifdef MS_DOS

#ifdef NLM
    return( outp( port, databyte ));
#endif

#ifdef WINNT

    _outp(port, databyte );

    return( databyte );

#endif /* WINNT */

#ifdef SCO_UNIX
    return(outb( port, databyte ));
#endif

#ifdef OS2
    outb( port, databyte );
    return (UINT8) databyte;
#endif

#ifdef LINUX
    outb(databyte, port);
	return (UINT8) databyte;
#endif

}


/*
//-----------------------------------------------------------------------------
//
// UINT8 InputByte( unsigned port );
//
// input:
//      port            Port number (0x0000 - 0xFFFF)
// 
// return:
//      A byte value read from the port.
// 
// description:
//              Input a byte from a port. This function reads a byte from the
// specified input port. This function will have to be modify internally to
// satisfy different O/S's.
// 
//-----------------------------------------------------------------------------
*/

UINT8 InputByte( unsigned port ) {
    
    /* Customize the i/o routines for your o/s  */
    /*                                                                  */
    /* return( input(port));                                    */
    /*                                                                  */

#ifdef MS_DOS
#ifdef WATCOM_DOS
    return( (UINT8) inp( port ));
#else
    return( (UINT8) _inp( port ));
#endif // ifdef WATCOM_DOS
#endif // ifdef MS_DOS


#ifdef NLM
    return( inp( port ));
#endif

#ifdef WINNT

    return( _inp( port ) );

#endif /* WINNT */

#ifdef SCO_UNIX
    return( inb( port ));
#endif

#ifdef OS2
    return( (UINT8) inb( port ));
#endif

#ifdef LINUX
    return (UINT8) inb(port);
#endif
}

/*
//-----------------------------------------------------------------------------
//
// void DelayByte( );
//
// 
// 
// description:
//              Input a byte from port 80h. This function will have to 
// be modified internally to satisfy different O/S's.
// 
//-----------------------------------------------------------------------------
*/

void DelayByte() 
{
   
    /* Customize the i/o routines for your o/s  */

#ifdef MS_DOS
#ifdef WATCOM_DOS
   inp( DMA_PAGE_REG );
#else
   _inp( DMA_PAGE_REG );
#endif // ifdef WATCOM_DOS
#endif // ifdef MS_DOS


#ifdef NLM
    inp( DMA_PAGE_REG );
#endif

#ifdef WINNT
    int DelayPort = 0x80;
    _inp( DelayPort );
	
#endif /* WINNT */

#ifdef SCO_UNIX
     inb( DMA_PAGE_REG );
#endif

#ifdef OS2
    inb( DMA_PAGE_REG );
#endif

#ifdef LINUX
    inb(DMA_PAGE_REG);
#endif	
}

