/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/*
//-----------------------------------------------------------------------------
//
// osdepdvr.h - os dependant driver file header.
//
// 120294 mlau, copyright Hewlett Packard Co 1994, 1995
// 020995 mlau, moved i/o macros from i2cdrv.c to here
// 021095 mlau, removed WaitDelay
//
// 031095 mtuttle, added the Windows NT stuff between #ifdef WINNT ... #endif
//                 also added #ifdef MSDOS ... #endif      
// 031695 mlau, changed #ifdef MSDOS to #ifdef MS_DOS and added #ifdef NLM
// 042695 mlau, added #ifdef OS2, added FAR_PNTR
// 052897 stalag, defined the UINT8 type
// 061097 ece, removed the *ByteWDelay functions and added DelayByte function
//
//-----------------------------------------------------------------------------
*/

#ifndef UINT8
    #define UINT8 unsigned char
#endif

/*
//
// I/O macros, see i/o functions in osdrvdep.c
//
*/
#ifdef MS_DOS
#define  FAR_PNTR
#endif  /* MS_DOS */

#ifdef WINDOWS
#define  FAR_PNTR
#endif  /* WINDOWS */

#ifdef NLM
#define  FAR_PNTR
#endif  /* NLM */

#ifdef OS2
#define  FAR_PNTR far
#endif  /* OS2 */

#ifdef WINNT
#define  FAR_PNTR
#endif  /* WINNT */

#ifdef SCO_UNIX
#define  FAR_PNTR
#undef EINIT
#endif

#ifdef LINUX
#define  FAR_PNTR
#endif  /* LINUX */

UINT8 OutputByte( unsigned port, int databyte );
UINT8 InputByte( unsigned port );
void  DelayByte();

#define DMA_PAGE_REG        0x80        /* rsvp dma page reg to read to kill time */
