/**************************************************************************
**  Copyright (C) 2001, Hewlett-Packard Co. All rights reserved.
**
**  File name:  dev_sel.h
**  Summary:    Event Log device prototypes
**  Product:    Event log device
**  Owner:      Gustavo Knppe
**
**  START AUTOMATIC VERSION CONTROL INFORMATION
**  DO NOT MANUALLY EDIT THIS SECTION!
**  $Workfile$
**  $Revision: 1.1 $
**  $Date: 2002/01/07 15:43:06 $
**  $Author: gustavo $
**  END AUTOMATIC VERSION CONTROL INFORMATION
**
***************************************************************************
**  START AUTOMATIC VERSION CONTROL LOG
**  DO NOT MANUALLY EDIT THIS SECTION!
**
**  $Log: dev_sel.h,v $
**  Revision 1.1  2002/01/07 15:43:06  gustavo
**  *** empty log message ***
**
**  Revision 1.1  2001/12/26 13:49:01  gustavo
**  *** empty log message ***
**
**  Revision 1.4  2001/12/21 20:15:37  gustavo
**  *** empty log message ***
**
**  Revision 1.3  2001/12/20 20:36:09  gustavo
**  *** empty log message ***
**
**
**  END AUTOMATIC VERSION CONTROL LOG
***************************************************************************/
#ifndef _DEV_SEL_H_
#define _DEV_SEL_H_

#pragma pack( 1 )

#ifdef __cplusplus
extern "C" {
#endif

#include "sel_cmd.h"

#define HPEL_SUCCESS                         0
#define SEL_TYPE                             1
#define NO_NEW_REC                           2

#define HPEL_SELBUSY                         1001

#define HPEL_NO_NEW_RECORD                   NO_NEW_REC

#define HPEL_GENERAL_ERROR                   10000
#define HPEL_ILLEGAL_PARAMETER               10001
#define HPEL_MMC_OPEN_FAILED                 10002
#define HPEL_MMC_RESERVESEL_FAILED           10003
#define HPEL_ADDSELENTRY_FAILED              10004
#define HPEL_MMC_CLOSE_FAILED                10005
#define HPEL_MMC_GETSELENTRY_FAILED          10006
#define HPEL_MAKESELFROMSTRING_FAILED        10007
#define HPEL_RECORD_NOT_FOUND                10008
#define HPEL_MMC_GETSELINFO_FAILED           10009
#define HPEL_MMC_CLEARSELREPOSITORY_FAILED   10010
#define HPEL_FILE_OPEN_FAILED                10011
#define HPEL_FUNCTION_SEMAPHORE_LOCKED       10012

#define MAX_KEY_LENGTH                       256
#define MAX_HPEL_BUFFER_SIZE                 256

#define FIRST_RECORD                         0
#define LAST_RECORD                          0xFFFF

#define EVENT_READ_ALL                       0xFF
#define OFFSET_NONE                          0
                                          
#define MAIN_LOOP_SLEEP                      1000
#define NLM_TASK_SWITCH_SLEEP                1

#define CMD_LINE_NT_EVENT_LOG                "ntel"
#define CMD_LINE_SNMP                        "snmp"
#define CMD_LINE_DMI                         "dmi"
#define CMD_LINE_FILE                        "f"
#define CMD_LINE_DEBUG                       "d"

#define HPEL_SOFT_LOG_FILE_NAME              "evtlog.dat"
#define HPEL_BACKUP_SOFT_LOG_FILE_NAME       "evtlog.bak"
#define HPEL_EVENT_SPEC_FILE_NAME            "evtspec.cfg"
#define HPEL_OUTPUT_LOG_FILE_NAME            "outlog.txt"
#define HPEL_CONFIG_FILE_NAME                "hpevtlog.cfg"

#define HPEL_CONFIG_SECTION                  "hpevtlog"
#define HPEL_LAST_ERASE_TIME                 "LastEraseTime"
#define HPEL_LAST_ERASE_TIME_DEFAULT         0
                                          
#define HPEL_LAST_READ_EVENT                 "LastReadEvent"
#define HPEL_LAST_READ_EVENT_DEFAULT         65535

#define MAX_VARBINDS                         8

#define DECIMAL_RADIX                        10
#define HEX_RADIX                            16

#define LINUX_ROOT                           "/usr/hpserver/etc/"

typedef struct HpelSnmp {
   int snmpId;
} HPEL_SNMP;

typedef struct HpelDmi {
   int dmiId;
} HPEL_DMI;

typedef struct HpelNtel {
   int hpelId;
} HPEL_NTEL;

typedef struct ReportingStruct {
   HPEL_SNMP   snmpInfo;
   HPEL_DMI    dmiInfo;
   HPEL_NTEL   ntelInfo;
} REPORTING;

typedef struct EvtStruct {
   SEL         selEntry;

   int         convertedReading;
   int         convertedThreshold;

   char        szAddString[MAX_HPEL_BUFFER_SIZE];       // Possibly passed in during the HPEL_WriteEvent call.
   char        szEventString[MAX_HPEL_BUFFER_SIZE];     // filled during translation using evtspec.cfg
   REPORTING   reportingInfo;
} HPEL_EVENT;

#ifdef __cplusplus
}
#endif

#endif // #ifndef _DEV_SEL_H




