#ifdef __KERNEL__

#ifdef __NO_VERSION__
#error __NO_VERSION__ must not be defined
#endif

#include <linux/version.h>

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0))

# ifndef MODULE
#  define MODULE
# endif

# include <linux/autoconf.h>
# if defined(CONFIG_MODVERSIONS) && !defined(MODVERSIONS)
#  define MODVERSIONS
# endif

# ifdef MODVERSIONS
#  include <linux/modversions.h>
# endif

#endif

#include <linux/time.h>
#include <asm/string.h>
#include <linux/ctype.h>
#include <linux/kernel.h>

#else //shell

#include <time.h>
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#define	printk	printf

#endif

#include "show_sel.h"
#include "dev_sel.h"
#include "mmc_dev.h"
#include "mmc_func.h"
#include "msg_sel.h"
#include "sdrdesc.h"
#include "logtime.h"

static Byte rgThresholdTriggers[ ] = { 1, 0 };
static Byte rgDigitalTriggers[ ]   = { 3, 4,    5,    6,    8,    9, 0 };
static Byte rgDiscreteTriggers[ ]  = { 2, 7, 0x0A, 0x0B, 0xE6, 0xE7, 0 };

Flag EventIsType (Byte eventTrigger, Byte *prgTriggers) {
	Index iTrigger;
	for (iTrigger = 0; (prgTriggers[iTrigger] && (prgTriggers[iTrigger] != eventTrigger)) ; iTrigger ++) ;
	return ( prgTriggers[iTrigger] != 0 );
}

int strncasecmp( const char * cs , const char * ct ,size_t count) {
	size_t Pos = 0;
	int iRet = 0;
	
	while ( (Pos < count) && (iRet==0) ) {
		iRet = (int)tolower( cs[Pos] ) - (int)tolower(ct[Pos]);
		Pos++;
	}
	return iRet;
}

static int atoi(const char *name) {
	int val = 0;
	for (;; name++) {
		switch (*name) {
			case '0'...'9':
				val = 10*val+(*name-'0');
				break;
			default:
				return val;
		}
	} 
}

void MapData1_2to3 (SEL *pSEL) {
	const  Index iDataCntl         = (pSEL->eventData1 >> 5);
	static Byte rgMapThreshold[8] = { 0x80, 0x90, 0xA0, 0x80, 0x40, 0x50, 0x60, 0x40 };
	static Byte rgMapDigital[8]   = { 0x40, 0x50, 0x60, 0x50, 0x00, 0x00, 0x00, 0x00 };
	static Byte rgMapDiscrete[8]  = { 0x80, 0x20, 0xA0, 0x90, 0x40, 0x60, 0x60, 0x50 };
	static Byte rgMapOEM[8]       = { 0x00, 0x80, 0x20, 0xA0, 0x40, 0x40, 0x60, 0x60 };
	
	if (pSEL->eventVersion == 3)
		return;
	pSEL->eventData1 &= 0x0F;
	if ( ThresholdEvent(pSEL->eventTrigger) )
		pSEL->eventData1 |= rgMapThreshold[iDataCntl];
	else if (DigitalEvent (pSEL->eventTrigger))
		pSEL->eventData1 |= rgMapDigital[iDataCntl];
	else if (DiscreteEvent (pSEL->eventTrigger))
		pSEL->eventData1 |= rgMapDiscrete[iDataCntl];
	else
		pSEL->eventData1 |= rgMapOEM[iDataCntl];
}

void MapTrigger_2to3 (SEL *pSEL) {
	const Byte trigger = pSEL->eventTrigger;
	if (pSEL->eventVersion == 3)
		return;
	if (trigger == 0xE6)
		pSEL->eventTrigger = (0x80 | 0x6F);
	else if (trigger == 0xE7)
		pSEL->eventTrigger = 0x6F;
	else if ((trigger >= 0xE8) && (trigger < 0xF0))
		pSEL->eventTrigger -= 0x78;
}

void MapEventRecord2to3 (SEL *pSEL) {
	if (pSEL->eventVersion != 2)
		return;
	MapTrigger_2to3 (pSEL);
	MapData1_2to3 (pSEL);
	pSEL->eventVersion = 3;
}

static char* itoa(int i, char* szBuf, int base) {
	switch (base) {
		case 16:
			sprintf(szBuf, "%X", i);
			break;
		default:
			sprintf(szBuf, "%d", i);
			break;
	}
	return szBuf;
}

static int IsConvertedReading( char *p ) {
   return( strnicmp( p, CONVERTED_READING  , strlen(CONVERTED_READING)  ) == 0 );
}

static int IsConvertedThreshold( char *p ) {                                                  
   return( strnicmp( p, CONVERTED_THRESHOLD, strlen(CONVERTED_THRESHOLD)) == 0 );
}

static int IsLocationString( char *p ) {
   return( strnicmp( p, LOCATION_STRING    , strlen(LOCATION_STRING)    ) == 0 );
}

static int IsSensorNumber( char *p ) {
   return( strnicmp( p, SENSOR_NUMBER      , strlen(SENSOR_NUMBER)      ) == 0 );
}

static int IsString( char c ) {
   return( tolower( c ) == STRING_CHARACTER );
}

static int IsUpper( char c ) {
   return( tolower( c ) == UPPER_CHARACTER );
}

static int IsLower( char c ) {
   return( tolower( c ) == LOWER_CHARACTER );
}

static int IsMask( char c ) {
   return( tolower( c ) == MASK_CHARACTER );
}

static int IsHex( char c ) {
   return( tolower( c ) == HEX_CHARACTER );
}

static int IsBinDigit( char c ) {
   return( c == '0' || c == '1' );
}

static int IsByte( char c ) {
   return( tolower( c ) == BYTE_CHARACTER );
}

void GetToken( char *szToken, SEL *selEntry, void *pOutput, size_t iSizeOut ) {
	char    *pSource, *pDest;
	int      bHex   = 0;
	int      bError = 0;
	UINT16   nData = 0;
	UINT8    nByte = 0;
	UINT16   nMask = 0;
	char     szTemp[MAX_HPEL_BUFFER_SIZE];
	
	pSource = szToken;
	pDest = (char *)pOutput;
	
	while( *pSource ) {
		if( IsConvertedReading( pSource ) ) {
			strncpy( pDest, "ConvertedThreshold", iSizeOut );
			return;
		} else if( IsConvertedThreshold( pSource ) ) {
			strncpy( pDest, "ConvertedThreshold", iSizeOut );
			return;
		} else if( IsLocationString( pSource ) ) {
			int error;
			char szLocStr[MAX_HPEL_BUFFER_SIZE];
			
			szLocStr[0] = '[';
			szLocStr[1] = 0;
			error = HPEL_GetSdrDescription( selEntry, &szLocStr[1], MAX_HPEL_BUFFER_SIZE-1 );
			if ( error )
				strncpy( &szLocStr[1], "No Information]", MAX_HPEL_BUFFER_SIZE-1 );
			else 
				strncat( szLocStr, "]", 1 );
			strncpy( pDest, szLocStr, iSizeOut );
			return;
		} else if( IsSensorNumber( pSource ) ) {
			strncpy( pDest, itoa( selEntry->sensorNumber, szTemp, DECIMAL_RADIX ), iSizeOut  );
			return;
			
		// If this is a byte delimeter, get all the parameters that affect this value,
		// calculate the value, write it to the dest and finish.
		} else if( IsByte( *pSource ) ) 
			{
			// Get the byte value.
			nByte = (char)atoi( ++pSource );
			// Past the byte value
			pSource++;
			// Used switch for later expansion possibility.
			switch( nByte ) {
				case 2:
					nData = selEntry->eventData2;
					break;
				case 3:
					nData = selEntry->eventData3;
					break;
				default:
					bError = TRUE;
					break;
			}
			if( IsUpper( *pSource ) ) {
				// Move the data over.
				nData <<= 8;
				// Get past the Upper char.
				nByte = (char)atoi( ++pSource );
				// Past the byte value
				pSource++;
				// Used switch for later expansion possibility.
				switch( nByte ) {
					case 2:
						nData += selEntry->eventData2;
						break;
					case 3:
						nData += selEntry->eventData3;
						break;
					default:
						bError = TRUE;
						break;
				}
				// Check forfinishing format
				if( !IsLower( *pSource ) ) {
					bError = TRUE;
					break;
				}
				// Get past the Lower char.
				pSource++;
			}
			// Addition modifiers.
			while( *pSource ) {
				if( IsHex( *pSource ) ) {
					pSource++;
					bHex = TRUE;
				}
				// Check for mask value.
				else if( IsMask( *pSource ) ) {
					// Get past the mask delimeter.
					pSource++;
					while( IsBinDigit( *pSource ) ) {
						// New digit shift left.
						nMask <<= 1;
						nMask += ( *pSource == '0' ? 0 : 1 );
						pSource++;
					}
					// If a valid mask was found, modify the byte value.
					if( nMask != 0 ) {
						// Rotate to the first non-zero digit.
						while( !( nMask & 0x01 ) ) {
							nData >>= 1;
							nMask >>= 1;
						}
						nData &= nMask;
					}
				}
				else
					break;
			}
			// Write out the value to the destination.
			itoa( nData, szTemp, ( bHex ? HEX_RADIX : DECIMAL_RADIX ) );
			strncpy( pDest, szTemp, iSizeOut );
			return;
		// If this is a string, return "No Data" because the additional strings isn't possible to being acquire.
		} else if( IsString( *pSource ) ) {
			strncpy( pDest, HPELFMT_NO_DATA, iSizeOut );
			return;
		}
	}
	if( bError ) {
		strncpy( pDest, HPELFMT_BAD_FORMAT, iSizeOut  );
	}
}

int ReadKey( SEL *selEntry, char *lpszDestination, UINT32 *lpdwByteCount ) {
	short bFound, iVarBind;
	int iIndex, iLenSeverity, iLenDestination;
	char sVar[10], sVarbind[ MAX_HPEL_BUFFER_SIZE ], *sVarFound, *szToken, szSpaces[16];
	char szChange[MAX_HPEL_BUFFER_SIZE];
	UINT8 *pSensorType   = &(selEntry->sensorType);
	UINT8 *pEventTrigger = &(selEntry->eventTrigger);
	UINT8 *pOffset       = &(selEntry->eventData1);
	
	if ( (pSensorType == NULL) || (pEventTrigger == NULL) || (pOffset == NULL) ) {
		sprintf(lpszDestination, "Unknown        Unknown Event [%02X %02X %02X]", *pSensorType, *pEventTrigger, (*pOffset & 0x0F) );
		*lpdwByteCount = strlen( lpszDestination );
		return( HPEL_SELBUSY );
	}
	
	iIndex = 0;
	bFound = 0;
	while ( (!bFound) && (iIndex<MSG_INFO_SEL_LENGTH) ) {
		if ( ( s_SelInfo[iIndex].SensorType ==  *pSensorType     ) && 
		     ( s_SelInfo[iIndex].EvtTrigger ==  *pEventTrigger   ) && 
		     ( s_SelInfo[iIndex].Offset     == (*pOffset & 0x0F) ) ) {
				bFound = 1;
				/* complete with space on end to aline the columns */
				strncpy(szSpaces, "              ", 16 );
				iLenSeverity = strlen( s_SelInfo[iIndex].szSeverity );
				if ( iLenSeverity > 15 )
					iLenSeverity = 15;
				szSpaces[ 15 - iLenSeverity ] = 0;
				strncpy( lpszDestination, s_SelInfo[iIndex].szSeverity, *lpdwByteCount );
				iLenDestination = strlen( lpszDestination );
				strncat( lpszDestination, szSpaces                    , *lpdwByteCount - iLenDestination );
				iLenDestination = strlen( lpszDestination );
				strncat( lpszDestination, s_SelInfo[iIndex].szString  , *lpdwByteCount - iLenDestination );
		} else
			iIndex++;
	}
	/* to be found the string, search its varbinds. */
	if( bFound ) {
		int iAlreadyLoaded;
		iVarBind = 0;
		do	{
			sprintf( sVar, "%%%d", (iVarBind+1) );
			sVarFound = strstr( lpszDestination, sVar );
			if ( sVarFound != NULL ) {
				szToken = s_SelInfo[iIndex].szVarBind[iVarBind];
				GetToken( szToken, selEntry, sVarbind, MAX_HPEL_BUFFER_SIZE );
				strncpy( szChange, lpszDestination, MAX_HPEL_BUFFER_SIZE );
				szChange[ (sVarFound - lpszDestination) ] = 0;
				iAlreadyLoaded = strlen(szChange);
				strncat( szChange, sVarbind, MAX_HPEL_BUFFER_SIZE - iAlreadyLoaded );
				iAlreadyLoaded = strlen(szChange);
				strncat( szChange, sVarFound + (strlen(sVar)), MAX_HPEL_BUFFER_SIZE - iAlreadyLoaded );
				strncpy( lpszDestination, szChange, *lpdwByteCount );
				iVarBind++;
			}
		} while ( sVarFound != NULL );
		*lpdwByteCount = strlen( lpszDestination );
		
	} else {
		sprintf(lpszDestination, "Unknown        Unknown Event [%02X %02X %02X]", *pSensorType, *pEventTrigger, (*pOffset & 0x0F) );
		*lpdwByteCount = strlen( lpszDestination );
	}
	return( bFound ? HPEL_SUCCESS : HPEL_SELBUSY );
}

int SEL_ShowEvent( char *buf, int iIndex, SEL *selEntry, int count ) {
	struct rtc_time *pTime;
	int iShow = 0;
	int cbValue;
	char m_szDescription[MAX_HPEL_BUFFER_SIZE];
	char szStrCtrl[10];
	if( selEntry == NULL ) {
		printk("<1> [seldev] Bagging on NULL selEntry.\n" );
		return 0;
	}
	if( selEntry->eventVersion == 0 )
		selEntry->eventVersion = SEL_EV_STANDARD2;

	selEntry->timestamp = ConvertHWLogTime(  (time_t)selEntry->timestamp );
	
	MapEventRecord2to3( selEntry );
	pTime = gmtimek( (time_t*)&(selEntry->timestamp) );
	
	cbValue = sizeof(m_szDescription);
	ReadKey( selEntry, m_szDescription, (UINT32*)&cbValue);
	
	if ( pTime ) {
		iShow += sprintf( &buf[count+iShow], "%5d  %02d-%02d-%04d %02d:%02d:%02d  ", iIndex, pTime->tm_mon + 1, pTime->tm_mday, pTime->tm_year + 1900, pTime->tm_hour, pTime->tm_min, pTime->tm_sec );
	} else {                           //     "##/##/#### ##:##:##  "   
		iShow += sprintf( &buf[count+iShow], "%5d  no date    no time   ", iIndex );
	}
	sprintf( szStrCtrl, "%%.%ds\n", cbValue );
	iShow += sprintf( &buf[count+iShow], szStrCtrl /*"%s\n"*/, (const char *)m_szDescription );

	return iShow;
}
