#
# spec file for package ucdsnmp (Version 4.2.3)
#
# Copyright (c) 2002 SuSE Linux AG, Nuernberg, Germany.
# This file and all modifications and additions to the pristine
# package are under the same license as the package itself.
#
# please send bugfixes or comments to feedback@suse.de.
#

# neededforbuild  autoconf automake tcpd
# usedforbuild    aaa_base aaa_dir aaa_version autoconf automake base bash bindutil binutils bison bzip compress cpio cpp cracklib cyrus-sasl db devs diffutils e2fsprogs file fileutils findutils flex gawk gcc gdbm gdbm-devel gettext glibc glibc-devel gpm gppshare grep groff gzip kbd less libtool libz m4 make man mktemp modutils ncurses ncurses-devel net-tools netcfg pam pam-devel patch perl ps rcs readline rpm sendmail sh-utils shadow strace syslogd sysvinit tcpd texinfo textutils timezone unzip util-linux vim

Name:         ucdsnmp
Copyright:    GPL
Version:      4.2.3
Release:      79
Summary:      UCD SNMP daemon
Group:        Networking/Daemons
URL:          http://sourceforge.net/projects/net-snmp
Provides:    snmp
Obsoletes:   snmp
#Requires:    
Autoreqprov: on
BuildRoot:    %{_tmppath}/%{name}-%{version}-build
Source:      ucd-snmp-%{version}.tar.bz2
Source1:     rc.config.snmp
Source2:     rc.ucd-snmp
Source3:     ucdsnmp.conf
Patch:       ucd-snmp-4.2.3-audit.diff
Patch1:	     ucd-snmp-4.2.3-destdir.diff
Patch2:	     snmp_api-64bit.diff

%description
UCD SNMP daemon.

Authors:
--------
    Wes Hardaker <wjhardaker@ucdavis.edu>

SuSE series: n

%prep
%setup -q -n ucd-snmp-%{version}
%patch -p1
%patch1 -p1
%patch2 -p1

%build
autoconf
export CFLAGS="$RPM_OPT_FLAGS -D_GNU_SOURCE -I/usr/include/db1 -Wall"
	./configure --build=i386-linux --host=i386-linux --prefix=/usr \
	--bindir=/usr/bin --sbindir=/usr/sbin \
	--with-sys-contact="root@localhost" \
	--with-logfile=/var/log/ucd-snmp.log \
	--with-mib-modules="host ucd-snmp/pass_persist" \
	--with-persistent-directory=/var/ucd-snmp \
	--with-sys-location="unknown" \
        --with-libwrap=%_prefix \
	--with-defaults \
	--without-root-access \
        --libdir=%{_libdir} \
	--mandir=%{_mandir} \
	--enable-shared
make

%install
rm -Rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/etc/init.d
mkdir -p $RPM_BUILD_ROOT/var/adm/fillup-templates
mkdir -p $RPM_BUILD_ROOT/usr/sbin
make DESTDIR=$RPM_BUILD_ROOT install
install -m 555 %{SOURCE1} $RPM_BUILD_ROOT/var/adm/fillup-templates/rc.config.snmp
install -m 755 %{SOURCE2} $RPM_BUILD_ROOT/etc/init.d/snmpd
install -m 600 %{SOURCE3} $RPM_BUILD_ROOT/etc/ucdsnmpd.conf
ln -sf ../../etc/init.d/snmpd $RPM_BUILD_ROOT/usr/sbin/rcsnmpd

%post
echo "Updating etc/rc.config..."
if [ -x bin/fillup ] ; then
  bin/fillup -q -d = etc/rc.config var/adm/fillup-templates/rc.config.snmp
else
  echo "ERROR: fillup not found. This should not happen. Please compare"
  echo "etc/rc.config and var/adm/fillup-templates/rc.config.snmp and"
  echo "update by hand."
fi
# Create symbolic run level links during installation
sbin/insserv etc/init.d/snmpd
exit 0

%postun
# Rearrange run level symlinks after removing the init script
sbin/insserv etc/init.d/
exit 0

%files
%config(noreplace) /etc/ucdsnmpd.conf
%config /etc/init.d/snmpd
%config /var/adm/fillup-templates/rc.config.snmp
%doc AGENT.txt COPYING ChangeLog EXAMPLE.conf EXAMPLE.conf.def FAQ NEWS PORTING README README.cmu README.snmpv3 TODO README.thread
/usr/bin/*
/usr/include/ucd-snmp
%_libdir/lib*.so
%doc %{_mandir}/man1/*.1.gz
%doc %{_mandir}/man3/*.3.gz
%doc %{_mandir}/man5/*.5.gz
%doc %{_mandir}/man8/*.8.gz
/usr/sbin/*
/usr/share/snmp
/var/ucd-snmp

%changelog -n ucdsnmp
* Mon Mar 25 2002 - ckm@suse.de
- added thomas's patch to fix the truncation of interfaces names
  and merged with mt's cleaned up patch from fw-cd.
* Fri Mar 08 2002 - ckm@suse.com
- fixed sscanf format problems
* Sun Mar 03 2002 - bk@suse.de
- add 64-bit fix for snmp_api.c
- don't use /usr/lib, use %%_libdir instead
* Sat Mar 02 2002 - kukuk@suse.de
- Fix filelist
- Add tcpd to neededforbuild
* Fri Mar 01 2002 - bk@suse.de
- use %%_libdir
* Thu Feb 28 2002 - ckm@suse.com
- updated to version 4.2.3
- applied T. Biege's audit patches which addresses security issues
  raised in CERT Advisory CA-2002-03
* Wed Sep 05 2001 - hmuelle@suse.de
- fixed an string format issues by ucd-snmp-4.2.1-bufferoverflow.dif
  strcpy => strncpy
* Wed Aug 15 2001 - hmuelle@suse.de
- splittet up old patches in parts with speaking names
- added configure option --without-root-access
- added security fixes:
  * ucd-snmp-4.2.1-security.dif
  /tmp race and setgroups() privilege problem
  * ucd-snmp-4.2.1-security2.dif
  Various buffer overflow and format string issues.
  * ucd-snmp-4.2.1-security3.dif
  One signedness problem in ASN handling.
* Fri Apr 27 2001 - grimmer@suse.de
- fix typo in init script (#7326)
- extracted init script and rc.config entry from diff and added
  them as separate source files instead
- corrected some typos
* Mon Apr 09 2001 - ro@suse.de
- updated start-script
* Mon Apr 09 2001 - ro@suse.de
- update to 4.2.1
- use buildroot
* Thu Feb 08 2001 - ro@suse.de
- use -D_GNU_SOURCE
* Tue Jan 02 2001 - olh@suse.de
- use script name in %%post
* Fri Dec 01 2000 - ro@suse.de
- fixed startscript
* Wed Nov 22 2000 - ray@suse.de
- set START_SNMPD="no" in rc.config
- include a default configfile (/etc/ucdsnmpd.conf)
  default rights: read system mib only from the world
* Tue Nov 21 2000 - ro@suse.de
- added Obsoletes and Requires snmp (snmp is dropped)
* Thu Jul 06 2000 - @suse.de
- fix wrong .so entries in manpages
- use __linux__ in preprocessor tests as that's allways predefined
- don't add -Dlinux to CFLAGS for Linux
* Mon Apr 10 2000 - ro@suse.de
- removed extra mib misc/ipfwacc (not in package)
* Mon Apr 10 2000 - ro@suse.de
-update to 4.1.1
* Thu Mar 02 2000 - uli@suse.de
- moved man pages to %%{_mandir}
* Tue Feb 22 2000 - ro@suse.de
- fix building of shared-lib (still has no version)
* Tue Feb 22 2000 - ray@suse.de
- --enable-shared
* Fri Sep 24 1999 - ray@suse.de
- created package, version 4.0.1
