/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/**************************************************************************
**  Copyright (C) 1997-1999, Hewlett-Packard Co. All rights reserved.
**
**  File name:  chas_cmd.h
**  Summary:    IMB Chassis Command Definitions
**
**************************************************************************/

/* Application NetFn (IMB_NF_CHASSIS_) Global Commands */

#if defined(IPMI_VER_10)
#define GET_CHASSIS_STATUS      0x01
#endif

#define CHASSIS_CONTROL		0x02


#if defined(IPMI_VER_10)
/* GET_CHASSIS_STATUS */

typedef void GET_Q_CHASSIS_STATUS;

/*  powerState  */
/* reserved                             0x80 */
/* reserved                             0x40 */
#define CHAS_CS_POWER_RESTORE_POLICY    0x20
#define CHAS_CS_POWER_CONTROL_FAULT     0x10
#define CHAS_CS_POWER_FAULT             0x08
/* reserved                             0x04 */
#define CHAS_CS_POWER_OVERLOAD          0x02
#define CHAS_CS_POWER_IS_ON             0x01

/*  lastPowerEvent  */
/* reserved                             0x80 */
/* reserved                             0x40 */
#define CHAS_CS_LAST_EVENT_IPMI_ON      0x10
#define CHAS_CS_LAST_EVENT_POWER_FAULT  0x08
/* reserved                             0x04 */
#define CHAS_CS_LAST_EVENT_OVERLOAD     0x02
#define CHAS_CS_LAST_EVENT_AC_FAIL      0x01

/* miscChassisState  */
/* reserved                               0x80 */
/* reserved                               0x40 */
/* reserved                               0x20 */
/* reserved                               0x10 */
#define CHAS_CS_COOLING_FAULT_DETECTED    0x08
/* reserved                               0x04 */
#define CHAS_CS_SECURE_MODE_ACTIVE        0x02
#define CHAS_CS_CHASSIS_INTRUSION_ACTIVE  0x01

typedef struct GetSChassisStatus {
    UINT8 completionCode;
    UINT8 powerState;
    UINT8 lastPowerEvent;
    UINT8 miscChassisState;
} GET_S_CHASSIS_STATUS;
#endif

/* CHASSIS_CONTROL */

#define CHAS_POWER_DOWN		     0x00
#define CHAS_POWER_UP                0x01
#define CHAS_POWER_CYCLE             0x02
#define CHAS_HARD_RESET              0x03
#define CHAS_PULSE_FP_NMI            0x04

typedef struct ChassisQControl {
    UINT8 controlCommand;
} CHASSIS_Q_CONTROL;

typedef struct ChassisSControl {
    UINT8 completionCode;
} CHASSIS_S_CONTROL;

	
