/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/**************************************************************************
**  Copyright (C) 1997-1999, Hewlett-Packard Co. All rights reserved.
**
**  File name:  flsh_cmd.h
**  Summary:    IMB Flash Command Definitions
**
**************************************************************************/

#ifndef _FLSH_CMD_H_
#define _FLSH_CMD_H_

#include	"imb_std.h"	/* IMB OS-Dependent Standard Types */
#include	"imb_cmd.h"	/* IMB Common Command Definitions */

/* Firmware NetFn (IMB_NF_FIRMWARE_) Commands */
	/* 00..BF */
#define FLSH_ENTER_FIRMWARE_TRANSFER_MODE  0xC0
#define FLSH_SET_FIRMWARE_TRANSFER_ADDRESS 0xC1
#define FLSH_FIRMWARE_PROGRAM		   0xC2
#define FLSH_GET_FIRMWARE_RANGE_CHECKSUM   0xC3
#define FLSH_FIRMWARE_READ		   0xC4
#define FLSH_EXIT_FIRMWARE_TRANSFER_MODE   0xC5
#define FLSH_FIRMWARE_COMMIT               0xC6
#define	FLSH_GET_FIRMWARE_PROGRAM_ATTRIBUTES 0xC7
#define	FLSH_ENABLE_BOOT_BLOCK_LOCKOUT     0xC8
	/* C7..FE */
	/* FF: IMB_ERROR_REPORT */


/* FLSH_ENTER_FIRMWARE_TRANSFER_MODE */
typedef struct FlshQEnterFirmwareTransferMode {
    UINT8   password[2];	/* "HP" */
} FLSH_Q_ENTER_FIRMWARE_TRANSFER_MODE;

typedef struct FlshSEnterFirmwareTransferMode {
    UINT8   completionCode;	/* IMB_CC_ */
} FLSH_S_ENTER_FIRMWARE_TRANSFER_MODE;


/* FLSH_SET_FIRMWARE_TRANSFER_ADDRESS */
typedef struct FlshQSetFirmwareTransferAddress {
    UINT8   addressLo;
    UINT8   addressMid;
    UINT8   addressHi;
} FLSH_Q_SET_FIRMWARE_TRANSFER_ADDRESS;

typedef struct FlshSSetFirmwareTransferAddress {
    UINT8   completionCode;	/* IMB_CC_ */
    UINT8   programmingStatus;
} FLSH_S_SET_FIRMWARE_TRANSFER_ADDRESS;


/* FLSH_FIRMWARE_PROGRAM */
typedef struct FlshQFirmwareProgram {
    UINT8   progData[IMB_MAX_DATA_LEN];
} FLSH_Q_FIRMWARE_PROGRAM;

typedef struct FlshSFirmwareProgram {
    UINT8   completionCode;	/* IMB_CC_ */
    UINT8   bufferedBytes;
    UINT8   programmingStatus;
} FLSH_S_FIRMWARE_PROGRAM;


/* FLSH_GET_FIRMWARE_RANGE_CHECKSUM */
typedef struct FlshQGetFirmwareRangeChecksum {
    UINT8   startAddressLo;
    UINT8   startAddressMid;
    UINT8   startAddressHi;
    UINT8   endAddressLo;
    UINT8   endAddressMid;
    UINT8   endAddressHi;
} FLSH_Q_GET_FIRMWARE_RANGE_CHECKSUM;

typedef struct FlshSGetFirmwareRangeChecksum {
    UINT8   completionCode;	/* IMB_CC_ */
    UINT8   programming1Status;
    UINT8   programming2Status;
    UINT8   startAddressLo;
    UINT8   startAddressMid;
    UINT8   startAddressHi;
    UINT8   endAddressLo;
    UINT8   endAddressMid;
    UINT8   endAddressHi;
    UINT8   checksumLo;
    UINT8   checksumHi;
} FLSH_S_GET_FIRMWARE_RANGE_CHECKSUM;


/* FLSH_FIRMWARE_READ */
typedef struct FlshQFirmwareRead {
    UINT8   length;
} FLSH_Q_FIRMWARE_READ;

typedef struct FlshSFirmwareRead {
    UINT8   completionCode;	/* IMB_CC_ */
    UINT8   readData[IMB_MAX_DATA_LEN-1];
} FLSH_S_FIRMWARE_READ;


/* FLSH_EXIT_FIRMWARE_TRANSFER_MODE */
typedef void FLSH_Q_EXIT_FIRMWARE_TRANSFER_MODE;

typedef struct FlshSExitFirmwareTransferMode {
    UINT8   completionCode;	/* IMB_CC_ */
} FLSH_S_EXIT_FIRMWARE_TRANSFER_MODE;


/* FLSH_FIRMWARE_COMMIT */
typedef struct FlshQFirmwareCommit {
    UINT8   password[6];	/* "COMMIT" */
} FLSH_Q_FIRMWARE_COMMIT;

typedef struct FlshSFirmwareCommit {
    UINT8   completionCode;	/* IMB_CC_ */
} FLSH_S_FIRMWARE_COMMIT;

/* FLSH_GET_FIRMWARE_PROGRAM_ATTRIBUTES */
typedef void FLSH_Q_GET_FIRMWARE_PROGRAM_ATTRIBUTES;

typedef struct FlshSGetFirmwareProgramAttributes {
    UINT8   completionCode;	/* IMB_CC_ */
    UINT8   bootProtected;	/* 0 (no) or 1 (yes) */
    UINT32  programChunkSize;
} FLSH_S_GET_FIRMWARE_PROGRAM_ATTRIBUTES;

/* FLSH_ENABLE_BOOT_BLOCK_LOCKOUT */
typedef struct FlshQEnableBootBlockLockout {
    UINT8   password[4];	/* "LOCK" */
} FLSH_Q_ENABLE_BOOT_BLOCK_LOCKOUT;

typedef struct FlshSEnableBootBlockLockout {
    UINT8   completionCode;	/* IMB_CC_ */
} FLSH_S_ENABLE_BOOT_BLOCK_LOCKOUT;


#endif	/* _FLSH_CMD_H_ */
