/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/**************************************************************************
**  Copyright (C) 1997-1999, Hewlett-Packard Co. All rights reserved.
**
**  File name:  fru_cmd.h
**  Summary:    IMB FRU Command Definitions
**
**************************************************************************/

#ifndef _FRU_CMD_H_
#define _FRU_CMD_H_

#include        "imb_std.h"     /* IMB OS-Dependent Standard Types */
#include        "imb_cmd.h"     /* IMB Common Command Definitions */

/* Storage NetFn (IMB_NF_STORAGE_REQ) FRU Commands */
#define FRU_GET_FRU_INVENTORY_AREA_INFO 0x10
#define FRU_READ_FRU_INVENTORY_DATA     0x11
#define FRU_WRITE_FRU_INVENTORY_DATA    0x12

/* for completeness for unchanging codes whose data structures vary */
#define FRU09_READ_FRU_INVENTORY_DATA   FRU_READ_FRU_INVENTORY_DATA
#define FRU10_READ_FRU_INVENTORY_DATA   FRU_READ_FRU_INVENTORY_DATA
#define FRU09_WRITE_FRU_INVENTORY_DATA  FRU_WRITE_FRU_INVENTORY_DATA
#define FRU10_WRITE_FRU_INVENTORY_DATA  FRU_WRITE_FRU_INVENTORY_DATA

/* FRU_GET_FRU_INVENTORY_AREA_INFO */
/*   version 0.9 */
typedef void FRU09_Q_GET_FRU_INVENTORY_AREA_INFO;

#define Fru09SGetFruInventoryAreaInfo       FruSGetFruInventoryAreaInfo
#define FRU09_S_GET_FRU_INVENTORY_AREA_INFO FRU_S_GET_FRU_INVENTORY_AREA_INFO

/*   version 1.0 */
typedef struct Fru10QGetFruInventoryAreaInfo {
    UINT8   deviceId;
} FRU10_Q_GET_FRU_INVENTORY_AREA_INFO;


#define Fru10SGetFruInventoryAreaInfo       FruSGetFruInventoryAreaInfo
#define FRU10_S_GET_FRU_INVENTORY_AREA_INFO FRU_S_GET_FRU_INVENTORY_AREA_INFO

/*   current version */
#if     defined(IPMI_VER_09)
#define FruQGetFruInventoryAreaInfo         Fru09QGetFruInventoryAreaInfo
#define FRU_Q_GET_FRU_INVENTORY_AREA_INFO   FRU09_Q_GET_FRU_INVENTORY_AREA_INFO
#else
#define FruQGetFruInventoryAreaInfo         Fru10QGetFruInventoryAreaInfo
#define FRU_Q_GET_FRU_INVENTORY_AREA_INFO   FRU10_Q_GET_FRU_INVENTORY_AREA_INFO
#endif  /* IPMI_VER_10 */

typedef struct FruSGetFruInventoryAreaInfo {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT16  fruInventoryAreaSize;
    UINT8   fruAccessSize;      /* 0: bytes, 1: words */
} FRU_S_GET_FRU_INVENTORY_AREA_INFO;


/* FRU_READ_FRU_INVENTORY_DATA */
/*   version 0.9 */
typedef struct Fru09QReadFruInventoryData {
    UINT16  fruInventoryOffset;
    UINT8   readRequestCount;
} FRU09_Q_READ_FRU_INVENTORY_DATA;

#define Fru09SReadFruInventoryData          FruSReadFruInventoryData
#define FRU09_S_READ_FRU_INVENTORY_DATA     FRU_S_READ_FRU_INVENTORY_DATA

/*   version 1.0 */
typedef struct Fru10QReadFruInventoryData {
    UINT8   deviceId;
    UINT16  fruInventoryOffset;
    UINT8   readRequestCount;
} FRU10_Q_READ_FRU_INVENTORY_DATA;

#define Fru10SReadFruInventoryData          FruSReadFruInventoryData
#define FRU10_S_READ_FRU_INVENTORY_DATA     FRU_S_READ_FRU_INVENTORY_DATA


#if    defined(IPMI_VER_09)
#define FruQReadFruInventoryArea            Fru09QReadFruInventoryArea
#define FRU_Q_READ_FRU_INVENTORY_DATA       FRU09_Q_READ_FRU_INVENTORY_DATA
#else
#define FruQReadFruInventoryArea            Fru10QReadFruInventoryArea
#define FRU_Q_READ_FRU_INVENTORY_DATA       FRU10_Q_READ_FRU_INVENTORY_DATA
#endif  /* IPMI_VER_10 */

typedef struct FruSReadFruInventoryData {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   readActualCount;
    UINT8   inventoryData[IMB_MAX_DATA_LEN-2];
} FRU_S_READ_FRU_INVENTORY_DATA;


/* FRU_WRITE_FRU_INVENTORY_DATA */
/*   version 0.9 */
typedef struct Fru09QWriteFruInventoryData {
    UINT16  fruInventoryOffset;
    UINT8   inventoryData[IMB_MAX_DATA_LEN-2];
} FRU09_Q_WRITE_FRU_INVENTORY_DATA;

#define Fru09SWriteFruInventoryData         FruSWriteFruInventoryData
#define Fru10SWriteFruInventoryData         FruSWriteFruInventoryData

/*   version 1.0 */
typedef struct Fru10QWriteFruInventoryData {
    UINT8   deviceId;
    UINT16  fruInventoryOffset;
    UINT8   inventoryData[IMB_MAX_DATA_LEN-2];
} FRU10_Q_WRITE_FRU_INVENTORY_DATA;

#define FRU09_S_WRITE_FRU_INVENTORY_DATA    FRU_S_WRITE_FRU_INVENTORY_DATA
#define FRU10_S_WRITE_FRU_INVENTORY_DATA    FRU_S_WRITE_FRU_INVENTORY_DATA

#if     defined(IPMI_VER_09)
#define FruQWriteFruInventoryArea           Fru09QWriteFruInventoryArea
#define FRU_Q_WRITE_FRU_INVENTORY_DATA      FRU09_Q_WRITE_FRU_INVENTORY_DATA
#else
#define FruQWriteFruInventoryArea           Fru10QWriteFruInventoryArea
#define FRU_Q_WRITE_FRU_INVENTORY_DATA      FRU10_Q_WRITE_FRU_INVENTORY_DATA
#endif  /* IPMI_VER_10 */

typedef struct FruSWriteFruInventoryData {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   writtenCount;
} FRU_S_WRITE_FRU_INVENTORY_DATA;

/* The FRU's Common Header format */
typedef struct FruCommonHeader {
    UINT8   version;		/* Should equal 1. */
    /*
     * The following fields point to the various areas of the FRU.  If
     * an offset is zero, the area is not present.  Otherwise, the
     * actual offset within the FRU is obtained by multiplying the value
     * of the field by 8.
     */
    UINT8   internalUseOffset;
    UINT8   chassisInfoOffset;	
    UINT8   boardInfoOffset;	
    UINT8   productInfoOffset;	
    UINT8   multiRecordOffset;	

    UINT8   pad;		/* Should equal 0. */
    UINT8   checksum;		/* Sum of Common Header bytes should be 0. */
} FRU_COMMON_HEADER;
    
#endif  /* _FRU_CMD_H_ */
