/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/**************************************************************************
**  Copyright (C) 1997-1999, Hewlett-Packard Co. All rights reserved.
**
**  File name:  glob_cmd.h
**  Summary:    IMB Global Command Definitions
**
**  Description:
**      Equates for IPMI global commands, including self test errors.
**
**  Self Test Errors, MMC Crib Sheet...
**    0x55	GLOB_GSTR_SELFTEST_PASSED
**		No self test failure to report.
**
**    0x56	GLOB_GSTR_SELFTEST_NOT_IMPLEMENTED
**		This result is documented by IPMI, but is never
**		returned by MMC.
**
**    0x57	GLOB_GSTR_CORRUPT_DATA
**		Corrupted or inaccessible data or devices.  Byte 3 will contain
**		the following bit field:
**		  bit 7 GLOB_FAIL_SEL_ACCESS
**		  bit 6 GLOB_FAIL_SDR_ACCESS
**		  bit 5 GLOB_FAIL_FRU_ACCESS
**		  bit 4 GLOB_FAIL_IPMB_HUNG
**		  bit 3 GLOB_FAIL_SDRR_EMPTY
**		  bit 2 GLOB_FAIL_INTERNAL_USE_AREA
**		  bit 1 GLOB_FAIL_BOOT_BLOCK_CORRUPT
**		  bit 0 GLOB_FAIL_FIRMWARE_CORRUPT
**
**    0x58	GLOB_GSTR_FATAL_MMC_ERROR
**		Fatal controller error (system should consider controller
**		inoperative).  This will indicate that the controller hardware,
**		including associated sensors or RAM, may need to be repaired or
**		replaced.  Byte 3 will contain one of the following values:
**
**		  0x82	    GLOB_GSTR_RAMTEST_FAIL
**			    This result indicates that the RAM selftest
**			    failed.
**
**		  0x83	    GLOB_GSTR_REG1_FAIL
**			    This result indicates that the hardware I/O
**			    register #1 failed a write/verify test.
**
**		  0x8A	    GLOB_GSTR_FLSH_UNSUPPORTED_ERROR
**			    This result indicates that the FLASH part
**			    itself did not identify itself as a known,
**			    supported part.
**
**		  0x8E	    GLOB_GSTR_STACK_OVERFLOW
**			    This result indicates that the download code
**			    detected a overflow condition and jumped to
**			    the boot code to report it.
**
**    0x59	GLOB_GSTR_NONFATAL_MMC_ERROR
**		Non-fatal controller error (system should consider
**		controller operation hampered).	 Byte 3 will contain one
**		of the following values:
**
**		  0x88	    GLOB_GSTR_ERA_SEEPROM_RD_FAIL
**			    This result indicates that a failure
**			    occurred while trying to read ERA config.
**
**		  0x89	    GLOB_GSTR_ERA_UART_FAIL
**			    This result indicates that a manufacturing
**			    self test hood was detected at the
**			    management port, but that the serial self
**			    test itself failed.
**
**  The following OEM IPMI 0.9 selftest errors are no longer reported by
**  IPMI 1.0 code.  They have been replaced with "standard" selftest
**  results or simply removed as redundant.
**
**    0x81	GLOB09_GSTR_POINTERS_CORRUPTED
**		This result is returned by the MMC when SEL or SDR
**		pointers are determined to be corrupt and are cleared,
**		and then there is a problem reporting the clearing.
**
**    0x84	GLOB09_GSTR_FLSH_CHECKSUM_ERROR
**		This result indicates that the download image failed to
**		checksum correctly.
**
**    0x85	GLOB09_GSTR_FRU_SEEPROM_RD_FAIL
**		This result indicates that a failure occurred while
**		trying to read out of the FRU.	Since this is the first
**		MMC access to the I2C bus, it may also be a symptom of a
**		stuck I2C bus.
**
**    0x86	GLOB09_GSTR_SEL_SEEPROM_RD_FAIL
**		This result indicates that a failure occurred while
**		trying to read out of the SEL.
**
**    0x87	GLOB09_GSTR_SDR_SEEPROM_RD_FAIL
**		This result indicates that a failure occurred while
**		trying to read out of the SDR.
**
**    0x8B	GLOB09_GSTR_BOOT_CHECKSUM_ERROR
**		This result indicates that the boot image failed to
**		checksum correctly.
**
**    0x8C	GLOB09_GSTR_LOCAL_I2C_ERROR
**		[FPC only] This result indicates that the local i2c bus
**		failed.
**
**    0x8D	GLOB09_GSTR_FRU_SEEPROM_CSUM_FAIL
**		This result indicates that a FRU entry that claimed to
**		be in the common format failed to checksum.
**
**************************************************************************/

#ifndef _GLOB_CMD_H_
#define _GLOB_CMD_H_

#include        "imb_std.h"     /* IMB OS-Dependent Standard Types */

/* Application NetFn (IMB_NF_APP_) Global Commands */
#define GLOB_GET_DEVICE_ID              0x01
#define GLOB_COLD_RESET                 0x02
#define GLOB_WARM_RESET                 0x03
#define GLOB_GET_SELF_TEST_RESULTS      0x04
#define GLOB_MFG_TEST_ON                0x05

#define GLOB_SET_ACPI_POWER_STATE       0x06
#define GLOB_GET_ACPI_POWER_STATE       0x07

/* for completeness for unchanging codes whose data structures vary */
#define GLOB09_GET_DEVICE_ID            GLOB_GET_DEVICE_ID
#define GLOB10_GET_DEVICE_ID            GLOB_GET_DEVICE_ID
#define GLOB09_GET_SELF_TEST_RESULTS    GLOB_GET_SELF_TEST_RESULTS
#define GLOB10_GET_SELF_TEST_RESULTS    GLOB_GET_SELF_TEST_RESULTS

/* GLOB_GET_DEVICE_ID */
typedef void GLOB_Q_GET_DEVICE_ID;

#define GLOB_GDI_DT_UNSPEC              0x00	/* Unspecified */
#define GLOB_GDI_DT_FPC                 0x01    /* Front Panel Controller */
#define GLOB_GDI_DT_HSP                 0x02    /* Hot-Swap, Primary */
#define GLOB_GDI_DT_HSS                 0x03    /* Hot-Swap, Secondary */
#define GLOB_GDI_DT_MMC                 0x05    /* Motherboard Management C. */
#define GLOB_GDI_DT_CMC                 0x06    /* CPU Management C. */
#define GLOB_GDI_DT_PMC			0x10	/* Power Supply Management C. */

/* Note: this is BCD with the LSB in bits 7:4, MSB in bits 3:0 */
#define GLOB_GDI_SSR_0_1                0x10    /* Version 0.1 */
#define GLOB_GDI_SSR_0_9                0x90    /* Version 0.9 */
#define GLOB_GDI_SSR_1_0                0x01    /* Version 1.0 */

#define GLOB_GDI_IDS_CHASSIS_DEVICE	0x80
#define GLOB_GDI_IDS_BRIDGE             0x40
#define GLOB_GDI_IDS_EVENT_GENERATOR    0x20
#define GLOB_GDI_IDS_EVENT_RECEIVER     0x10
#define GLOB_GDI_IDS_FRU_INVENTORY_DEV  0x08
#define GLOB_GDI_IDS_SEL_DEVICE         0x04
#define GLOB_GDI_IDS_SDR_DEVICE         0x02
#define GLOB_GDI_IDS_SENSOR_DEVICE      0x01

#define GLOB_GDI_SDR_SUPPORT            0x80

#define GLOB_GDI_MI_HP			0x0000000BUL	/* HP is 11 decimal */

#define GLOB_GDI_PI_UNSPEC		0x0000UL	/* Unspecified */
#define GLOB_GDI_PI_LC2K		0x0020UL
#define GLOB_GDI_PI_LP1K		0x0030UL
#define GLOB_GDI_PI_LP2K		0x0031UL
#define GLOB_GDI_PI_LH3K		0x0040UL
#define GLOB_GDI_PI_LH6K		0x0050UL
#define GLOB_GDI_PI_LT6K		0x0060UL        /* fix this when the real one is known */
#define GLOB_GDI_PI_SF2			0x0100UL	/* Starfish 2 */
#define GLOB_GDI_PI_SF3			0x0101UL	/* Starfish 3 */
#define GLOB_GDI_PI_LH_FPC		0x0110UL	/* LH Front Panel LCD */
#define GLOB_GDI_PI_TTRC		0x8100UL	/* TopTools Rem. Con. */

typedef struct Glob09SGetDeviceId {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   deviceType;         /* GLOB_GDI_DT_ */
    UINT8   deviceRevision;
    UINT8   firmwareRev1;
    UINT8   firmwareRev2;
    UINT8   sensorSpecRev;      /* GLOB_GDI_SSR_ */
    UINT8   ipmDeviceSupport;   /* GLOB_GDI_IDS_ */
} GLOB09_S_GET_DEVICE_ID;

typedef struct Glob10SGetDeviceId {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   deviceType;         /* GLOB_GDI_DT_ */
    UINT8   deviceRevision;
    UINT8   firmwareRev1;
    UINT8   firmwareRev2;
    UINT8   ipmiVersion;        /* GLOB_GDI_SSR_ */
    UINT8   ipmDeviceSupport;   /* GLOB_GDI_IDS_ */
    UINT8   manufacturerIdLo;	/* GLOB_GDI_MI_  */
    UINT8   manufacturerIdMid;
    UINT8   manufacturerIdHi;
    UINT8   productIdLo;	/* GLOB_GDI_PI_  */
    UINT8   productIdHi;
} GLOB10_S_GET_DEVICE_ID;

#if defined(IPMI_VER_09)
#define GlobSGetDeviceId  Glob09SGetDeviceId
#define GLOB_S_GET_DEVICE_ID  GLOB09_S_GET_DEVICE_ID
#else
#define GlobSGetDeviceId  Glob10SGetDeviceId
#define GLOB_S_GET_DEVICE_ID  GLOB10_S_GET_DEVICE_ID
#endif

/* GLOB_COLD_RESET */
typedef void GLOB_Q_COLD_RESET;

typedef struct GlobSColdReset {
    UINT8   completionCode;     /* IMB_CC_ */
} GLOB_S_COLD_RESET;


/* GLOB_WARM_RESET */
typedef void GLOB_Q_WARM_RESET;

typedef struct GlobSWarmReset {
    UINT8   completionCode;     /* IMB_CC_ */
} GLOB_S_WARM_RESET;


/* GLOB_GET_SELF_TEST_RESULTS */
typedef void GLOB_Q_GET_SELF_TEST_RESULTS;

#define GLOB_GSTR_SELFTEST_PASSED           0x55  /* failReason = 0 */
#define GLOB_GSTR_SELFTEST_NOT_IMPLEMENTED  0x56  /* failReason = 0 */

/* SELF TEST RESULTS THAT INDICATE CORRUPT DATA */
#define   GLOB_GSTR_CORRUPT_DATA            0x57  /* failReason bits follow */
#define   GLOB_FAIL_SEL_ACCESS              (0x01 << 7)
#define   GLOB_FAIL_SDR_ACCESS              (0x01 << 6)
#define   GLOB_FAIL_FRU_ACCESS              (0x01 << 5)
#define   GLOB_FAIL_IPMB_HUNG               (0x01 << 4)
#define   GLOB_FAIL_SDRR_EMPTY              (0x01 << 3)
#define   GLOB_FAIL_INTERNAL_USE_AREA       (0x01 << 2)
#define   GLOB_FAIL_BOOT_BLOCK_CORRUPT      (0x01 << 1)
#define   GLOB_FAIL_FIRMWARE_CORRUPT        (0x01 << 0)

/* SELF TEST RESULTS THAT INDICATE MMC SHOULD BE CONSIDERED NONFUNCTIONAL */
#define GLOB_GSTR_FATAL_MMC_ERROR           0x58  /* failReason values follow */
/* Ramtest and Register1 failure codes are hard coded in bt_iface.a51 */
#define GLOB_GSTR_RAMTEST_FAIL              0X82
#define GLOB_GSTR_REG1_FAIL                 0X83
#define GLOB_GSTR_FLSH_UNSUPPORTED_ERROR    0x8A
#define GLOB_GSTR_STACK_OVERFLOW            0x8E
/* the following two errors should never appear in released code */
#define GLOB_GSTR_MON_TASK_OVERFLOW         0xFE
#define GLOB_GSTR_UISM_OVERFLOW             0xFF

/* SELF TEST RESULTS THAT INDICATE MMC'S OPERATION IS HINDERED */
#define GLOB_GSTR_NONFATAL_MMC_ERROR        0x59  /* failReason values follow */
#define GLOB_GSTR_ERA_SEEPROM_RD_FAIL       0x88
#define GLOB_GSTR_ERA_UART_FAIL             0x89
/* the POST responses below are used by Starfish */
#define GLOB_GSTR_SCSI_DRIVES_CHANGED       0x91  /* drive configuration changed */
#define GLOB_GSTR_CAGE_CONFIG_CHANGED       0x92  /* cage configuration changed */
#define GLOB_GSTR_NO_SCSI_CABLE             0x94  /* no SCSI cable plugged in */

/* OEM IPMI 0.9 selftest results that have been replaced by IPMI 1.0 results */
#define GLOB09_GSTR_POINTERS_CORRUPTED      0x81
#define GLOB09_GSTR_FLSH_CHECKSUM_ERROR     0x84
#define GLOB09_GSTR_FRU_SEEPROM_RD_FAIL     0x85
#define GLOB09_GSTR_SEL_SEEPROM_RD_FAIL     0x86
#define GLOB09_GSTR_SDR_SEEPROM_RD_FAIL     0x87
#define GLOB09_GSTR_BOOT_CHECKSUM_ERROR     0x8B
#define GLOB09_GSTR_LOCAL_I2C_ERROR         0x8C
#define GLOB09_GSTR_FRU_SEEPROM_CSUM_FAIL   0x8D

typedef struct Glob09SGetSelfTestResults {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   results;
} GLOB09_S_GET_SELF_TEST_RESULTS;

typedef struct Glob10SGetSelfTestResults {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   results;
    UINT8   failReason;
} GLOB10_S_GET_SELF_TEST_RESULTS;

#if defined(IPMI_VER_09)
#define GlobSGetSelfTestResults  Glob09SGetSelfTestResults
#define GLOB_S_GET_SELF_TEST_RESULTS  GLOB09_S_GET_SELF_TEST_RESULTS
#else
#define GlobSGetSelfTestResults  Glob10SGetSelfTestResults
#define GLOB_S_GET_SELF_TEST_RESULTS  GLOB10_S_GET_SELF_TEST_RESULTS
#endif

/* GLOB_MFG_TEST_ON */
typedef struct {
	char passWord[5];

}GLOB_Q_MFG_TEST_ON ;

typedef struct GlobSMfgTestOn {
    UINT8   completionCode;     /* IMB_CC_ */
} GLOB_S_MFG_TEST_ON;

#define GLOB_ACPI_SYS_SET_STATE    0x80
#define GLOB_ACPI_SYS_NO_CHNG  0xFF
#define GLOB_ACPI_SYS_UNKNOWN  0xAA
#define GLOB_ACPI_SYS_LEG_OFF  0x21
#define GLOB_ACPI_SYS_LEG_ON   0x20
#define GLOB_ACPI_SYS_OVERRIDE 0x0A
#define GLOB_ACPI_SYS_G1       0x09  /* sleeping S1 or S4 */
#define GLOB_ACPI_SYS_SLEEPING 0x08  /* sleeping S1 or S3 */
#define GLOB_ACPI_SYS_G3       0x07  /* mechanical off  */
#define GLOB_ACPI_SYS_S4_S5    0x06  /* S4 or S5        */
#define GLOB_ACPI_SYS_S5_G2    0x05  /* soft off        */
#define GLOB_ACPI_SYS_S4       0x04  /* suspend to disk */
#define GLOB_ACPI_SYS_S3       0x03  /* suspend to RAM  */
#define GLOB_ACPI_SYS_S2       0x02  /* stop proc clock */
#define GLOB_ACPI_SYS_S1       0x01  /* stop clock      */
#define GLOB_ACPI_SYS_S0_G0    0x00  /* running         */

#define GLOB_ACPI_DEV_SET_STATE    0x80
#define GLOB_ACPI_DEV_NO_CHNG  0xFF
#define GLOB_ACPI_DEV_UNKNOWN  0xAA
#define GLOB_ACPI_DEV_D3       0x03
#define GLOB_ACPI_DEV_D2       0x02
#define GLOB_ACPI_DEV_D1       0x01
#define GLOB_ACPI_DEV_D0       0x00

/* GLOB_SET_ACPI_POWER_STATE */
typedef struct GlobQSetAcpiPowerState {
    UINT8 systemPowerState;
    UINT8 devicePowerState;
} GLOB_Q_SET_ACPI_POWER_STATE;

typedef struct GlobSSetAcpiPowerState {
    UINT8   completionCode;     /* IMB_CC_ */
} GLOB_S_SET_ACPI_POWER_STATE;

/* GLOB_GET_ACPI_POWER_STATE */
typedef void GLOB_Q_GET_ACPI_POWER_STATE;

typedef struct GlobSGetAcpiPowerState {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8 systemPowerState;
    UINT8 devicePowerState;
} GLOB_S_GET_ACPI_POWER_STATE;

#if 0
/* GLOB_GET_DEVICE_GUID */

typedef void GLOB_Q_GET_DEVICE_GUID;

typedef struct GlobSGetDeviceGuid {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   guidBytes[16];
} GLOB_S_GET_DEVICE_GUID;
#endif

#endif  /* _GLOB_CMD_H_ */
