/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/**************************************************************************
**  Copyright (C) 1998-1999, Hewlett-Packard Co. All rights reserved.
**
**  File name:  led_cmd.h
**  Summary:    LED Command Definitions
**
**************************************************************************/
#ifndef _LED_CMD_H_
#define _LED_CMD_H_

#include	"imb_std.h"	/* IMB OS-Dependent Standard Types */

/* App NetFn (IMB_NF_APP) commands  */
#define	LED_SET_LEDS			0xDE
#define	LED_GET_LEDS			0xDF

/* LED_SET_LED */
#define	LED_LEDSPEC_LED_MASK	0xF0	/* which LED is being specified */
#define	LED_LEDSPEC_LED_SHIFT	4

/* LCn or LHn LEDs */
#define	LEDSPEC_RED_TRAFFIC		0x00	/* Red Traffic Light LED */
#define	LEDSPEC_YELLOW_TRAFFIC	0x10	/* Yellow Traffic Light LED */
#define	LEDSPEC_GREEN_TRAFFIC	0x20	/* Green Traffic Light LED */

/* LC2K LEDs */
#define LEDSPEC_POWER			0x40	/* Power LED */
#define LEDSPEC_SECURE 			0xA0	/* Secure mode LED */
#define LEDSPEC_RPS				0xB0	/* RPS LED */
#define LEDSPEC_PHP				0xC0	/* PHP LED */

/* LPr and LC2K LEDs */
#define	LEDSPEC_DISK			0xD0	/* Disk LED */
#define	LEDSPEC_TEMPERATURE		0xE0	/* Temperature LED */
#define	LEDSPEC_FAN				0xF0	/* Fan LED */

#define	LED_LEDSPEC_STATE_MASK	0x0F	/* Control/Blink/Color for LED */
#define	LED_LEDSPEC_STATE_SHIFT	0
#define	LEDSPEC_UNSPECIFIED		0x04	/* LED under MMC control */

#define	LED_LEDSPEC_BLINK_MASK	0x0C	/* Blink for LED */
#define	LED_LEDSPEC_BLINK_SHIFT	2
#define	LEDSPEC_STEADY			0x00	/* No blinking */
#define	LEDSPEC_05HZ			0x04	/* Blink @ 0.5 Hz */
#define	LEDSPEC_10HZ			0x08	/* Blink @ 1.0 Hz */
#define	LEDSPEC_20HZ			0x0C	/* Blink @ 2.0 Hz */

#define	LED_LEDSPEC_COLOR_MASK	0x03	/* Color for LED */
#define	LED_LEDSPEC_COLOR_SHIFT	0
#define	LEDSPEC_OFF				0x00	/* LED off */
#define	LEDSPEC_RED				0x01	/* LED red */
#define	LEDSPEC_GREEN			0x02	/* LED green */
#define	LEDSPEC_YELLOW			0x03	/* LED yellow */

typedef struct LedQSetLed {
    UINT8  ledSpec[1];		/* actually [n], in any order */
} LED_Q_SET_LED;

typedef struct LedSSetLed {
    UINT8  completionCode;	/* IMB_CC_ */
} LED_S_SET_LED;


/* LED_GET_LED */
typedef void LED_Q_GET_LED;

typedef struct LedSGetLed {
    UINT8  completionCode;	/* IMB_CC_ */
    UINT8  ledSpec[1];		/* actually [n], in LED order */
} LED_S_GET_LED;

#endif	/* _LED_CMD_H_ */
