/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

//-----------------------------------------------------------------------------
//
// I2C_LEGA.H (formerly i2capi.h)
//
// 120294 mlau, copyright Hewlett Packard Co 1994, 1995
// 020295 mlau, add new functions equates
// 032197 stalag, copied and modified as legacy I2C API calls for MMC API
//
//-----------------------------------------------------------------------------

#ifndef I2C_LEGA_H
#define I2C_LEGA_H

#define WORD unsigned short			// 16 bits
#define BYTE unsigned char	 		// 8 bits
#define BOOL int


#define TRUE 1
#define FALSE 0

#ifdef __cplusplus
extern "C" {
#endif

int I2C_ReceiveMessage(BYTE slave_addr, BYTE* mesg, int len );
int I2C_SendMessage(BYTE slave_addr, BYTE* mesg, int len );
int I2C_RepeatStartMesg(BYTE slave_addr, BYTE *smesg, int slen, BYTE *rmesg,
    int rlen);
int I2C_Reset8584( BYTE own_addr, BYTE slc_clock );
int I2C_ResetBus( BYTE own_addr, BYTE slc_clock );
void I2C_GetDriverVersion( char oem_name[], char *version_letter, 
    BYTE *version_major, BYTE *version_minor );
int I2C_GetKernelDriverVersion( char oem_name[], char *version_letter, 
    BYTE *version_major, BYTE *version_minor );
int I2C_OpenDevice();
int I2C_CloseDevice();
int I2C_GetOutputShadow( BYTE slave_addr, BYTE *outp_data );

#ifdef __cplusplus
}
#endif

#define LEGACYBB    0x01          // ~bus busy             0 = busy     1 = free
#define LEGACYLAB   0x02          // lost arbitration      0 = false    1 = true
#define LEGACYAAS   0x04          // addrsed as slave      0 = false    1 = true
#define LEGACYLRB   0x08          // last received bit     0 = acknwl   1 = not ack
#define LEGACYAD0   0x08          // recv genrl call addr  0 = false    1 = true
#define LEGACYBER   0x10          // bus error             0 = false    1 = true
#define LEGACYSTS   0x20          // external stop recv    0 = false    1 = true
#define LEGACYINIT  0x40          // ~initialized 8584     0 = true     1 = false
#define LEGACYPIN   0x80          // pending interrupt not 0 = servce   1 = normal

// I2C API function error return values NOT to be confused with 8584 status
// bits although some are the same and with inverted meanings.
//
#define LEGACYEBB         LEGACYBB      // bus busy              0 = free     1 = busy
#define LEGACYELAB        LEGACYLAB     // lost arbitration      0 = false    1 = true
#define LEGACYEIN_USE     0x04          // 8584 device in use    0 = false    1 = true
#define LEGACYELRB        LEGACYLRB     // last received bit     0 = acknwl   1 = no ack
#define LEGACYEBER        LEGACYBER     // bus error             0 = false    1 = true 
#define LEGACYEDEVDRV     0x20          // err open/close driver 0 = ok       1 = error 
#define LEGACYEINIT       LEGACYINIT    // ~initialized 8584     0 = true     1 = false
#define LEGACYEPIN        LEGACYPIN     // txfer complete        0 = true     1 = false
                        
#define I2C_SUCCESS 0x0000  // always ZERO for success, don't change !!!
#define I2C_FAILURE 0x0001  // error used in i2cdrv.c only  

#define MAX_SLAVE_ADDR      0x80        /* max number of slave addresses */

//
// I2C slave class devices
// 
#define CLASS_STARFISH		1	// identifies a starfish device
#define CLASS_WYATT		2	// identifies a wyatt power supply

#endif


