#ifdef __KERNEL__

#ifdef __NO_VERSION__
#error __NO_VERSION__ must not be defined
#endif

#include <linux/version.h>

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0))

# ifndef __KERNEL__
#  define __KERNEL__
# endif

# ifndef MODULE
#  define MODULE
# endif

# include <linux/autoconf.h>
# if defined(CONFIG_MODVERSIONS) && !defined(MODVERSIONS)
#  define MODVERSIONS
# endif

# ifdef MODVERSIONS
#  include <linux/modversions.h>
# endif

#endif

#include <linux/fs.h>
#include <linux/sched.h>
#include <linux/wait.h>

#else // shell

#include <unistd.h>
#include <stdio.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <errno.h>
#define	printk	printf

#endif

#include "mmc_dev.h"
#include "mmc.h"
#include "osdepdrv.h"

#define UINT8 unsigned char

#ifndef NULL
#define NULL 0x00
#endif

#ifdef __KERNEL__

extern int mmcdev_open(struct inode *, struct file *);
extern int mmcdev_close(struct inode *, struct file *);
extern int mmcdev_getmajor();
extern int MMCDRVR_SendRcvMessage(UINT8 FAR_PNTR *sbuffer, UINT8 slength, UINT8 FAR_PNTR *rbuffer, UINT8 FAR_PNTR *rlength);

#else

static int nDriverFD;

#endif

int MMC_OpenDevice() {
	int iRet = EDEVDRV;
	int nRetry = 0;
#ifdef __KERNEL__
	struct inode inode;
	int mmcdev_major;

	mmcdev_major = mmcdev_getmajor();
	inode.i_rdev = MKDEV( mmcdev_major  ,  0 );

	while( nRetry++ < MAX_DEVICE_OPEN_RETRIES ) {
		if( ( iRet = mmcdev_open(&inode, NULL) ) == MMC_SUCCESS )
			break;
		if( iRet != -EBUSY )
			break;
		MMC_Sleep( DEVICE_RETRY_SLEEP_TICK );
	}
	
#else
	while( nRetry++ < MAX_DEVICE_OPEN_RETRIES ) {
		nDriverFD = open("/dev/mmcdev", O_RDWR);
		if (nDriverFD == 0) {
			iRet = MMC_SUCCESS;
			break;
		} else {
	    		iRet = errno;
			if( iRet != -EBUSY )
				break;
			MMC_Sleep( DEVICE_RETRY_SLEEP_TICK );
		}
	}
#endif
	return iRet;
}

int MMC_CloseDevice() {
	int nRetry = 0;
	int nReturnCode = EDEVDRV;
	
#ifdef __KERNEL__
	while( nRetry++ < MAX_DEVICE_OPEN_RETRIES ) {
		if( ( nReturnCode = mmcdev_close(NULL, NULL) ) == MMC_SUCCESS )
			break;
		MMC_Sleep( DEVICE_RETRY_SLEEP_TICK * nRetry );
	}
#else
	while( nRetry++ < MAX_DEVICE_OPEN_RETRIES ) {
		if  ( close(nDriverFD) >= 0 ) {
			nReturnCode = MMC_SUCCESS;
			break;
		}
		MMC_Sleep( DEVICE_RETRY_SLEEP_TICK * nRetry );
	}
#endif
	return( nReturnCode );
}

int MMC_SendRcvMesg(UINT8 *input, int ilen, UINT8 *output, UINT8 *olen) {
	int result;
#ifdef __KERNEL__
	result = MMCDRVR_SendRcvMessage(input, ilen, output, olen);
#else
	SEND_RCV sr;
	sr.input = input;
	sr.ilen = ilen;
	sr.output = output;
	sr.olen = *olen;
	result = ioctl(nDriverFD, IOCTL_MMC_SEND_RCV, &sr);
	*olen = sr.olen;
	result = sr.retcode;
#endif	
	if (result < 0) {
		printk("<1> [seldev] MMCDRVR_SendRcvMesage return %d.\n", result );
		return EDEVDRV;
	} else
		return result;
}


void MMC_Sleep(unsigned long ms) {
#ifdef __KERNEL__
# if (LINUX_VERSION_CODE < KERNEL_VERSION(2,2,19))
	struct wait_queue *queue;
# else
	wait_queue_head_t queue;
# endif
	interruptible_sleep_on_timeout( &queue, ( ms * HZ)  / 1000 );
#else
	usleep(ms);
#endif
}

