#ifdef __KERNEL__

#ifdef __NO_VERSION__
#error __NO_VERSION__ must not be defined
#endif

#include <linux/version.h>

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0))

# ifndef __KERNEL__
#  define __KERNEL__
# endif

# ifndef MODULE
#  define MODULE
# endif

# include <linux/autoconf.h>
# if defined(CONFIG_MODVERSIONS) && !defined(MODVERSIONS)
#  define MODVERSIONS
# endif

# ifdef MODVERSIONS
#  include <linux/modversions.h>
# endif

#endif

#include <linux/slab.h>

#else // shell

#include <malloc.h>
#include <string.h>
#include <stdio.h>
#define	printk		printf
#define	GFP_KERNEL	0
#define	kmalloc(a,b)	malloc(a)		
#define	kfree(a)		free(a)

#endif

#include "mmc_func.h"

int SendRcvMesg(UINT8 sNetFnLun, UINT8 scommand, UINT8* smesg, int slen, UINT8* rmesg, int* rlen) {
	int retval;
	UINT8 *ibuffer, *obuffer, olen;
	int ilen;
	int RetryCount = 0;
	
	if (!rlen)
		return EPARAMS;
	if (*rlen < 0)
		return EPARAMS;
		
	ilen = slen + INPUT_HEADER_SIZE;    /* the send header is composed of 3 bytes */
	ibuffer = (UINT8*) kmalloc(ilen, GFP_KERNEL);
	
	if (ibuffer) {
		olen = *rlen + OUTPUT_HEADER_SIZE;
		obuffer = (UINT8*) kmalloc(olen, GFP_KERNEL);
		
		if (obuffer) {
			/* First byte of header is NetFn/Lun: */
			ibuffer[0] = sNetFnLun;
			#ifdef USE_SOFTWARE_ID
			/* Second byte is system software ID: */
			ibuffer[1] = SYSTEMSOFTWAREID;
			/* Third byte is command code: */
			ibuffer[2] = scommand;
			#else
			ibuffer[1] = scommand;
			#endif
			
			if (smesg && slen)
				memcpy(ibuffer + INPUT_HEADER_SIZE, smesg, slen);
			
			retval = MMC_SendRcvMesg(ibuffer, ilen, obuffer, &olen);
			while (  retval != MMC_SUCCESS ) {
				/* Check Retry Count */
				if ( RetryCount < MMC_MAXIMUM_NUMBER_OF_RETRIES )
					RetryCount++;
				else
					break;
				
				/* Sleep before retrying */
				MMC_Sleep( MMC_MILLISECONDS_BETWEEN_RETRIES );
				retval = MMC_SendRcvMesg(ibuffer, ilen, obuffer, &olen);
			}
			
			/* The API layer checks the value of olen and returns a */
			/* EBUFFER if the length value isn't long enough. */
			if (retval == MMC_SUCCESS) {
				#ifdef USE_SOFTWARE_ID
				if ((obuffer[0] == (ibuffer[0] | 0x04)) && (obuffer[1] == ibuffer[1]) && (obuffer[2] == ibuffer[2])) {
				#else
				if ((obuffer[0] == (ibuffer[0] | 0x04)) && (obuffer[1] == ibuffer[1])) {
				#endif
					if (*rlen > 0) {
						if (rmesg)
							memcpy(rmesg, obuffer + OUTPUT_HEADER_SIZE, __min(*rlen, olen - OUTPUT_HEADER_SIZE));
						if (*rlen < (olen - OUTPUT_HEADER_SIZE))
							retval = EBUFFER;
						*rlen = olen - OUTPUT_HEADER_SIZE;
					}
				} else
					retval = EBADDATA;
			} else
				printk("<1> [seldev] MMC_SendRcvMesg return %d\n", retval );
			kfree(obuffer);
		} else {
			printk("<1> [seldev] Insuficient memory.\n" );
			retval = EMEMORY;
		}
		kfree(ibuffer);
	} else {
		printk("<1> [seldev] Insuficient memory.\n" );
		retval = EMEMORY;
	}
	return retval;
}

/********************************************************************
 **  MMCReserveSEL - Closes the driver
 **
 **  Description:
 **              Calls the driver close function
 **
 **  Prototype:
 **              int  MMCReserveSEL(UINT16 *)
 **  Return value:
 **              MMC_SUUCCES    Driver closed successfully
 **              ENOT_IN_USE    Driver was not opened
 **
 **  Globals used: none.
 **  Globals modified: none.
 **
 *******************************************************************/
int MMCReserveSEL(UINT16* Reservation) {
	int retval;
	SEL_S_RESERVE_SEL output;
	int outlen = sizeof(output);
	
	retval = SendRcvMesg(NETFNLUN_MMCSTORAGE, SEL_RESERVE_SEL, NULL, 0, (UINT8*) &output, &outlen);
	
	if (retval == MMC_SUCCESS) {
		retval = output.completionCode;
		*Reservation = output.reservationId;
	}
	return retval;
}

int MMC_ReserveSDRRepository(UINT16* Reservation)
{
      int retval;
      SDRR_S_RESERVE_SDR_REPOSITORY output;
      int outlen = sizeof(output);

      retval = SendRcvMesg(NETFNLUN_MMCSTORAGE, SDRR_RESERVE_SDR_REPOSITORY, NULL, 0, (UINT8*) &output, &outlen);
                    
      if (retval == MMC_SUCCESS) {
        retval = output.completionCode;                                                 
        *Reservation = output.reservationId;                
      }

    return retval;

} //MMC_ReserveSDRRepository

int MMC_GetSDR(UINT16 Reservation, UINT16 RecID, UINT8 Offset, UINT8 ReadBytes, UINT16* NextID, SDR* Data) {
	int retval;
	SDRR_Q_GET_SDR input;
	SDRR_S_GET_SDR output;
	int outlen = sizeof(output);
	
	input.reservationId = Reservation;
	input.recordId = RecID;
	input.offset = Offset;      
	
	if (ReadBytes == 0xff)  // Return all
		ReadBytes = IMB_MAX_DATA_LEN - OFFSETOF(SDRR_S_GET_SDR, sdrData);
	else if (ReadBytes > IMB_MAX_DATA_LEN)
		return EBADDATA;
	
	input.bytes = ReadBytes;
	
	retval = SendRcvMesg(NETFNLUN_MMCSTORAGE, SDRR_GET_SDR, (UINT8*) &input, sizeof(input), (UINT8*) &output, &outlen);
	
	if (retval == MMC_SUCCESS) {
		retval = output.completionCode;
		*NextID = output.nextRecordId;
		memcpy(((UINT8*) Data) + Offset, output.sdrData, ReadBytes);
	}
	
	return retval;
} // MMC_GetSDR


/********************************************************************
 **  MMCGetSELEntry - 
 **
 **  Description:
 **              
 **
 **  Prototype:
 **              int MMCGetSELEntry(UINT16,UINT16,UINT8,UINT8,UINT16*,SEL*)
 **  Return value:
 **              MMC_SUUCCES    Driver closed successfully
 **              ENOT_IN_USE    Driver was not opened
 **
 **  Globals used: none.
 **  Globals modified: none.
 **
 *******************************************************************/
int MMCGetSELEntry(UINT16 Reservation, UINT16 RecID, UINT8 Offset, UINT8 ReadBytes, UINT16* NextID, SEL* Data) {
	int retval;
	SEL_Q_GET_SEL_ENTRY input;
	SEL_S_GET_SEL_ENTRY output;
	int outlen = sizeof(output);
	
	input.reservationId = Reservation;
	input.recordId      = RecID;
	input.offset        = Offset;
	input.bytes         = ReadBytes;
	
	retval = SendRcvMesg(NETFNLUN_MMCSTORAGE, SEL_GET_SEL_ENTRY, (UINT8*) &input, sizeof(input), (UINT8*) &output, &outlen);
	
	if (retval == MMC_SUCCESS) {
		retval = output.completionCode;
		*NextID = output.nextRecordId;
		
		// The LXr 8000 BMC firmware has a bug that Intel
		// acknowledges, but won't be fix for the inital
		// release.  The SEL record ID requested may not match
		// the record ID returned within the SEL entry itself.
		// The workaround is to overwrite the possibly corrupt
		// record ID in the SEL entry with the record ID requested
		// by the user of this function.  If the special "last
		// record" record ID is requested (0xffff), then this
		// function will proceed as originally designed.
		if ( RecID != 0xffff ) {
			output.selData[0] = (UINT8) ( RecID & 0x00ff );
			output.selData[1] = (UINT8) ( RecID >> 8 );
		}
		
		memcpy(((UINT8*) Data) + Offset, output.selData, ReadBytes);
	}
	
	return retval;
}
