#include "msg_sel.h"

const struct MSG_INFO_SEL s_SelInfo[] = {

{ 0x01, 0x01, 0x00, "Temperature sensor %1 crossed the lower non-critical threshold.", { "ls", "", "", "", "", "", "" }, "Warning" },
{ 0x01, 0x01, 0x02, "Temperature sensor %1 crossed the lower critical threshold.", { "ls", "", "", "", "", "", "" }, "Error" },
{ 0x01, 0x01, 0x04, "Temperature sensor %1 crossed the lower non-recoverable threshold.", { "ls", "", "", "", "", "", "" }, "Error" },
{ 0x01, 0x01, 0x07, "Temperature sensor %1 crossed the upper non-critical threshold.", { "ls", "", "", "", "", "", "" }, "Warning" },
{ 0x01, 0x01, 0x09, "Temperature sensor %1 crossed the upper critical threshold.", { "ls", "", "", "", "", "", "" }, "Error" },
{ 0x01, 0x01, 0x0B, "Temperature sensor %1 crossed the upper non-recoverable threshold.", { "ls", "", "", "", "", "", "" }, "Error" },
{ 0x02, 0x01, 0x00, "Voltage sensor %1 crossed the lower non-critical threshold.", { "ls", "", "", "", "", "", "" }, "Warning" },
{ 0x02, 0x01, 0x02, "Voltage sensor %1 crossed the lower critical threshold.", { "ls", "", "", "", "", "", "" }, "Error" },
{ 0x02, 0x01, 0x04, "Voltage sensor %1 crossed the lower non-recoverable threshold.", { "ls", "", "", "", "", "", "" }, "Error" },
{ 0x02, 0x01, 0x07, "Voltage sensor %1 crossed the upper non-critical threshold.", { "ls", "", "", "", "", "", "" }, "Warning" },
{ 0x02, 0x01, 0x09, "Voltage sensor %1 crossed the upper critical threshold.", { "ls", "", "", "", "", "", "" }, "Error" },
{ 0x02, 0x01, 0x0B, "Voltage sensor %1 crossed the upper non-recoverable threshold.", { "ls", "", "", "", "", "", "" }, "Error" },
{ 0x02, 0x03, 0x01, "VRM failure", { "", "", "", "", "", "", "" }, "Error" },
{ 0x02, 0x05, 0x01, "System Voltage Failure: error code %1", { "b3m11110000", "", "", "", "", "", "" }, "Warning" },
{ 0x04, 0x01, 0x00, "Fan sensor %1 crossed the lower non-critical threshold.", { "ls", "", "", "", "", "", "" }, "Warning" },
{ 0x04, 0x01, 0x02, "Fan sensor %1 crossed the lower critical threshold.", { "ls", "", "", "", "", "", "" }, "Error" },
{ 0x04, 0x01, 0x04, "Fan sensor %1 crossed the lower non-recoverable threshold.", { "ls", "", "", "", "", "", "" }, "Error" },
{ 0x04, 0x01, 0x07, "Fan sensor %1 crossed the upper non-critical threshold.", { "ls", "", "", "", "", "", "" }, "Warning" },
{ 0x04, 0x01, 0x09, "Fan sensor %1 crossed the upper critical threshold.", { "ls", "", "", "", "", "", "" }, "Error" },
{ 0x04, 0x01, 0x0B, "Fan sensor %1 crossed the upper non-recoverable threshold.", { "ls", "", "", "", "", "", "" }, "Error" },
{ 0x04, 0x07, 0x01, "A system fan module error has occurred", { "", "", "", "", "", "", "" }, "Warning" },
{ 0x04, 0x07, 0x01, "Fan module failure", { "", "", "", "", "", "", "" }, "Warning" },
{ 0x04, 0x07, 0x02, "A system fan module error has occurred", { "", "", "", "", "", "", "" }, "Error" },
{ 0x04, 0x07, 0x02, "Fan module failure", { "", "", "", "", "", "", "" }, "Error" },
{ 0x04, 0x08, 0x00, "Processor/PCI Fan Tray failure", { "", "", "", "", "", "", "" }, "Error" },
{ 0x04, 0x08, 0x01, "Processor/PCI Fan Restored", { "", "", "", "", "", "", "" }, "Informational" },
{ 0x04, 0x08, 0x04, "Memory Fan Failure", { "", "", "", "", "", "", "" }, "Error" },
{ 0x04, 0x08, 0x05, "Memory Fan Restored", { "", "", "", "", "", "", "" }, "Informational" },
{ 0x04, 0x6F, 0x00, "Processor/PCI fan Tray error", { "", "", "", "", "", "", "" }, "Error" },
{ 0x04, 0x6F, 0x03, "Memory Fan Error", { "", "", "", "", "", "", "" }, "Error" },
{ 0x05, 0x03, 0x01, "The chassis has been opened.", { "", "", "", "", "", "", "" }, "Warning" },
{ 0x05, 0x6F, 0x02, "I/O area open", { "", "", "", "", "", "", "" }, "Warning" },
{ 0x05, 0x6F, 0x03, "Processor area open", { "", "", "", "", "", "", "" }, "Warning" },
{ 0x06, 0x6F, 0x00, "Front Panel Button Violation", { "", "", "", "", "", "", "" }, "Informational" },
{ 0x07, 0x04, 0x01, "Processor number %1 is operating outside of acceptable margins", { "b3", "", "", "", "", "", "" }, "Warning" },
{ 0x07, 0x6F, 0x00, "Processor Internal Error", { "", "", "", "", "", "", "" }, "Error" },
{ 0x07, 0x6F, 0x01, "Processor Thermal Trip Failure", { "", "", "", "", "", "", "" }, "Error" },
{ 0x07, 0x6F, 0x02, "Processor failed internal self test", { "", "", "", "", "", "", "" }, "Error" },
{ 0x07, 0x6F, 0x03, "Processor hung during POST", { "", "", "", "", "", "", "" }, "Error" },
{ 0x07, 0x6F, 0x04, "Processor startup/initialization failed", { "", "", "", "", "", "", "" }, "Error" },
{ 0x07, 0x6F, 0x05, "Configuration error in %1 slot", { "ls", "", "", "", "", "", "" }, "Error" },
{ 0x07, 0x6F, 0x08, "Processor ID %1 Disabled", { "ls", "", "", "", "", "", "" }, "Error" },
{ 0x07, 0x70, 0x01, "Processor problem", { "", "", "", "", "", "", "" }, "Error" },
{ 0x07, 0x70, 0x02, "Processor Disabled", { "", "", "", "", "", "", "" }, "Error" },
{ 0x07, 0x70, 0x03, "ECC Error on P6 Bus", { "", "", "", "", "", "", "" }, "Warning" },
{ 0x07, 0x70, 0x04, "Processor Card Missing or not terminated", { "", "", "", "", "", "", "" }, "Warning" },
{ 0x07, 0x70, 0x05, "Voltage Regulating Module (VRM) failed on processor %1", { "b3", "", "", "", "", "", "" }, "Error" },
{ 0x07, 0x70, 0x06, "CPU internal error", { "", "", "", "", "", "", "" }, "Error" },
{ 0x07, 0x70, 0x07, "CPU thermal trip", { "", "", "", "", "", "", "" }, "Error" },
{ 0x07, 0x70, 0x08, "CPU hot warning", { "", "", "", "", "", "", "" }, "Warning" },
{ 0x07, 0x70, 0x09, "CPU mismatch", { "", "", "", "", "", "", "" }, "Error" },
{ 0x07, 0xEF, 0x07, "Processor failure", { "", "", "", "", "", "", "" }, "Error" },
{ 0x07, 0xEF, 0x09, "Processor or Terminator with ID %1 not detected", { "ls", "", "", "", "", "", "" }, "Error" },
{ 0x08, 0x6F, 0x00, "Power Supply %1 Inserted.", { "b3m00001111", "", "", "", "", "", "" }, "Informational" },
{ 0x08, 0x6F, 0x01, "PSU: Power failed power supply module %2", { "sn", "b3m00001111", "", "", "", "", "" }, "Warning" },
{ 0x08, 0x6F, 0x02, "PSU: Predictive failure/alert in sensor %1, power supply unit %2", { "sn", "b3m00001111", "", "", "", "", "" }, "Warning" },
{ 0x08, 0x70, 0x00, "PSS: Unit %1 Warning Temperature Exceeded", { "b3m00001111", "", "", "", "", "", "" }, "Warning" },
{ 0x08, 0x70, 0x01, "Power Supply %1 Over Temperature", { "b3m00001111", "", "", "", "", "", "" }, "Error" },
{ 0x08, 0x70, 0x02, "PSU: Unit %1 AC Power Source Failure", { "b3m00001111", "", "", "", "", "", "" }, "Error" },
{ 0x08, 0x70, 0x03, "PSU: Unit %1 Protection Temperature Exceeded, DC Output Shutdown", { "b3m00001111", "", "", "", "", "", "" }, "Error" },
{ 0x08, 0x70, 0x04, "PSU: Unit %1 Protection Temperature Normal, Power Restored", { "b3m00001111", "", "", "", "", "", "" }, "Informational" },
{ 0x08, 0x70, 0x05, "Power Supply %1 Fan Failed", { "b3m00001111", "", "", "", "", "", "" }, "Error" },
{ 0x08, 0x70, 0x06, "Power Supply %1 fan speed up", { "b3m00001111", "", "", "", "", "", "" }, "Warning" },
{ 0x08, 0x70, 0x07, "Power Supply %1: 3.3 volts bad", { "b3m00001111", "", "", "", "", "", "" }, "Error" },
{ 0x08, 0x70, 0x08, "Power Supply %1: 5 volts bad", { "b3m00001111", "", "", "", "", "", "" }, "Error" },
{ 0x08, 0x70, 0x09, "Power Supply %1: 12 volts bad", { "b3m00001111", "", "", "", "", "", "" }, "Error" },
{ 0x08, 0x70, 0x0A, "Power Supply %1: -12 volts bad", { "b3m00001111", "", "", "", "", "", "" }, "Error" },
{ 0x08, 0xEF, 0x00, "Power Supply %1 Removed", { "b3m00001111", "", "", "", "", "", "" }, "Warning" },
{ 0x09, 0x0A, 0x06, "PSS: Not enough Power Supply Units detected.", { "", "", "", "", "", "", "" }, "Error" },
{ 0x09, 0x0B, 0x00, "Power supply subsystem redundancy gained.", { "", "", "", "", "", "", "" }, "Informational" },
{ 0x09, 0x0B, 0x01, "Power supply subsystem redundancy lost.", { "", "", "", "", "", "", "" }, "Warning" },
{ 0x09, 0x0B, 0x02, "PSS: Not enough Power Supply Units detected.", { "", "", "", "", "", "", "" }, "Error" },
{ 0x09, 0x6F, 0x04, "Power System failure A/C Lost", { "", "", "", "", "", "", "" }, "Error" },
{ 0x09, 0x6F, 0x05, "Power Supply Subsystem soft failure", { "", "", "", "", "", "", "" }, "Error" },
{ 0x09, 0x6F, 0x06, "PSS: Not enough Power Supply Units detected or trouble powering up or down.", { "", "", "", "", "", "", "" }, "Error" },
{ 0x0A, 0x6F, 0x00, "Multiple Fan Failure", { "", "", "", "", "", "", "" }, "Error" },
{ 0x0B, 0x01, 0x07, "Battery Cycles sensor %s has gone beyond the upper non-critical range", { "ls", "", "", "", "", "", "" }, "Warning" },
{ 0x0B, 0x01, 0x09, "Battery Cycles sensor %s has gone beyond the upper critical range", { "ls", "", "", "", "", "", "" }, "Error" },
{ 0x0B, 0x01, 0x0B, "Battery Cycles Sensor %s has gone beyond the upper non recoverable range", { "ls", "", "", "", "", "", "" }, "Error" },
{ 0x0C, 0x04, 0x01, "Predictive failure in memory slot %1 on bank/board %2", { "b3m01111111", "b2m00000001", "", "", "", "", "" }, "Warning" },
{ 0x0C, 0x6F, 0x00, "Single-bit error corrected in memory slot %1 on bank/board %2", { "b3m01111111", "b2m00000001", "", "", "", "", "" }, "Informational" },
{ 0x0C, 0x6F, 0x01, "Multiple-bit error in memory slot %1 on bank/board %2", { "b3m01111111", "b2m00000001", "", "", "", "", "" }, "Error" },
{ 0x0C, 0x6F, 0x02, "Parity error", { "", "", "", "", "", "", "" }, "Error" },
{ 0x0C, 0x6F, 0x03, "Single-bit repeated error in memory slot %1", { "b3m01111111", "", "", "", "", "", "" }, "Informational" },
{ 0x0C, 0x70, 0x00, "ECC error corrected in memory module [%1]", { "ls", "", "", "", "", "", "" }, "Informational" },
{ 0x0C, 0x70, 0x01, "Uncorrectable multi-bit ECC error has occurred in memory module [%1]", { "ls", "", "", "", "", "", "" }, "Error" },
{ 0x0C, 0x70, 0x03, "Repeated ECC error corrected in memory module [%1]", { "ls", "", "", "", "", "", "" }, "Informational" },
{ 0x0C, 0x70, 0x04, "ECC memory module [%1] is operating outside of acceptable margins", { "ls", "", "", "", "", "", "" }, "Warning" },
{ 0x0C, 0x70, 0x05, "Memory Mirroring switched to Slave Set", { "", "", "", "", "", "", "" }, "Warning" },
{ 0x0C, 0x70, 0x06, "Faulty row switched to Hot Spare row", { "", "", "", "", "", "", "" }, "Warning" },
{ 0x0D, 0x08, 0x00, "Hot Swap Cage %1: Drive removed from slot %2", { "b3m11110000", "b3m00001111", "", "", "", "", "" }, "Error" },
{ 0x0D, 0x08, 0x01, "Hot Swap Cage %1: Drive inserted into slot %2", { "b3m11110000", "b3m00001111", "", "", "", "", "" }, "Informational" },
{ 0x0D, 0x70, 0x04, "Hot Swap Cage : Device %1: Power connection failure!", { "b2m00001111", "", "", "", "", "", "" }, "Error" },
{ 0x0D, 0x70, 0x05, "Hot swap: Temperature emergency", { "", "", "", "", "", "", "" }, "Error" },
{ 0x0D, 0x70, 0x06, "Hot swap: Temperature warning;", { "", "", "", "", "", "", "" }, "Warning" },
{ 0x0D, 0x70, 0x07, "Hot swap: Temperature monitor error;", { "", "", "", "", "", "", "" }, "Error" },
{ 0x0E, 0x6F, 0x00, "System memory size reduced due to error in memory slot %1", { "b3m01111111", "", "", "", "", "", "" }, "Warning" },
{ 0x0F, 0x6F, 0x01, "POST error on boot:%1.", { "b3u2lx", "", "", "", "", "", "" }, "Warning" },
{ 0x0F, 0x70, 0x04, "POST error on boot:%1.", { "b2u3lx", "", "", "", "", "", "" }, "Warning" },
{ 0x10, 0x6F, 0x00, "ECC single-bit overflow; logging disabled", { "", "", "", "", "", "", "" }, "Error" },
{ 0x10, 0x6F, 0x01, "Too many errors of this type", { "", "", "", "", "", "", "" }, "Informational" },
{ 0x10, 0x6F, 0x02, "Event log cleared", { "", "", "", "", "", "", "" }, "Informational" },
{ 0x10, 0x70, 0x04, "Event log %1 percent full.", { "b3", "", "", "", "", "", "" }, "Informational" },
{ 0x11, 0x6F, 0x00, "Automatic Server Restart: hard reset after NOS hang", { "", "", "", "", "", "", "" }, "Informational" },
{ 0x11, 0x6F, 0x01, "Automatic Server Restart: hard reset after NOS hang", { "", "", "", "", "", "", "" }, "Informational" },
{ 0x11, 0x6F, 0x02, "OS Watchdog Shutdown", { "", "", "", "", "", "", "" }, "Error" },
{ 0x11, 0x6F, 0x03, "Automatic Server Restart: power down after NOS hang", { "", "", "", "", "", "", "" }, "Informational" },
{ 0x11, 0x6F, 0x04, "Automatic Server Restart: power cycle after NOS hang", { "", "", "", "", "", "", "" }, "Informational" },
{ 0x11, 0x6F, 0x05, "OS Watchdog poweroff", { "", "", "", "", "", "", "" }, "Error" },
{ 0x11, 0x6F, 0x06, "NOS hang, automatic server restart disabled", { "", "", "", "", "", "", "" }, "Informational" },
{ 0x12, 0x6F, 0x00, "System configuration altered", { "", "", "", "", "", "", "" }, "Informational" },
{ 0x12, 0x6F, 0x01, "System boot (POST Complete).", { "", "", "", "", "", "", "" }, "Informational" },
{ 0x12, 0x6F, 0x02, "Unrecoverable chipset error has occurred in system board [%1,%2]", { "b2x", "b3x", "", "", "", "", "" }, "Error" },
{ 0x13, 0x6F, 0x00, "NOS memory dump initiated", { "", "", "", "", "", "", "" }, "Error" },
{ 0x13, 0x6F, 0x01, "Bus timeout", { "", "", "", "", "", "", "" }, "Error" },
{ 0x13, 0x6F, 0x02, "I/O channel check occured.", { "", "", "", "", "", "", "" }, "Error" },
{ 0x13, 0x6F, 0x03, "Software NMI", { "", "", "", "", "", "", "" }, "Error" },
{ 0x13, 0x6F, 0x04, "Parity error has occurred on a transfer to or from a device on one of the PCI buses", { "", "", "", "", "", "", "" }, "Error" },
{ 0x13, 0x6F, 0x05, "System error has occurred in the PCI subsystem", { "", "", "", "", "", "", "" }, "Error" },
{ 0x13, 0x6F, 0x06, "Failsafe timer timeout", { "", "", "", "", "", "", "" }, "Error" },
{ 0x13, 0x6F, 0x07, "Correctable data error", { "", "", "", "", "", "", "" }, "Informational" },
{ 0x13, 0x6F, 0x08, "Uncorrectable Bus Error: DataByte2=%1 DataByte3=%2", { "b2x", "b3x", "", "", "", "", "" }, "Error" },
{ 0x13, 0x70, 0x00, "IPMB Protocol Error", { "", "", "", "", "", "", "" }, "Error" },
{ 0x15, 0x08, 0x00, "%1 has been removed from Cage %2", { "ls", "b3m11110000", "", "", "", "", "" }, "Warning" },
{ 0x15, 0x08, 0x01, "%1 has been inserted in Cage %2", { "ls", "b3m11110000", "", "", "", "", "" }, "Informational" },
{ 0x19, 0x07, 0x02, "Cache Protocol and Parity error: %1", { "b3", "", "", "", "", "", "" }, "Error" },
{ 0x19, 0x70, 0x00, "ACPI hardware failure", { "", "", "", "", "", "", "" }, "Warning" },
{ 0x1B, 0x03, 0x01, "Hot Swap Cage %1: %2", { "b3m11110000", "ls", "", "", "", "", "" }, "Warning" },
{ 0x1B, 0x08, 0x00, "Hot Swap Cage %1: %2 has been removed", { "b3m11110000", "ls", "", "", "", "", "" }, "Warning" },
{ 0x1B, 0x08, 0x01, "Hot Swap Cage %1: %2 has been attached", { "b3m11110000", "ls", "", "", "", "", "" }, "Informational" },
{ 0x1C, 0x08, 0x00, "Hot Swap Cage %1: %2 has been removed", { "b3m11110000", "ls", "", "", "", "", "" }, "Warning" },
{ 0x1C, 0x08, 0x01, "Hot Swap Cage %1: %2 has been attached", { "b3m11110000", "ls", "", "", "", "", "" }, "Informational" },
{ 0x21, 0x6F, 0x00, "PCI Hot Plug fault asserted", { "", "", "", "", "", "", "" }, "Error" },
{ 0x21, 0x6F, 0x05, "PCI Hot Plug Powered off", { "", "", "", "", "", "", "" }, "Informational" },
{ 0x21, 0xEF, 0x00, "PCI Hot Plug fault deasserted", { "", "", "", "", "", "", "" }, "Informational" },
{ 0x21, 0xEF, 0x05, "PCI Hot Plug Powered On", { "", "", "", "", "", "", "" }, "Informational" },
{ 0x22, 0x6F, 0x06, "Normal ACPI server shutdown", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xC7, 0x6F, 0x00, "Netserver Management Controller started", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xC7, 0x6F, 0x01, "SDR area cleared.", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xC7, 0x6F, 0x02, "FRU internal use area cleared", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xC8, 0x6F, 0x00, "%1 failed remote management logins", { "b3", "", "", "", "", "", "" }, "Warning" },
{ 0xC8, 0x6F, 0x01, "Remote management user %1 login", { "b3", "", "", "", "", "", "" }, "Informational" },
{ 0xC8, 0x6F, 0x02, "Remote management user %1 logout", { "b3", "", "", "", "", "", "" }, "Informational" },
{ 0xC8, 0x6F, 0x03, "Remote management user %1 auto-logout", { "b3", "", "", "", "", "", "" }, "Informational" },
{ 0xC8, 0x6F, 0x04, "Remote management user %1 connection lost", { "b3", "", "", "", "", "", "" }, "Informational" },
{ 0xC8, 0x6F, 0x05, "Remote management user %1 dialback has failed", { "b3", "", "", "", "", "", "" }, "Informational" },
{ 0xC8, 0x6F, 0x06, "Integrated RA configuration reset to defaults", { "", "", "", "", "", "", "" }, "Warning" },
{ 0xC9, 0x01, 0x07, "%1 Voltage utilization warning", { "ls", "", "", "", "", "", "" }, "Warning" },
{ 0xC9, 0x01, 0x09, "%1 Voltage utilization error", { "ls", "", "", "", "", "", "" }, "Error" },
{ 0xC9, 0x6F, 0x00, "Remote-initiated <Ctrl-Alt-Del>", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xC9, 0x6F, 0x01, "Remote initiated reset", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xC9, 0x6F, 0x02, "Remote-initiated power cycle", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xC9, 0x6F, 0x03, "Remote-initiated power down", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xC9, 0x6F, 0x04, "Remote-initiated power up", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xC9, 0x6F, 0x05, "Automatic power shutdown due to critical condition", { "", "", "", "", "", "", "" }, "Error" },
{ 0xC9, 0x6F, 0x06, "Front panel power down", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xC9, 0x6F, 0x07, "Automatic graceful shutdown of NOS", { "", "", "", "", "", "", "" }, "Warning" },
{ 0xC9, 0x6F, 0x08, "Remote-initiated graceful shutdown of NOS by remote management user %1.", { "b3", "", "", "", "", "", "" }, "Informational" },
{ 0xCA, 0x6F, 0x01, "Remote management user %1 page: Modem error", { "b3", "", "", "", "", "", "" }, "Informational" },
{ 0xCA, 0x6F, 0x02, "Remote management page: No Connection", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xCA, 0x6F, 0x03, "Remote management TAP page: No ID= prompt", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xCA, 0x6F, 0x04, "Remote management TAP page: No message go-ahead", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xCA, 0x6F, 0x05, "Remote management TAP page: Message not accepted", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xCA, 0x6F, 0x06, "Remote management user %1 Email notification failed", { "b3", "", "", "", "", "", "" }, "Warning" },
{ 0xCB, 0x6F, 0x00, "Remote Control Card memory test started", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xCB, 0x6F, 0x01, "Remote Control Card memory test completed", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xCB, 0x6F, 0x02, "Remote Control Card memory test stopped by user", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xCB, 0x6F, 0x03, "Remote Control Card memory test halted, error: %1", { "b3", "", "", "", "", "", "" }, "Warning" },
{ 0xCC, 0x6F, 0x00, "Remote Control Card started", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xCC, 0x6F, 0x01, "Remote Control Card internal error", { "", "", "", "", "", "", "" }, "Warning" },
{ 0xCC, 0x6F, 0x02, "Remote Control Card firmware updated", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xCC, 0x6F, 0x03, "Remote Control Card battery low", { "", "", "", "", "", "", "" }, "Warning" },
{ 0xCC, 0x6F, 0x04, "Remote Control Card battery disconnected", { "", "", "", "", "", "", "" }, "Warning" },
{ 0xCC, 0x6F, 0x05, "Remote Control Card configuration reset to defaults", { "", "", "", "", "", "", "" }, "Warning" },
{ 0xCC, 0x6F, 0x06, "Remote Control Card: DHCP has assigned a new IP address", { "", "", "", "", "", "", "" }, "Warning" },
{ 0xD1, 0x6F, 0x01, "Front Panel Controller firmware updated", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xD1, 0x6F, 0x02, "Primary Hot Swap Cage Controller firmware updated", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xD1, 0x6F, 0x03, "Secondary Hot Swap Cage Controller firmware updated", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xD1, 0x6F, 0x05, "NetServer Management Controller firmware updated", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xD1, 0x6F, 0x06, "CPU Management Controller firmware updated", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xD2, 0x07, 0x01, "Volume capacity %1 percent exceeded minor threshold %2 percent on %3.", { "b2", "b3", "s1s", "", "", "", "" }, "Warning" },
{ 0xD2, 0x07, 0x02, "Volume capacity %1 percent exceeded major threshold %2 percent on %3.", { "b2", "b3", "s1s", "", "", "", "" }, "Error" },
{ 0xD2, 0x07, 0x08, "Volume capacity %1 percent exceeded warning threshold %2 percent on %3.", { "b2", "b3", "s1s", "", "", "", "" }, "Warning" },
{ 0xD3, 0x6F, 0x00, "Scsiflt/SMART SNMP agent is down", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xD3, 0x6F, 0x01, "Scsiflt/SMART SNMP agent is up.", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xD3, 0x6F, 0x07, "ScsiSMART: Duplicate host adapter ID in SCSI/SMART database.", { "", "", "", "", "", "", "" }, "Warning" },
{ 0xD3, 0x6F, 0x08, "ScsiSMART: Host adapter %1 discovered with ID %2 and manager ID %3.", { "b3", "s1s", "s2s", "", "", "", "" }, "Informational" },
{ 0xD3, 0x6F, 0x09, "ScsiSmart: Host adapter %1 has a new host adapter ID %2 and manager ID %3.", { "b3", "s1s", "s2s", "", "", "", "" }, "Informational" },
{ 0xD3, 0x6F, 0x0A, "ScsiSmart: Host adapter %1 failed.", { "b3", "", "", "", "", "", "" }, "Error" },
{ 0xD3, 0x6F, 0x0B, "ScsiSMART: Host adapter %1 recovered.", { "b3", "", "", "", "", "", "" }, "Informational" },
{ 0xD3, 0x6F, 0x0C, "ScsiSMART: Device failed: host adapter %1, Target ID %2 and LUN %3.", { "b2m11110000", "b3", "b2m00001111", "", "", "", "" }, "Error" },
{ 0xD3, 0x6F, 0x0D, "ScsiSMART: Device discovered: host adapter %1, Target ID %2 and LUN %3 of vendor %4 product %5.", { "b2m11110000", "b3", "b2m00001111", "s1s", "s2s", "", "" }, "Informational" },
{ 0xD3, 0x6F, 0x0E, "ScsiSMART: Device recovered: host adapter %1, Target ID %2 and LUN %3.", { "b2m11110000", "b3", "b2m00001111", "", "", "", "" }, "Informational" },
{ 0xD3, 0x6F, 0x0F, "ScsiSMART: Device has new vendor and product information: host adapter %1, Target ID %2 and LUN %3 vendor %4 product %5.", { "b2m11110000", "b3", "b2m00001111", "s1s", "s2s", "", "" }, "Informational" },
{ 0xD3, 0x70, 0x00, "ScsiSMART: SMART predictive failure detected: host adapter %1, Target ID %2 and LUN %3 vendor %4 product %5 sense info %6.", { "b2m11110000", "b3", "b2m00001111", "s1s", "s2s", "s3i", "" }, "Error" },
{ 0xD3, 0x70, 0x01, "ScsiSMART: ASPI database cleared. Previous data unavailable.", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xD3, 0x70, 0x02, "ScsiSMART: ASPI interface crashed, restart IOMANAGER and this agent on the server.", { "", "", "", "", "", "", "" }, "Error" },
{ 0xD3, 0x70, 0x03, "ScsiSMART: Not enough memory for ASPI operation.", { "", "", "", "", "", "", "" }, "Warning" },
{ 0xD3, 0x70, 0x04, "ScsiSMART: Unable to open ASPI database for writing. Possible problem with server hard disk.", { "", "", "", "", "", "", "" }, "Warning" },
{ 0xD3, 0x70, 0x05, "ScsiSMART: Unable to open ASPI database. Possible problem with server hard disk.", { "", "", "", "", "", "", "" }, "Warning" },
{ 0xD3, 0x70, 0x06, "ScsiSMART: ASPI database missing.", { "", "", "", "", "", "", "" }, "Warning" },
{ 0xD3, 0x70, 0x07, "ScsiSMART: ASPI memory allocation failed.", { "", "", "", "", "", "", "" }, "Warning" },
{ 0xD3, 0x70, 0x08, "ScsiSMART: unable to read the ASPI database, hard disk may have problems.", { "", "", "", "", "", "", "" }, "Warning" },
{ 0xD3, 0x70, 0x09, "ScsiSMART: ASPI database is corrupted.", { "", "", "", "", "", "", "" }, "Warning" },
{ 0xD3, 0x70, 0x0E, "Scsiflt/SMART SNMP agent is down", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xD3, 0x70, 0x0F, "Scsiflt/SMART SNMP agent is up.", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xD3, 0x71, 0x06, "ScsiSMART: Host adapter %1 discovered with ID %2 and manager ID %3.", { "b3", "s1s", "s2s", "", "", "", "" }, "Informational" },
{ 0xD3, 0x71, 0x07, "ScsiSmart: Host adapter %1 has a new host adapter ID %2 and manager ID %3.", { "b3", "s1s", "s2s", "", "", "", "" }, "Informational" },
{ 0xD3, 0x71, 0x08, "ScsiSmart: Host adapter %1 failed.", { "b3", "", "", "", "", "", "" }, "Error" },
{ 0xD3, 0x71, 0x09, "ScsiSMART: Host adapter %1 recovered.", { "b3", "", "", "", "", "", "" }, "Informational" },
{ 0xD3, 0x71, 0x0A, "ScsiSMART: Device failed: host adapter %1, Target ID %2 and LUN %3.", { "b2m11110000", "b3", "b2m00001111", "", "", "", "" }, "Error" },
{ 0xD3, 0x71, 0x0B, "ScsiSMART: Device discovered: host adapter %1, Target ID %2 and LUN %3 of vendor %4 product %5.", { "b2m11110000", "b3", "b2m00001111", "s1s", "s2s", "", "" }, "Informational" },
{ 0xD3, 0x71, 0x0C, "ScsiSMART: Device recovered: host adapter %1, Target ID %2 and LUN %3.", { "b2m11110000", "b3", "b2m00001111", "", "", "", "" }, "Informational" },
{ 0xD3, 0x71, 0x0D, "ScsiSMART: Device has new vendor and product information: host adapter %1, Target ID %2 and LUN %3 vendor %4 product %5.", { "b2m11110000", "b3", "b2m00001111", "s1s", "s2s", "", "" }, "Informational" },
{ 0xD3, 0x71, 0x0E, "ScsiSMART: SMART predictive failure detected: host adapter %1, Target ID %2 and LUN %3 vendor %4 product %5 sense info %6.", { "b2m11110000", "b3", "b2m00001111", "s1s", "s2s", "s3i", "" }, "Error" },
{ 0xD3, 0x71, 0x0F, "ScsiSMART: There was an internal error. Previous data unavailable", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xD4, 0x6F, 0x01, "NetRAID: a new configuration has been written for host adapter %1.", { "b3", "", "", "", "", "", "" }, "Informational" },
{ 0xD4, 0x6F, 0x02, "NetRAID: physical drive state changed for host adapter %1, channel %2 and TargetID %3, state changed from %4 to %5.", { "b2m11110000", "b2m00001111", "b3", "s1s", "s2s", "", "" }, "Warning" },
{ 0xD4, 0x6F, 0x03, "NetRAID: state changed for host adapter %1, logical drive %2 state changed from %3 to %4.", { "b2", "b3", "s1s", "s2s", "", "", "" }, "Warning" },
{ 0xD4, 0x6F, 0x04, "NetRAID: initialization started for host adapter %1, logical drive %2.", { "b2", "b3", "", "", "", "", "" }, "Informational" },
{ 0xD4, 0x6F, 0x05, "NetRAID: Initialization completed successfully for host adapter %1, logical drive %2.", { "b2", "b3", "", "", "", "", "" }, "Informational" },
{ 0xD4, 0x6F, 0x06, "NetRAID: Initialization aborted by user for host adapter %1 logical drive %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD4, 0x6F, 0x07, "NetRAID: Initialization failed for host adapter %1, logical drive %2.", { "b2", "b3", "", "", "", "", "" }, "Error" },
{ 0xD4, 0x6F, 0x08, "NetRAID: Check consistency started in adapter %1, logical drive %2.", { "b2", "b3", "", "", "", "", "" }, "Informational" },
{ 0xD4, 0x6F, 0x09, "NetRAID: Check consistency completed, no inconsistencies found in adapter %1, logical drive %2.", { "b2", "b3", "", "", "", "", "" }, "Informational" },
{ 0xD4, 0x6F, 0x0A, "NetRAID: Check consistency aborted by user in adapter %1, logical drive %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD4, 0x6F, 0x0B, "NetRAID: Check consistency complete in adapter %1, logical drive %2. Inconsistencies have been CORRECTED.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD4, 0x6F, 0x0C, "NetRAID: Check consistency failed in adapter %1, logical drive %2.", { "b2", "b3", "", "", "", "", "" }, "Error" },
{ 0xD4, 0x6F, 0x0D, "NetRAID: Reconstruction started on adapter %1, logical drive %2.", { "b2", "b3", "", "", "", "", "" }, "Informational" },
{ 0xD4, 0x6F, 0x0E, "NetRAID: Reconstruction completed successfully on adapter %1, logical drive %2.", { "b2", "b3", "", "", "", "", "" }, "Informational" },
{ 0xD4, 0x6F, 0x0F, "NetRAID: Reconstruction failed on adapter %1, logical drive %2.", { "b2", "b3", "", "", "", "", "" }, "Error" },
{ 0xD4, 0x70, 0x00, "NetRAID: Reported failure prediction threshold exceeded [False] on adapter %1, channel %2, and Target ID %3 product %4 sense_key= %5 ASC= %6 ASCQ= %7.", { "b2m11110000", "b2m00001111", "b3", "s1s", "s2i", "s3i", "s4i" }, "Error" },
{ 0xD4, 0x70, 0x01, "NetRAID: Predictive failure reported on adapter %1, channel %2 and Target ID %3 product %4 sense_key= %5 ASC= %6 ASCQ= %7.", { "b2m11110000", "b2m00001111", "b3", "s1s", "s2i", "s3i", "s4i" }, "Warning" },
{ 0xD4, 0x70, 0x02, "NetRAID: Command completed with check condition on adapter %1, channel %2 and Target ID %3 sense_key= %4 ASC= %5 ASCQ= %6.", { "b2m11110000", "b2m00001111", "b3", "s1i", "s2i", "s3i", "" }, "Informational" },
{ 0xD4, 0x70, 0x03, "NetRAID: New device inserted on adapter %1, channel %2 and Target ID %3.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Informational" },
{ 0xD4, 0x70, 0x04, "NetRAID: Battery module is missing on adapter %1.", { "b3", "", "", "", "", "", "" }, "Warning" },
{ 0xD4, 0x70, 0x05, "NetRAID: Battery module voltage is low on adapter %1.", { "b3", "", "", "", "", "", "" }, "Warning" },
{ 0xD4, 0x70, 0x06, "NetRAID: Battery module temperature exceeded danger threshold on adapter %1.", { "b3", "", "", "", "", "", "" }, "Warning" },
{ 0xD4, 0x71, 0x00, "HPDA Controller: Adapter-%1 Cache Error", { "b2m11110000", "", "", "", "", "", "" }, "Error" },
{ 0xD4, 0x71, 0x01, "HPDA Logical Drive: Critical", { "", "", "", "", "", "", "" }, "Warning" },
{ 0xD4, 0x71, 0x02, "HPDA Logical Drive: Not Available", { "", "", "", "", "", "", "" }, "Error" },
{ 0xD4, 0x71, 0x03, "HPDA Hot Spare: Adapter-%1, Channel-%2, TargetID-%3 Failed.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD4, 0x71, 0x04, "HPDA Hot Spare: Succeeded", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xD4, 0x71, 0x05, "HPDA Hard Disk: Adapter-%1, Channel-%2, TargetID-%3 Failed.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD4, 0x71, 0x06, "HPDA:Parity Threshold Exceeded, Adapter-%1, Channel-%2, TargetID-%3.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD4, 0x71, 0x07, "HPDA: Soft Error Threshold Exceeded, Adapter-%1, Channel-%2, TargetID-%3.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD4, 0x71, 0x08, "HPDA: Hardware Error Threshold Exceeded, Adapter-%1, Channel-%2, TargetID-%3.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD4, 0x71, 0x09, "HPDA: Miscellaneous Error Threshold Exceeded, Adapter-%1, Channel-%2, TargetID-%3.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD4, 0x71, 0x0A, "HPDA Controller: Adapter-%1 NVRAM Age.", { "b2m11110000", "", "", "", "", "", "" }, "Informational" },
{ 0xD5, 0x6F, 0x01, "NIC adapter %1 adapter mismatch.", { "b2", "", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x70, 0x04, "NIC adapter %1 received errors exceeded relative threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x70, 0x05, "NIC adapter %1 transmit errors exceeded relative threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x70, 0x06, "NIC adapter %1 adapter reset errors exceeded relative threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Error" },
{ 0xD5, 0x70, 0x07, "NIC adapter %1 alignment errors exceeded relative threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x70, 0x08, "NIC adapter %1 giant frame errors exceeded relative threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x70, 0x09, "NIC adapter %1 hardware mismatch errors exceeded relative threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x70, 0x0A, "NIC adapter %1 late collisions errors exceeded relative threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x70, 0x0B, "NIC adapter %1 excessive collision errors exceeded relative threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x70, 0x0C, "NIC adapter %1 carrier sense exceeded error relative threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x70, 0x0D, "NIC adapter %1 deferral error exceeded relative threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x70, 0x0E, "NIC adapter %1 no ECB errors exceeded relative threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x70, 0x0F, "NIC adapter %1 Rx overflow errrors exceeded relative threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Error" },
{ 0xD5, 0x71, 0x00, "NIC adapter %1 utilization count exceeded relative threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Informational" },
{ 0xD5, 0x71, 0x08, "NIC adapter %1 received errors exceeded absolute threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x71, 0x09, "NIC adapter %1 transmit errors exceeded absolute threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x71, 0x0A, "NIC adapter %1 adapter reset errors exceeded absolute threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Error" },
{ 0xD5, 0x71, 0x0B, "NIC Adapter %1 alignment errors exceeded absolute threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x71, 0x0C, "NIC adapter %1 giant frame errors exceeded absolute threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x71, 0x0D, "NIC adapter %1 hardware mismatch errors exceeded absolute threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x71, 0x0E, "NIC adapter %1 late collisions errors exceeded absolute threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x71, 0x0F, "NIC adapter %1 excessive collision errors exceeded absolute threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x72, 0x00, "NIC adapter %1 carrier sense error exceeded absolute threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x72, 0x01, "NIC adapter %1 deferral error exceeded absolute threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x72, 0x02, "NIC adapter %1 no ECB errors exceeded absolute threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x72, 0x03, "NIC adapter %1 Rx overflow errrors exceeded absolute threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Error" },
{ 0xD5, 0x72, 0x04, "NIC adapter %1 utilization count exceeded absolute threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Informational" },
{ 0xD5, 0x72, 0x05, "The active NIC %1 in redundant group %2 has failed. The standby NIC %3 took over.", { "b3m11110000", "b3m00001111", "b2", "", "", "", "" }, "Warning" },
{ 0xD5, 0x72, 0x06, "A previously failed NIC %1 in redundant group %2 has become operational.", { "b2", "b3", "", "", "", "", "" }, "Informational" },
{ 0xD5, 0x72, 0x07, "The standby NIC %1 in redundant group %2 has failed.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x72, 0x08, "All NICs (active and standby) in redundant group %1 have failed.", { "b3", "", "", "", "", "", "" }, "Error" },
{ 0xD5, 0x72, 0x0C, "NIC adapter %1 received errors exceeded delta threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x72, 0x0D, "NIC adapter %1 transmit errors exceeded delta threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x72, 0x0E, "NIC adapter %1 adapter reset errors exceeded delta threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Error" },
{ 0xD5, 0x72, 0x0F, "NIC adapter %1 alignment errors exceeded delta threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x73, 0x00, "NIC adapter %1 giant frame errors exceeded delta threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x73, 0x01, "NIC adapter %1 hardware mismatch errors exceeded delta threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x73, 0x02, "NIC adapter %1 late collisions errors exceeded delta threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x73, 0x03, "NIC adapter %1 excessive collision errors exceeded delta threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x73, 0x04, "NIC adapter %1 carrier sense error exceeded delta threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x73, 0x05, "NIC adapter %1 deferral error exceeded delta threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x73, 0x06, "NIC adapter %1 no ECB errors exceeded delta threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xD5, 0x73, 0x07, "NIC adapter %1 Rx overflow errrors exceeded delta threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Error" },
{ 0xD5, 0x73, 0x08, "NIC adapter %1 utilization count exceeded delta threshold: current value is %2.", { "b2", "b3", "", "", "", "", "" }, "Informational" },
{ 0xD6, 0x6F, 0x01, "Hba%1:Channel%2:ScsiID%3 Tape Device Has Problems Reading Data", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD6, 0x6F, 0x02, "Hba%1:Channel%2:ScsiID%3 Tape Device Has Problems Writing Data", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD6, 0x6F, 0x03, "Hba%1:Channel%2:ScsiID%3 Tape Device Has Detected Read or Write Data Error", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD6, 0x6F, 0x04, "Hba%1:Channel%2:ScsiID%3 Tape Device Has Detected Faulty Media [%4]", { "b2m11110000", "b2m00001111", "b3", "s1s", "", "", "" }, "Error" },
{ 0xD6, 0x6F, 0x05, "Hba%1:Channel%2:ScsiID%3 Tape Device May Have Read Fault - Call Helpline", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x6F, 0x06, "Hba%1:Channel%2:ScsiID%3 Tape Device May Have Write Fault - Call Helpline", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x6F, 0x07, "Hba%1:Channel%2:ScsiID%3 Tape Device Has Detected Worn Out Media [%4]", { "b2m11110000", "b2m00001111", "b3", "s1s", "", "", "" }, "Warning" },
{ 0xD6, 0x6F, 0x08, "Hba%1:Channel%2:ScsiID%3 Media Loaded In Tape Device Is Not Data Grade", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD6, 0x6F, 0x09, "Hba%1:Channel%2:ScsiID%3 Tape Device Attempted Backup to Write-Protected Tape", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x6F, 0x0A, "Hba%1:Channel%2:ScsiID%3 Tape Device Eject Attempted When Media Locked", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Informational" },
{ 0xD6, 0x6F, 0x0B, "Hba%1:Channel%2:ScsiID%3 Tape Device Attempted Backup/Restore To Cleaning Tape", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Informational" },
{ 0xD6, 0x6F, 0x0C, "Hba%1:Channel%2:ScsiID%3 Media Loaded In Tape Device Is Unsupported Type", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Informational" },
{ 0xD6, 0x6F, 0x0D, "Hba%1:Channel%2:ScsiID%3 Tape Device Has Detected Snapped Tape", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x6F, 0x0E, "Hba%1:Channel%2:ScsiID%3 Tape Device Has Detected Snapped Tape", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x6F, 0x0F, "Hba%1:Channel%2:ScsiID%3 Tape Device Has Memory Chip in Cartridge Failure", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD6, 0x70, 0x00, "Hba%1:Channel%2:ScsiID%3 Tape Cartridge Ejected While Actively Writing/Reading", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x70, 0x01, "Hba%1:Channel%2:ScsiID%3 Tape Device Has Detected Read Only Media", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD6, 0x70, 0x02, "Hba%1:Channel%2:ScsiID%3 Tape Device Has Detected Corrupted Directory On Tape", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD6, 0x70, 0x04, "Hba%1:Channel%2:ScsiID%3 Tape Device Needs Cleaning", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x70, 0x05, "Hba%1:Channel%2:ScsiID%3 Tape Device Requests Routine Cleaning", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD6, 0x70, 0x06, "Hba%1:Channel%2:ScsiID%3 Tape Device Has Detected Worn Out Cleaning Cartridge", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x70, 0x07, "Hba%1:Channel%2:ScsiID%3 Tape Device Has Detected Invalid Cleaning Cartridge", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x70, 0x0D, "Hba%1:Channel%2:ScsiID%3 Tape Device Requires Preventative Maintenance", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD6, 0x70, 0x0E, "Hba%1:Channel%2:ScsiID%3 Tape Device Has Hardware Fault - Reset Drive", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x70, 0x0F, "Hba%1:Channel%2:ScsiID%3 Tape Device Has Hardware Fault - Call Helpline", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x71, 0x00, "Hba%1:Channel%2:ScsiID%3 Tape Device Has SCSI Interface Fault", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD6, 0x71, 0x01, "Hba%1:Channel%2:ScsiID%3 Tape Device Has Eject Media Request", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x71, 0x02, "Hba%1:Channel%2:ScsiID%3 Tape Device Has Firmware Download Fault", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD6, 0x71, 0x03, "Hba%1:Channel%2:ScsiID%3 Tape Device Humidity Specification Exceeded", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD6, 0x71, 0x04, "Hba%1:Channel%2:ScsiID%3 Tape Device Temperature Specification Exceeded", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD6, 0x71, 0x05, "Hba%1:Channel%2:ScsiID%3 Tape Device Voltage Specification Exceeded", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD6, 0x71, 0x06, "Hba%1:Channel%2:ScsiID%3 Tape Device Predicted to Fail - Call Helpline", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x71, 0x07, "Hba%1:Channel%2:ScsiID%3 Tape Device May Have Hardware Fault - Run Diagnostics", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD6, 0x71, 0x08, "Hba%1:Channel%2:ScsiID%3 Tape Device Has Autoloader Communications Fault", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x71, 0x09, "Hba%1:Channel%2:ScsiID%3 Tape Device Detects Stray Tape In Autoloader", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x71, 0x0A, "Hba%1:Channel%2:ScsiID%3 Tape Device Has Autoloader Mechanism Fault", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD6, 0x71, 0x0B, "Hba%1:Channel%2:ScsiID%3 Tape Device Has Autoloader Door Open", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x71, 0x0C, "Hba%1:Channel%2:ScsiID%3 Autoloader Has Hardware Fault - Call Helpline", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x71, 0x0D, "Hba%1:Channel%2:ScsiID%3 Autoloader Cannot Operate Without Magazine", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x71, 0x0E, "Hba%1:Channel%2:ScsiID%3 Autoloader Predicted to Fail - Call Helpline", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD6, 0x72, 0x02, "Hba%1:Channel%2:ScsiID%3 Library Has Drive Communications Fault", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x72, 0x03, "Hba%1:Channel%2:ScsiID%3 Library Has Changer Mechanism Fault", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD6, 0x72, 0x04, "Hba%1:Channel%2:ScsiID%3 Library Has Hardware Fault - Reset Library", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x72, 0x05, "Hba%1:Channel%2:ScsiID%3 Library Has Hardware Fault - Call Helpline", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x72, 0x06, "Hba%1:Channel%2:ScsiID%3 Library May Have Hardware Fault - Run Diagnostics", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD6, 0x72, 0x07, "Hba%1:Channel%2:ScsiID%3 Library Has Host Interface Fault", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x72, 0x08, "Hba%1:Channel%2:ScsiID%3 Library Predicted to Fail - Call Helpline", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD6, 0x72, 0x09, "Hba%1:Channel%2:ScsiID%3 Library Requires Preventative Maintenance", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD6, 0x72, 0x0A, "Hba%1:Channel%2:ScsiID%3 Library Humidity Specification Exceeded", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x72, 0x0B, "Hba%1:Channel%2:ScsiID%3 Library Temperature Specification Exceeded", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x72, 0x0C, "Hba%1:Channel%2:ScsiID%3 Library Voltage Specification Exceeded", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x72, 0x0D, "Hba%1:Channel%2:ScsiID%3 Library Detects Stray Tape In Drive", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x72, 0x0E, "Hba%1:Channel%2:ScsiID%3 Library Has Problems Picking Cartridge from Slot", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD6, 0x72, 0x0F, "Hba%1:Channel%2:ScsiID%3 Library Has Problems Placing Cartridge into Slot", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD6, 0x73, 0x00, "Hba%1:Channel%2:ScsiID%3 Library Has Problems Loading Cartridge into Drive", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD6, 0x73, 0x01, "Hba%1:Channel%2:ScsiID%3 Library Door is Open", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x73, 0x02, "Hba%1:Channel%2:ScsiID%3 Library Has Mechanical Fault with Mailslot", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x73, 0x03, "Hba%1:Channel%2:ScsiID%3 Library Cannot Operate Without Magazine", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x73, 0x04, "Hba%1:Channel%2:ScsiID%3 Library Security Has Been Compromised", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD6, 0x73, 0x05, "Hba%1:Channel%2:ScsiID%3 Library Security Mode Changed", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Informational" },
{ 0xD6, 0x73, 0x06, "Hba%1:Channel%2:ScsiID%3 Library Manually Turned Offline", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Informational" },
{ 0xD6, 0x73, 0x07, "Hba%1:Channel%2:ScsiID%3 Library Drive Turned Offline", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Informational" },
{ 0xD6, 0x73, 0x08, "Hba%1:Channel%2:ScsiID%3 Library Has Problems Reading Barcode Labels", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD6, 0x73, 0x09, "Hba%1:Channel%2:ScsiID%3 Library Inventory is Inconsistent", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xD6, 0x73, 0x0A, "Hba%1:Channel%2:ScsiID%3 Invalid Library Operation Attempted", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xD7, 0x6F, 0x01, "Communication lost between the agent and the UPS.", { "", "", "", "", "", "", "" }, "Error" },
{ 0xD7, 0x6F, 0x02, "The UPS has sensed a load greater than 100 percent of its rated capacity.", { "", "", "", "", "", "", "" }, "Error" },
{ 0xD7, 0x6F, 0x03, "The UPS has failed its internal self-test.", { "", "", "", "", "", "", "" }, "Error" },
{ 0xD7, 0x6F, 0x04, "The UPS batteries are discharged.", { "", "", "", "", "", "", "" }, "Error" },
{ 0xD7, 0x6F, 0x05, "The UPS is now providing battery backup power.", { "", "", "", "", "", "", "" }, "Error" },
{ 0xD7, 0x6F, 0x06, "The UPS has enabled SmartBoost.", { "", "", "", "", "", "", "" }, "Warning" },
{ 0xD7, 0x6F, 0x07, "The batteries of the UPS system are low and will soon be exhausted.", { "", "", "", "", "", "", "" }, "Error" },
{ 0xD7, 0x6F, 0x08, "APC UPS: Communication established", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xD7, 0x6F, 0x09, "Normal power has been restored to the UPS.", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xD7, 0x6F, 0x0A, "The UPS has passed its internal self-test.", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xD7, 0x6F, 0x0B, "The UPS has returned from a low battery condition.", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xD7, 0x6F, 0x0D, "The UPS is going into sleep mode.", { "", "", "", "", "", "", "" }, "Error" },
{ 0xD7, 0x70, 0x01, "The UPS batteries require immediate replacement.", { "", "", "", "", "", "", "" }, "Error" },
{ 0xD7, 0x70, 0x02, "A Measure-UPS contact closure has faulted", { "", "", "", "", "", "", "" }, "Error" },
{ 0xD7, 0x70, 0x03, "A Measure-UPS contact closure has returned to the default state", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xD7, 0x70, 0x04, "The UPS is on bypass due to a hardware failure.", { "", "", "", "", "", "", "" }, "Error" },
{ 0xD7, 0x70, 0x05, "UPS put on bypass by user via software or front UPS panel.", { "", "", "", "", "", "", "" }, "Warning" },
{ 0xD7, 0x70, 0x06, "UPS put on bypass by user via rear UPS switch.", { "", "", "", "", "", "", "" }, "Warning" },
{ 0xD7, 0x70, 0x07, "The UPS has returned from bypass mode.", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xD7, 0x70, 0x08, "The base module bypass power supply needs repair.", { "", "", "", "", "", "", "" }, "Error" },
{ 0xD7, 0x70, 0x09, "The base module fan needs repair.", { "", "", "", "", "", "", "" }, "Error" },
{ 0xD7, 0x70, 0x0A, "Communication lost with external battery packs, check battery signal cable.", { "", "", "", "", "", "", "" }, "Warning" },
{ 0xD7, 0x70, 0x0B, "Communication established with external battery packs.", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xD7, 0x70, 0x0C, "A battery run time calibration test has been initiated.", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xD8, 0x6F, 0x00, "SCSI Status agent was unloaded from a NetWare Server.", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xD8, 0x6F, 0x05, "The SCSI Status agent sent a request to an HBA and the request never completed", { "", "", "", "", "", "", "" }, "Error" },
{ 0xD8, 0x6F, 0x06, "The SCSI Status agent sent a request to a SCSI device and the request never completed.", { "", "", "", "", "", "", "" }, "Error" },
{ 0xD8, 0x6F, 0x08, "A new SCSI Host Bus Adapter has been discovered or device database has been cleared", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xD8, 0x6F, 0x09, "The SCSI Status agent detected that the Host Bus Adapter has been changed.", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xD8, 0x6F, 0x0A, "One of the SCSI HBAs can no longer be detected by the SCSI Status agent.", { "", "", "", "", "", "", "" }, "Error" },
{ 0xD8, 0x6F, 0x0B, "A Host Adapter which has failed, has become accessible again", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xD8, 0x6F, 0x0C, "One of the SCSI devices installed on the server can no longer be detected by the SCSI Status agent.", { "", "", "", "", "", "", "" }, "Error" },
{ 0xD8, 0x6F, 0x0D, "A new SCSI device has been discovered", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xD8, 0x6F, 0x0E, "A SCSI device which has failed, has become accessible again.", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xD8, 0x6F, 0x0F, "The SCSI Status agent detected that a SCSI device installed on the server has been changed.", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xD8, 0x70, 0x09, "Device Database has been corrupted.", { "", "", "", "", "", "", "" }, "Error" },
{ 0xDA, 0x70, 0x00, "An unrecognized HW log event was detected.", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x6F, 0x00, "FCArray: [ctl %1 chn %2 tgt %3:] device became online.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Informational" },
{ 0xDB, 0x6F, 0x01, "FCArray: [ctl %1 chn %2 tgt %3:] A physical device became a hot spare.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Informational" },
{ 0xDB, 0x6F, 0x02, "FCArray: [ctl %1 chn %2 tgt %3:] Hard disk error found.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xDB, 0x6F, 0x03, "FCArray: [ctl %1 chn %2 tgt %3:] Hard disk PFA condition found, drive may fail.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Warning" },
{ 0xDB, 0x6F, 0x04, "FCArray: [ctl %1 chn %2 tgt %3:] An automatic rebuild has started.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Informational" },
{ 0xDB, 0x6F, 0x05, "FCArray: [ctl %1 chn %2 tgt %3:] A manual rebuild has started.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Informational" },
{ 0xDB, 0x6F, 0x06, "FCArray: [ctl %1 chn %2 tgt %3:] Rebuild completed.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Informational" },
{ 0xDB, 0x6F, 0x07, "FCArray: [ctl %1 chn %2 tgt %3:] Rebuild cancelled.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Informational" },
{ 0xDB, 0x6F, 0x08, "FCArray: [ctl %1 chn %2 tgt %3:] Rebuild stopped with errors.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xDB, 0x6F, 0x09, "FCArray: [ctl %1 chn %2 tgt %3:] Rebuild failed due to new physical device.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xDB, 0x6F, 0x0A, "FCArray: [ctl %1 chn %2 tgt %3:] Rebuild failed due to logical device failure.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xDB, 0x6F, 0x0B, "FCArray: [ctl %1 chn %2 tgt %3:] A physical device failed.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xDB, 0x6F, 0x0C, "FCArray: [ctl %1 chn %2 tgt %3:] A physical device was found.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Informational" },
{ 0xDB, 0x6F, 0x0D, "FCArray: [ctl %1 chn %2 tgt %3:] A physical device is gone.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Informational" },
{ 0xDB, 0x6F, 0x0E, "FCArray: [ctl %1 chn %2 tgt %3:] A physical device is unconfigured.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Informational" },
{ 0xDB, 0x6F, 0x0F, "FCArray: [ctl %1 chn %2 tgt %3:] Expand capacity started.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Informational" },
{ 0xDB, 0x70, 0x00, "FCArray: [ctl %1 chn %2 tgt %3:] Expand capacity finished.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Informational" },
{ 0xDB, 0x70, 0x01, "FCArray: [ctl %1 chn %2 tgt %3:] Expand capacity failed.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xDB, 0x70, 0x02, "FCArray:[ctl %1 chn %2 tgt %3:] Command to physical device timed out.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xDB, 0x70, 0x03, "FCArray:[ctl %1 chn %2 tgt %3:] Physical device command aborted.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Error" },
{ 0xDB, 0x70, 0x04, "FCArray:[ctl %1 chn %2 tgt %3:] Command was retried.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Informational" },
{ 0xDB, 0x70, 0x05, "FCArray:[ctl %1 chn %2 tgt %3:] Parity error.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Informational" },
{ 0xDB, 0x70, 0x06, "FCArray:[ctl %1 chn %2 tgt %3:] Soft error.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Informational" },
{ 0xDB, 0x70, 0x07, "FCArray:[ctl %1 chn %2 tgt %3:] Miscellaneous error.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Informational" },
{ 0xDB, 0x70, 0x08, "FCArray:[ctl %1 chn %2 tgt %3:] Physical device reset.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Informational" },
{ 0xDB, 0x70, 0x09, "FCArray:[ctl %1 chn %2 tgt %3:] A physical device became and active spare.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Informational" },
{ 0xDB, 0x70, 0x0A, "FCArray:[ctl %1 chn %2 tgt %3:] A physical device became a warm spare.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Informational" },
{ 0xDB, 0x70, 0x0B, "FCArray:[ctl %1 chn %2 tgt %3:] Request sense data present.", { "b2m11110000", "b2m00001111", "b3", "", "", "", "" }, "Informational" },
{ 0xDB, 0x70, 0x0C, "FCArray:[ctl %1 logdrv %2:] Consistency check started.", { "b2", "b3", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x70, 0x0D, "FCArray:[ctl %1 logdrv %2:] Consistency check completed with no errors.", { "b2", "b3", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x70, 0x0E, "FCArray:[ctl %1 logdrv %2:] Consistency check cancelled.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xDB, 0x70, 0x0F, "FCArray:[ctl %1 logdrv %2:] Consistency check completed with an error.", { "b2", "b3", "", "", "", "", "" }, "Error" },
{ 0xDB, 0x71, 0x00, "FCArray:[ctl %1 logdrv %2:] Consistency check failed due to logical device.", { "b2", "b3", "", "", "", "", "" }, "Error" },
{ 0xDB, 0x71, 0x01, "FCArray:[ctl %1 logdrv %2:] Consistency check failed due to physical device.", { "b2", "b3", "", "", "", "", "" }, "Error" },
{ 0xDB, 0x71, 0x02, "FCArray:[ctl %1 logdrv %2:] Logical device became offline.", { "b2", "b3", "", "", "", "", "" }, "Error" },
{ 0xDB, 0x71, 0x03, "FCArray: [ctl %1 logdrv %2:] Logical device became critical.", { "b2", "b3", "", "", "", "", "" }, "Error" },
{ 0xDB, 0x71, 0x04, "FCArray: [ctl %1 logdrv %2:] Logical device became online.", { "b2", "b3", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x71, 0x05, "FCArray:[ctl %1 logdrv %2:] Automatic rebuild started.", { "b2", "b3", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x71, 0x06, "FCArray:[ctl %1 logdrv %2:] Manual rebuild started.", { "b2", "b3", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x71, 0x07, "FCArray:[ctl %1 logdrv %2:] Rebuild completed.", { "b2", "b3", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x71, 0x08, "FCArray: [ctl %1 logdrv %2:] Rebuild cancelled.", { "b2", "b3", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x71, 0x09, "FCArray:[ctl %1 logdrv %2:] Rebuild error.", { "b2", "b3", "", "", "", "", "" }, "Error" },
{ 0xDB, 0x71, 0x0A, "FCArray:[ctl %1 logdrv %2:] Rebuild failed due to new physical device.", { "b2", "b3", "", "", "", "", "" }, "Error" },
{ 0xDB, 0x71, 0x0B, "FCArray:[ctl %1 logdrv %2:] Rebuild failed due to logical device failure.", { "b2", "b3", "", "", "", "", "" }, "Error" },
{ 0xDB, 0x71, 0x0C, "FCArray:[ctl %1 logdrv %2:] A logical device initialization started.", { "b2", "b3", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x71, 0x0D, "FCArray:[ctl %1 logdrv %2:] A logical device initialization completed.", { "b2", "b3", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x71, 0x0E, "FCArray:[ctl %1 logdrv %2:] A logical device initialization was cancelled.", { "b2", "b3", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x71, 0x0F, "FCArray:[ctl %1 logdrv %2:] A logical drive initialization failed.", { "b2", "b3", "", "", "", "", "" }, "Error" },
{ 0xDB, 0x72, 0x00, "FCArray:[ctl %1 logdrv %2:] A logical device was found.", { "b2", "b3", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x72, 0x01, "FCArray:[ctl %1 logdrv %2:] A logical device is gone.", { "b2", "b3", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x72, 0x02, "FCArray:[ctl %1 logdrv %2:] Expand capacity started.", { "b2", "b3", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x72, 0x03, "FCArray: [ctl %1 logdrv %2:] Expand capacity finished.", { "b2", "b3", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x72, 0x04, "FCArray:[ctl %1 logdrv %2:] Expand capacity failed.", { "b2", "b3", "", "", "", "", "" }, "Error" },
{ 0xDB, 0x72, 0x05, "FCArray:[ctl %1 logdrv %2:] Bad block was found.", { "b2", "b3", "", "", "", "", "" }, "Warning" },
{ 0xDB, 0x72, 0x06, "FCArray:[ctl %1 logdrv %2:] A system drive size changed.", { "b2", "b3", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x72, 0x07, "FCArray:[ctl %1 logdrv %2:] A system device type changed.", { "b2", "b3", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x72, 0x08, "FCArray:[ctl %1 logdrv %2:] A bad block was found on a logical device.", { "b2", "b3", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x72, 0x09, "FCArray:[ctl %1:] System started.", { "b2", "", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x72, 0x0A, "FCArray:[ctl %1:] Write back error.", { "b2", "", "", "", "", "", "" }, "Error" },
{ 0xDB, 0x72, 0x0B, "FCArray:[ctl %1:] State table is full.", { "b2", "", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x72, 0x0C, "FCArray:[ctl %1:] Controller is dead.", { "b2", "", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x72, 0x0D, "FCArray:[ctl %1:] Controller has reset.", { "b2", "", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x72, 0x0E, "FCArray:[ctl %1:] A controller was found.", { "b2", "", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x72, 0x0F, "FCArray:[ctl %1:] A controller is gone.", { "b2", "", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x73, 0x00, "FCArray:[ctl %1:] Battery Backup Unit found.", { "b2", "", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x73, 0x01, "FCArray:[ctl %1:] Battery Backup Unit power is low.", { "b2", "", "", "", "", "", "" }, "Warning" },
{ 0xDB, 0x73, 0x02, "FCArray:[ctl %1:] Battery Backup Unit power is OK.", { "b2", "", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x73, 0x03, "FCArray:[ctl %1:] Controller has been powered off.", { "b2", "", "", "", "", "", "" }, "Error" },
{ 0xDB, 0x73, 0x04, "FCArray:[ctl %1:] Controller has been powered on.", { "b2", "", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x73, 0x05, "FCArray:[ctl %1:] Controller Online", { "b2", "", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x73, 0x06, "FCArray:[ctl %1:] Controller offline.", { "b2", "", "", "", "", "", "" }, "Error" },
{ 0xDB, 0x73, 0x07, "FCArray:[ctl %1:] Controller partner is gone.", { "b2", "", "", "", "", "", "" }, "Error" },
{ 0xDB, 0x73, 0x08, "FCArray:[ctl %1:] Battery Backup Recondition Started.", { "b2", "", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x73, 0x09, "FCArray:[ctl %1:] Battery Backup Unit recondition finished.", { "b2", "", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x73, 0x0A, "FCArray:[ctl %1:] Battery Backup Unit Recondition Cancelled.", { "b2", "", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x73, 0x0B, "FCArray:[ctl %1:] Physical device size table is full.", { "b2", "", "", "", "", "", "" }, "Informational" },
{ 0xDB, 0x73, 0x0C, "FCArray:[ctl %1 chn %2 Cabinet %3 Fan %4:] Storage cabinet fan failed.", { "b2m11110000", "b2m00001111", "b3m11110000", "b3m00001111", "", "", "" }, "Error" },
{ 0xDB, 0x73, 0x0D, "FCArray:[ctl %1 chn %2 Cabinet %3 Fan %4:] Storage cabinet fan is OK.", { "b2m11110000", "b2m00001111", "b3m11110000", "b3m00001111", "", "", "" }, "Informational" },
{ 0xDB, 0x73, 0x0E, "FCArray:[ctl %1 chn %2 Cabinet %3 Fan %4:] Drive enclosure fan failed.", { "b2m11110000", "b2m00001111", "b3m11110000", "b3m00001111", "", "", "" }, "Error" },
{ 0xDB, 0x73, 0x0F, "FCArray:[ctl %1 chn %2 Cabinet %3 Fan %4:] Storage cabinet fan is not present.", { "b2m11110000", "b2m00001111", "b3m11110000", "b3m00001111", "", "", "" }, "Informational" },
{ 0xDB, 0x74, 0x00, "FCArray:[ctl %1 chn %2 Cabinet %3 PowerSupplyUnit %4:] Storage cabinet power supply failed.", { "b2m11110000", "b2m00001111", "b3m11110000", "b3m00001111", "", "", "" }, "Error" },
{ 0xDB, 0x74, 0x01, "FCArray: [ctl %1 chn %2 Cabinet %3 PowerSupplyUnit %4:] Storage cabinet power supply is OK.", { "b2m11110000", "b2m00001111", "b3m11110000", "b3m00001111", "", "", "" }, "Informational" },
{ 0xDB, 0x74, 0x02, "FCArray:[ctl %1 chn %2 Cabinet %3 PowerSupplyUnit %4:] Storage cabinet power supply is not present.", { "b2m11110000", "b2m00001111", "b3m11110000", "b3m00001111", "", "", "" }, "Informational" },
{ 0xDB, 0x74, 0x03, "FCArray:[ctl %1 chn %2 Cabinet %3 HeatSensor %4:] Storage cabinet too hot.", { "b2m11110000", "b2m00001111", "b3m11110000", "b3m00001111", "", "", "" }, "Error" },
{ 0xDB, 0x74, 0x04, "FCArray:[ctl %1 chn %2 Cabinet %3 HeatSensor %4:] Storage cabinet is hot.", { "b2m11110000", "b2m00001111", "b3m11110000", "b3m00001111", "", "", "" }, "Error" },
{ 0xDB, 0x74, 0x05, "FCArray:[ctl %1 chn %2 Cabinet %3 HeatSensor %4:] Storage cabinet temperature is OK.", { "b2m11110000", "b2m00001111", "b3m11110000", "b3m00001111", "", "", "" }, "Informational" },
{ 0xDB, 0x74, 0x06, "FCArray:[ctl %1 chn %2 Cabinet %3 HeatSensor %4:] Storage cabinet temperature sensor is not present.", { "b2m11110000", "b2m00001111", "b3m11110000", "b3m00001111", "", "", "" }, "Informational" },
{ 0xDF, 0x6F, 0x00, "NetRAID [ %1 ] Controller %2: A container property has changed for container %3.", { "s1s", "b2", "b3", "", "", "", "" }, "Informational" },
{ 0xDF, 0x6F, 0x01, "NetRAID [ %1 ] Controller %2: An I/O or general error has occurred on container %3.", { "s1s", "b2", "b3", "", "", "", "" }, "Error" },
{ 0xDF, 0x6F, 0x02, "NetRAID [ %1 ] Controller %2: Container %3 is no longer functioning as a mirror set.", { "s1s", "b2", "b3", "", "", "", "" }, "Error" },
{ 0xDF, 0x6F, 0x03, "NetRAID [ %1 ] Controller %2: The rebuild operation did not start because there is insufficient space on the spare disk(s) assigned to container %3 (mirror set).", { "s1s", "b2", "b3", "", "", "", "" }, "Error" },
{ 0xDF, 0x6F, 0x04, "NetRAID [ %1 ] Controller %2: A rebuild operation has started for container %3 (mirror set).", { "s1s", "b2", "b3", "", "", "", "" }, "Informational" },
{ 0xDF, 0x6F, 0x05, "NetRAID [ %1 ] Controller %2: A rebuild operation has failed for container %3.", { "s1s", "b2", "b3", "", "", "", "" }, "Error" },
{ 0xDF, 0x6F, 0x06, "NetRAID [ %1 ] Controller %2: The rebuild operation did not start because there is no spare disk assigned to container %3 (mirror set).", { "s1s", "b2", "b3", "", "", "", "" }, "Warning" },
{ 0xDF, 0x6F, 0x07, "NetRAID [ %1 ] Controller %2: A disk failure was detected for container %3 (mirror set).", { "s1s", "b2", "b3", "", "", "", "" }, "Error" },
{ 0xDF, 0x6F, 0x08, "NetRAID [ %1 ] Controller %2: A rebuild operation has started for container %3 (RAID-5 set)", { "s1s", "b2", "b3", "", "", "", "" }, "Informational" },
{ 0xDF, 0x6F, 0x09, "NetRAID [ %1 ] Controller %2: A disk failure was detected for container %3 (RAID-5 set).", { "s1s", "b2", "b3", "", "", "", "" }, "Error" },
{ 0xDF, 0x6F, 0x0A, "NetRAID [ %1 ] Controller %2: The rebuild operation did not start because there is no spare disk assigned to container %3 (RAID-5 set).", { "s1s", "b2", "b3", "", "", "", "" }, "Warning" },
{ 0xDF, 0x6F, 0x0B, "NetRAID [ %1 ] Controller %2: The rebuild operation did not start because there is insufficient space on the spare disk(s) assigned to container %3 (RAID-5 set).", { "s1s", "b2", "b3", "", "", "", "" }, "Error" },
{ 0xDF, 0x6F, 0x0C, "NetRAID [ %1 ] Controller %2: The backing container of a compact mode snapshot is 80% full on container %3.", { "s1s", "b2", "b3", "", "", "", "" }, "Warning" },
{ 0xDF, 0x6F, 0x0D, "NetRAID [ %1 ] Controller %2: The backing container of a compact mode snapshot is 100% full on container %3.", { "s1s", "b2", "b3", "", "", "", "" }, "Warning" },
{ 0xDF, 0x6F, 0x0E, "NetRAID [ %1 ] Controller %2: The rebuild operation has completed for container %3 (RAID-5 set).", { "s1s", "b2", "b3", "", "", "", "" }, "Informational" },
{ 0xDF, 0x6F, 0x0F, "NetRAID [ %1 ] Controller %2: Battery reconditioning is recommended.", { "s1s", "b2", "", "", "", "", "" }, "Informational" },
{ 0xDF, 0x70, 0x00, "NetRAID [ %1 ] Controller %2: A general failure was detected on storage enclosure %3.", { "s1s", "b2", "b3", "", "", "", "" }, "Warning" },
{ 0xDF, 0x70, 0x01, "NetRAID [ %1 ] Controller %2: A fan failure was detected on storage enclosure %3.", { "s1s", "b2", "b3", "", "", "", "" }, "Warning" },
{ 0xDF, 0x70, 0x02, "NetRAID [ %1 ] Controller %2: A power supply failure was detected on storage enclosure %3.", { "s1s", "b2", "b3", "", "", "", "" }, "Warning" },
{ 0xDF, 0x70, 0x03, "NetRAID [ %1 ] Controller %2: The temperature of storage enclosure %3 exceeds the threshold set by the manufacturer.", { "s1s", "b2", "b3", "", "", "", "" }, "Warning" },
{ 0xDF, 0x70, 0x04, "NetRAID [ %1 ] Controller %2: The temperature exceeds the user-specified threshold on storage enclosure %3.", { "s1s", "b2", "b3", "", "", "", "" }, "Informational" },
{ 0xDF, 0x70, 0x05, "NetRAID [ %1 ] Controller %2: The battery is not functioning (DEAD state).", { "s1s", "b2", "", "", "", "", "" }, "Error" },
{ 0xDF, 0x70, 0x06, "NetRAID [ %1 ] Controller %2: The battery charge is degrading (LOW state).", { "s1s", "b2", "", "", "", "", "" }, "Warning" },
{ 0xDF, 0x70, 0x07, "NetRAID [ %1 ] Controller %2: A failure prediction threshold was exceeded for channel %3, SCSI ID %4, LUN %5.", { "s1s", "b2m11110000", "b2m00001111", "b3m11110000", "b3m00001111", "", "" }, "Warning" },
{ 0xDF, 0x70, 0x08, "NetRAID [ %1 ] Controller %2: A warning was received from the following device: channel %3, SCSI ID %4, LUN %5.", { "s1s", "b2m11110000", "b2m00001111", "b3m11110000", "b3m00001111", "", "" }, "Warning" },
{ 0xDF, 0x70, 0x09, "NetRAID [ %1 ] Controller %2: The temperature for the following device exceeds the threshold set by the manufacturer: channel %3, SCSI ID %4, LUN %5.", { "s1s", "b2m11110000", "b2m00001111", "b3m11110000", "b3m00001111", "", "" }, "Warning" },
{ 0xDF, 0x70, 0x0A, "NetRAID [ %1 ] Controller %2: A degraded status was received from the following device: channel %3, SCSI ID %4, LUN %5.", { "s1s", "b2m11110000", "b2m00001111", "b3m11110000", "b3m00001111", "", "" }, "Warning" },
{ 0xDF, 0x70, 0x0B, "NetRAID [ %1 ] Controller %2: The drive letter assignment has changed for container %3.", { "s1s", "b2", "b3", "", "", "", "" }, "Informational" },
{ 0xDF, 0x70, 0x0C, "NetRAID [ %1 ] Controller %2: A spare disk assignment has changed.", { "s1s", "b2", "", "", "", "", "" }, "Informational" },
{ 0xDF, 0x70, 0x0F, "NetRAID [ %1 ] Controller %2: The file system has changed for container %3.", { "s1s", "b2", "b3", "", "", "", "" }, "Informational" },
{ 0xDF, 0x71, 0x00, "NetRAID [ %1 ] Controller %2: A disk failure was detected for channel %3, SCSI ID %4, LUN %5.", { "s1s", "b2m11110000", "b2m00001111", "b3m11110000", "b3m00001111", "", "" }, "Error" },
{ 0xDF, 0x71, 0x01, "NetRAID [ %1 ] Controller %2: Normal I/O operations have resumed on this controller.", { "s1s", "b2", "", "", "", "", "" }, "Informational" },
{ 0xDF, 0x71, 0x02, "NetRAID: The SNMP management interface has started.", { "", "", "", "", "", "", "" }, "Informational" },
{ 0xDF, 0x71, 0x03, "NetRAID [ %1 ] Controller %2: The battery charge is improving (LOW state).", { "s1s", "b2", "", "", "", "", "" }, "Informational" },
{ 0xDF, 0x71, 0x04, "NetRAID [ %1 ] Controller %2: The battery is adequately charged (GOOD state).", { "s1s", "b2", "", "", "", "", "" }, "Informational" },
{ 0xDF, 0x71, 0x05, "NetRAID [ %1 ] Controller %2: Normal I/O operations have been paused on this controller.", { "s1s", "b2", "", "", "", "", "" }, "Informational" },
{ 0xDF, 0x71, 0x06, "NetRAID [ %1 ] Controller %2: Container %3 was created.", { "s1s", "b2", "b3", "", "", "", "" }, "Informational" },
{ 0xDF, 0x71, 0x07, "NetRAID [ %1 ] Controller %2: Container %3 was deleted.", { "s1s", "b2", "b3", "", "", "", "" }, "Informational" },
{ 0xDF, 0x71, 0x08, "NetRAID [ %1 ] Controller %2: The failure reporting mechanism was tested for channel %3, SCSI ID %4, LUN %5.", { "s1s", "b2m11110000", "b2m00001111", "b3m11110000", "b3m00001111", "", "" }, "Informational" },
{ 0xDF, 0x71, 0x09, "NetRAID [ %1 ] Controller %2: A failure prediction property was changed for the following device: channel %3, SCSI ID %4, LUN %5.", { "s1s", "b2m11110000", "b2m00001111", "b3m11110000", "b3m00001111", "", "" }, "Informational" }

};
