/*-----------------------------------------------------------------------------

  Name:                   record.cmd
  Date Created:    12/27/92
                Copyright (c) IBM Corporation  1992, 1993
                          All Rights Reserved

  OS/2 REXX command file that uses MultiMedia REXX API's
  to record a wave file with the default settings of the audio
  card from the microphone in jack.

-----------------------------------------------------------------------------*/

address cmd      /* Send commands to OS/2 command processor.  */
signal on error   /* When commands fail, call "error" routine. */

trace off
/*trace ?r */


parse arg WaveFileName              /* Fetch command line parms */

if WaveFileName='' | WaveFileName='?' then
   do
     call Help
     exit 0
   end

/* Load the DLL, initialize MCI REXX support */
rc = RXFUNCADD('mciRxInit','MCIAPI','mciRxInit')
InitRC = mciRxInit()

/*
** Open the instance.
*/
MciCmd = 'open' WaveFileName 'alias rexxalias type waveaudio wait'
MacRC = SendString(''MciCmd'')       /* Put double single quotes around the command */
if MacRC <> 0 then signal ErrExit

MacRC = SendString("delete rexxalias from 0 wait")
if MacRC <> 0 then signal ErrExit

/*
** Exercise mciRxGetDeviceID function
*/
DeviceID = mciRxGetDeviceID(""rexxalias"")

/*
** Get the connector.
*/
MacRC = SendString("connection rexxalias query type wave stream alias rexxmic wait")
if MacRC <> 0 then signal ErrExit

/*
** Set the monitor attribute to off.
*/
MacRC = SendString("set rexxmic monitor off wait")
if MacRC <> 0 then signal ErrExit

/*
** Get the microphone connection.
*/
MacRC = SendString("connector rexxmic enable type microphone wait")
if MacRC <> 0 then signal ErrExit

/*
** Start the record operation.
*/
MacRC = SendString("record rexxalias")
if MacRC <> 0 then signal ErrExit
/*
** Notify users that recording is in progress.
*/
say 'Record operation is now in progress.'
say '<Press Enter to stop recording.>'

/*
** Wait for a key to be pressed:
 */
   pull trash

/*
** Stop recording
*/
MacRC = SendString("stop rexxalias wait")
if MacRC <> 0 then signal ErrExit

/*
** Save the file
*/
MacRC = SendString("save rexxalias wait")
if MacRC <> 0 then signal ErrExit

/*
** Close the instance
*/
MacRC = SendString("close rexxalias wait")
if MacRC <> 0 then signal ErrExit

/*
** Exit, return code = 0.
*/
exit 0

/*   --- SendString --
** Call DLL function.  Pass the command to process and the
** name of a REXX variable that will recieve textual return
** information.
*/
SendString:
   arg CmndTxt
   /* Last two parameters are reserved, must be set to 0           */
   /* Future use of last two parms are for notify window handle    */
   /* and userparm.                                                 */
   MacRC = mciRxSendString(CmndTxt, 'RetSt', '0', '0')
   if MacRC<>0 then
      do
      ErrRC = MacRC
      say 'MciCmd=' CmndTxt
      say 'Err:mciRxSendString RC=' ErrRC RetSt
      MacRC = mciRxGetErrorString(ErrRC, 'ErrStVar')
      say 'mciRxGetErrorString('ErrRC') =' ErrStVar
      MacRC = ErrRC /* return the error rc */
      end
   return MacRC


/*  -- help --
** Display help text
*/
Help:
   say
   say 'This command file records a wave file using the MultiMedia'
   say 'REXX string interface.'
   say
   say 'record filename'
   say
   return

/*  --- ErrExit --
** Common routine for error clean up/program exit.
** Gets called when commands to DLL fail.
*/
ErrExit:
   MacRC = mciRxExit()   /* Tell the DLL we're going away        */
   exit 1;               /* exit, tell caller things went poorly */


/*   ---- error --
** Routine gets control when any command to the external
** environment (usually OS/2) returns a non-zero RC.
** This routine does not get called when the macapi.dll
** returns non-zero as it is a function provider rather
** than a command environment.
*/
error:
   ErrRC = rc
   say 'Error' ErrRC 'at line' sigl ', sourceline:' sourceline(sigl)
   MacRC = mciRxExit()       /* Tell the DLL we're going away */
   exit ErrRC                /* exit, tell caller things went poorly */
