//----------------------------------------------------------------------------
// Ultimedia Mail/2 Lite Configuration File
// ===================================
//
// Many features of UltiMail are user configurable. All features which are
// specific for a given UltiMail client are collected in this profile. This
// file can be edited with any regular editor. Most conveniently it is however
// accessed through the settings notebooks in UltiMail itself.
//
// Comments (like this one) are according to C++ conventions preceeded by a
// double forward slash '//'. The double forward slash and anything after it
// on the given line is then ignored by UltiMail.
// Note: comments are not preserved when the configuration file is changed
//       through the settings notebooks from within UltiMail.
// Note: changes made directly in this file do not take effect until UltiMail
//       is logged off and on again with this profile. Most changes made
//       through the settings notebooks however take effect immediately.
//----------------------------------------------------------------------------
:SESSION DLL           = 'CSESLOCL'                             
         Name          = 'Local Mail'                           
         PipeClass     = 'PIPELOCL'                             
         Load          = 'automatic'                            
         RetryCount    = '3'                                    
         RetryInterval = '5000'                                 
         Color         = 'blue'                                 
         .                                                      
:PROFILE provider      = 'ADVANTIS'                             
         file          = 'C:\TCPIP\ETC\TCPOS2.INI'                                   
         .                                                      
//--- User Defaults/Setup ----------------------------------------------------  
:LETTER       address       = 'short'                            
              open          = 'first'                            
              create        = 'Text/plain'                       
              separator     = '//--- forwarded letter -------------------------------------------------------'
              annotation    = '> '                               
              sigplacement  = 'before'                           
              useseparator  = 'yes'                              
              useannotation = 'yes'                              
              viewinwindow  = 'yes'                              
              beeponnewmail = 'yes'                              
              notifysendok  = 'yes'                                             
              signature     = '//----------------------------------------------------------------------------// This is an example signature.// You can change the signature in the Letter 1// settings page. See Settings on Letter Menu.'
              .                                                  
//--- Object Handlers -------------------------------------------------------   
:OBJHANDLER Type        = Text                                   
            SubType     = enriched                               
            ViewType    = SOM       // EXE, SOM                  
            ViewModule  = OBJEPM                                 
            ViewData    = Buffer    // File, Buffer              
            Preload     = Yes                                    
            .                                                    
:OBJHANDLER Type        = Text                                   
            SubType     = *                                      
            ViewType    = SOM       // EXE, SOM                  
            ViewModule  = OBJMLE    // OBJEPM or OBJMLE          
            ViewData    = Buffer    // File, Buffer              
            Preload     = Yes                                    
            .                                                    
:OBJHANDLER Type        = Image                                  
            SubType     = *                                      
            ViewType    = SOM       // EXE, SOM                  
            ViewModule  = OBJIMG                                 
            ViewData    = File      // File, Buffer              
            Preload     = No                                     
            .                                                    
:OBJHANDLER Type        = Audio                                  
            SubType     = X-midi                                
            ViewType    = EXE       // EXE, SOM                  
            ViewModule  = MPPM.EXE                               
            ViewData    = File      // File, Buffer              
            Preload     = No                                     
            .                                                    
:OBJHANDLER Type        = Audio                                  
            SubType     = *                                      
            ViewType    = EXE       // EXE, SOM                  
            ViewModule  = WEPM.EXE                               
            .                                                    
:OBJHANDLER Type        = Message                                
            SubType     = external-body                          
            ViewType    = SOM       // EXE, SOM                  
            ViewModule  = OBJEXT                                 
            ViewData    = File      // File, Buffer              
            Preload     = No                                     
            .                                                    
:OBJHANDLER Type        = Video                                  
            SubType     = *                                      
            ViewType    = EXE       // EXE, SOM                  
            ViewModule  = MPPM.EXE                               
            ViewData    = File      // File, Buffer              
            Preload     = No                                     
            .                                                    
:OBJHANDLER Type        = *                                      
            SubType     = *                                      
            ViewType    = SOM       // EXE, SOM                  
            ViewModule  = OBJHNDLR                               
            ViewData    = File      // File, Buffer              
            Preload     = No                                     
            .                                                    
//--- end of file ------------------------------------------------------------  
