/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import jrockit.io.FileNativeIO;
import jrockit.io.NativeIOOutputStream;
import jrockit.nio.ch.FileChannelImpl;

public class FileOutputStream
extends OutputStream {
    private NativeIOOutputStream nos;
    private FileChannel channel = null;
    private boolean append = false;

    public FileOutputStream(String string) throws FileNotFoundException {
        this(string, false);
    }

    public FileOutputStream(String string, boolean bl) throws FileNotFoundException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(string);
        }
        this.append = bl;
        FileNativeIO fileNativeIO = FileNativeIO.getInstance();
        int n = bl ? 4 | 8 | 0x80 : 4 | 0x20;
        this.nos = new NativeIOOutputStream(fileNativeIO, FileNativeIO.open(string, n));
    }

    public FileOutputStream(File file) throws FileNotFoundException {
        this(file.getPath());
    }

    public FileOutputStream(File file, boolean bl) throws FileNotFoundException {
        this(file.getPath(), bl);
    }

    public FileOutputStream(FileDescriptor fileDescriptor) {
        SecurityManager securityManager = System.getSecurityManager();
        if (fileDescriptor == null) {
            throw new NullPointerException();
        }
        if (securityManager != null) {
            securityManager.checkWrite(fileDescriptor);
        }
        this.nos = new NativeIOOutputStream(FileNativeIO.getInstance(), fileDescriptor);
    }

    public void write(int n) throws IOException {
        this.nos.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.nos.write(byArray, n, n2);
    }

    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
        }
        this.channel = null;
        this.nos.close();
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.nos != null) {
            return this.nos.getFD();
        }
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel getChannel() {
        FileOutputStream fileOutputStream = this;
        synchronized (fileOutputStream) {
            if (this.channel == null) {
                this.channel = FileChannelImpl.open(this.nos.getFD(), false, true, this, this.append);
            }
            return this.channel;
        }
    }

    protected void finalize() throws IOException {
        if (this.nos != null) {
            FileDescriptor fileDescriptor = this.nos.getFD();
            if (fileDescriptor == FileDescriptor.out || fileDescriptor == FileDescriptor.err) {
                this.flush();
            } else {
                this.close();
            }
        }
    }
}

