/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.IOException;
import java.io.Win32FileSystem;
import java.util.ArrayList;
import java.util.Iterator;
import jrockit.vm.Access;

abstract class FileSystem {
    private static FileSystem fs = new Win32FileSystem();
    public static final int BA_EXISTS = 1;
    public static final int BA_REGULAR = 2;
    public static final int BA_DIRECTORY = 4;
    public static final int BA_HIDDEN = 8;
    private static ArrayList doeList = null;
    private static Object doeLock = new Object();
    static boolean useCanonCaches = true;
    static boolean useCanonPrefixCache = true;

    FileSystem() {
    }

    public static FileSystem getFileSystem() {
        return fs;
    }

    public abstract char getSeparator();

    public abstract char getPathSeparator();

    public abstract String normalize(String var1);

    public abstract int prefixLength(String var1);

    public abstract String resolve(String var1, String var2);

    public abstract String getDefaultParent();

    public abstract String fromURIPath(String var1);

    public abstract boolean isAbsolute(File var1);

    public abstract String resolve(File var1);

    public abstract String canonicalize(String var1) throws IOException;

    public abstract int getBooleanAttributes(File var1);

    public abstract boolean checkAccess(File var1, boolean var2);

    public abstract long getLastModifiedTime(File var1);

    public abstract long getLength(File var1);

    public abstract boolean createFileExclusively(String var1) throws IOException;

    public abstract boolean delete(File var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean deleteOnExit(File file) {
        Object object = doeLock;
        synchronized (object) {
            if (doeList == null) {
                doeList = new ArrayList();
                Access.lang().shutdownAdd(new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = doeLock;
                        synchronized (object) {
                            Iterator iterator = doeList.iterator();
                            while (iterator.hasNext()) {
                                FileSystem.this.delete((File)iterator.next());
                            }
                            doeList.clear();
                        }
                    }
                });
            }
            doeList.add(file);
        }
        return true;
    }

    public abstract String[] list(File var1);

    public abstract boolean createDirectory(File var1);

    public abstract boolean rename(File var1, File var2);

    public abstract boolean setLastModifiedTime(File var1, long var2);

    public abstract boolean setReadOnly(File var1);

    public abstract File[] listRoots();

    public abstract int compare(File var1, File var2);

    public abstract int hashCode(File var1);

    private static boolean getBooleanProperty(String string, boolean bl) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        return string2.equalsIgnoreCase("true");
    }

    static {
        useCanonCaches = FileSystem.getBooleanProperty("sun.io.useCanonCaches", useCanonCaches);
        useCanonPrefixCache = FileSystem.getBooleanProperty("sun.io.useCanonPrefixCache", useCanonPrefixCache);
    }
}

