/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import jrockit.io.FileNativeIO;
import jrockit.nio.ch.FileChannelImpl;

public class RandomAccessFile
implements DataOutput,
DataInput,
Closeable {
    private FileDescriptor fd;
    private FileChannel channel = null;
    private boolean rw;
    private static final FileNativeIO nd = FileNativeIO.getInstance();
    private byte[] buffer;
    private static final int O_RDONLY = 1;
    private static final int O_RDWR = 2;
    private static final int O_SYNC = 4;
    private static final int O_DSYNC = 8;

    private byte[] getBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[32];
        }
        return this.buffer;
    }

    public RandomAccessFile(String string, String string2) throws FileNotFoundException {
        int n = 0;
        if (string2.equals("rw")) {
            this.rw = true;
            n = 8;
        } else if (string2.equals("rwd") || string2.equals("rws")) {
            this.rw = true;
            n = 264;
        } else if (string2.equals("r")) {
            this.rw = false;
            n = 17;
        } else {
            throw new IllegalArgumentException("mode must be r or rw(d|s)");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
            if (this.rw) {
                securityManager.checkWrite(string);
            }
        }
        this.fd = FileNativeIO.open(string, n);
    }

    public RandomAccessFile(File file, String string) throws FileNotFoundException {
        this(file.getPath(), string);
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileChannel getChannel() {
        RandomAccessFile randomAccessFile = this;
        synchronized (randomAccessFile) {
            if (this.channel == null) {
                this.channel = FileChannelImpl.open(this.fd, true, this.rw, this);
            }
            return this.channel;
        }
    }

    private int read(int n, byte[] byArray, int n2) throws IOException {
        return nd.read(this.fd, byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        byte[] byArray;
        if (this.fd == null) {
            throw new IOException();
        }
        byte[] byArray2 = byArray = this.getBuffer();
        synchronized (byArray) {
            if (this.read(0, byArray, 1) < 1) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return -1;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return byArray[0] & 0xFF;
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.fd == null) {
            throw new IOException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        return this.read(n, byArray, n2);
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        do {
            if ((n3 = this.read(byArray, n + n4, n2 - n4)) >= 0) continue;
            throw new EOFException();
        } while ((n4 += n3) < n2);
    }

    public int skipBytes(int n) throws IOException {
        if (n < 0) {
            return 0;
        }
        return (int)nd.position(this.fd, n, true);
    }

    private void write(int n, byte[] byArray, int n2) throws IOException {
        nd.write(this.fd, byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n) throws IOException {
        if (this.fd == null) {
            throw new IOException();
        }
        byte[] byArray = this.getBuffer();
        byArray[0] = (byte)n;
        byte[] byArray2 = byArray;
        synchronized (byArray) {
            this.write(0, byArray, 1);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.fd == null) {
            throw new IOException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.write(n, byArray, n2);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public long getFilePointer() throws IOException {
        if (this.fd == null) {
            throw new IOException();
        }
        return nd.position(this.fd, -1L, false);
    }

    public void seek(long l) throws IOException {
        if (this.fd == null) {
            throw new IOException();
        }
        if (l < 0L) {
            throw new IOException("negative pos in seek");
        }
        nd.position(this.fd, l, false);
    }

    public long length() throws IOException {
        if (this.fd == null) {
            throw new IOException();
        }
        return nd.size(this.fd);
    }

    public void setLength(long l) throws IOException {
        long l2 = this.getFilePointer();
        nd.truncate(this.fd, l);
        if (l2 < l) {
            this.seek(l2);
        }
    }

    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.fd == null) {
            throw new IOException("null fd");
        }
        nd.close(this.fd);
    }

    public final boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public final byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public final int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public final short readShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + (n << 0));
    }

    public final int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + (n << 0);
    }

    public final char readChar() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + (n << 0));
    }

    public final int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }

    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final String readLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        boolean bl = false;
        block4: while (!bl) {
            n = this.read();
            switch (n) {
                case -1: 
                case 10: {
                    bl = true;
                    continue block4;
                }
                case 13: {
                    bl = true;
                    long l = this.getFilePointer();
                    if (this.read() == 10) continue block4;
                    this.seek(l);
                    continue block4;
                }
            }
            stringBuffer.append((char)n);
        }
        if (n == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public final void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    public final void writeByte(int n) throws IOException {
        this.write(n);
    }

    public final void writeShort(int n) throws IOException {
        byte[] byArray = this.getBuffer();
        byArray[0] = (byte)(n >>> 8 & 0xFF);
        byArray[1] = (byte)(n >>> 0 & 0xFF);
        this.write(byArray, 0, 2);
    }

    public final void writeChar(int n) throws IOException {
        byte[] byArray = this.getBuffer();
        byArray[0] = (byte)(n >>> 8 & 0xFF);
        byArray[1] = (byte)(n >>> 0 & 0xFF);
        this.write(byArray, 0, 2);
    }

    public final void writeInt(int n) throws IOException {
        byte[] byArray = this.getBuffer();
        byArray[0] = (byte)(n >>> 24 & 0xFF);
        byArray[1] = (byte)(n >>> 16 & 0xFF);
        byArray[2] = (byte)(n >>> 8 & 0xFF);
        byArray[3] = (byte)(n >>> 0 & 0xFF);
        this.write(byArray, 0, 4);
    }

    public final void writeLong(long l) throws IOException {
        byte[] byArray = this.getBuffer();
        byArray[0] = (byte)(l >>> 56 & 0xFFL);
        byArray[1] = (byte)(l >>> 48 & 0xFFL);
        byArray[2] = (byte)(l >>> 40 & 0xFFL);
        byArray[3] = (byte)(l >>> 32 & 0xFFL);
        byArray[4] = (byte)(l >>> 24 & 0xFFL);
        byArray[5] = (byte)(l >>> 16 & 0xFFL);
        byArray[6] = (byte)(l >>> 8 & 0xFFL);
        byArray[7] = (byte)(l >>> 0 & 0xFFL);
        this.write(byArray, 0, 8);
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeBytes(String string) throws IOException {
        int n = string.length();
        byte[] byArray = this.getBuffer();
        int n2 = 0;
        while (n > 0) {
            if (n <= byArray.length) {
                string.getBytes(n2, n2 + n, byArray, 0);
                this.write(byArray, 0, n);
                break;
            }
            string.getBytes(n2, n2 + byArray.length, byArray, 0);
            this.write(byArray);
            n -= byArray.length;
            n2 += byArray.length;
        }
    }

    public final void writeChars(String string) throws IOException {
        byte[] byArray = this.getBuffer();
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            byArray[n2++] = (byte)(c >>> 8);
            byArray[n2++] = (byte)(c >>> 0);
            if (n2 != byArray.length) continue;
            this.write(byArray);
            n2 = 0;
        }
        this.write(byArray, 0, n2);
    }

    public final void writeUTF(String string) throws IOException {
        DataOutputStream.writeUTF(string, this);
    }
}

