/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import jrockit.vm.NativeFluff;
import sun.io.ByteToCharConverter;
import sun.io.CharToByteConverter;
import sun.io.Converters;
import sun.nio.cs.HistoricallyNamedCharset;

class StringCoding {
    private static ThreadLocal decoder = new ThreadLocal();
    private static ThreadLocal encoder = new ThreadLocal();
    private static boolean warnUnsupportedCharset = true;
    private static StringEncoder defaultEncoder;
    private static StringDecoder defaultDecoder;
    private static final boolean USE_QUICK_CODERS = true;
    private static HashMap quickAliases;

    private StringCoding() {
    }

    private static Object deref(ThreadLocal threadLocal) {
        SoftReference softReference = (SoftReference)threadLocal.get();
        if (softReference == null) {
            return null;
        }
        return softReference.get();
    }

    private static void set(ThreadLocal threadLocal, Object object) {
        threadLocal.set(new SoftReference<Object>(object));
    }

    private static byte[] trim(byte[] byArray, int n) {
        if (n == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    private static char[] trim(char[] cArray, int n) {
        if (n == cArray.length) {
            return cArray;
        }
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, n);
        return cArray2;
    }

    private static int scale(int n, float f) {
        return (int)((double)n * (double)f);
    }

    private static Charset lookupCharset(String string) {
        if (string.equalsIgnoreCase("PCK")) {
            return null;
        }
        if (Charset.isSupported(string)) {
            try {
                return Charset.forName(string);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw new Error(unsupportedCharsetException);
            }
        }
        return null;
    }

    private static void warnUnsupportedCharset(String string) {
        if (warnUnsupportedCharset) {
            NativeFluff.printString("WARNING: Default charset " + string + " not supported, using ISO-8859-1 instead\n");
            warnUnsupportedCharset = false;
        }
    }

    static char[] decode(String string, byte[] byArray, int n, int n2) throws UnsupportedEncodingException {
        String string2;
        StringDecoder stringDecoder = (StringDecoder)StringCoding.deref(decoder);
        String string3 = string2 = string == null ? "ISO-8859-1" : string;
        if (stringDecoder == null || !string2.equals(stringDecoder.requestedCharsetName()) && !string2.equals(stringDecoder.charsetName())) {
            stringDecoder = StringCoding.getDecoder(string2, false);
            StringCoding.set(decoder, stringDecoder);
        }
        return stringDecoder.decode(byArray, n, n2);
    }

    static char[] decode(byte[] byArray, int n, int n2) {
        return defaultDecoder.decode(byArray, n, n2);
    }

    static byte[] encode(String string, char[] cArray, int n, int n2) throws UnsupportedEncodingException {
        String string2;
        StringEncoder stringEncoder = (StringEncoder)StringCoding.deref(encoder);
        String string3 = string2 = string == null ? "ISO-8859-1" : string;
        if (stringEncoder == null || !string2.equals(stringEncoder.requestedCharsetName()) && !string2.equals(stringEncoder.charsetName())) {
            stringEncoder = StringCoding.getEncoder(string2, false);
            StringCoding.set(encoder, stringEncoder);
        }
        return stringEncoder.encode(cArray, n, n2);
    }

    static byte[] encode(char[] cArray, int n, int n2) {
        return defaultEncoder.encode(cArray, n, n2);
    }

    private static void ensureFallback() {
        if (defaultDecoder == null) {
            defaultDecoder = new ISO8859_1SD("ISO-8859-1");
        }
        if (defaultEncoder == null) {
            defaultEncoder = new ISO8859_1SE("ISO-8859-1");
        }
    }

    private static void makeDefaultCoders(String string) {
        StringEncoder stringEncoder;
        StringDecoder stringDecoder;
        if (string == null) {
            string = Converters.getDefaultEncodingName();
        }
        StringCoding.ensureFallback();
        try {
            stringDecoder = StringCoding.getDecoder(string, true);
            stringEncoder = StringCoding.getEncoder(string, true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            StringCoding.warnUnsupportedCharset(string);
            Converters.resetDefaultEncodingName();
            StringCoding.makeDefaultCoders("ISO-8859-1");
            return;
        }
        if (stringEncoder == null || stringDecoder == null) {
            throw new InternalError(string + " not available");
        }
        defaultEncoder = stringEncoder.isThreadSafe() ? stringEncoder : new DefaultEncoder(string);
        defaultDecoder = stringDecoder.isThreadSafe() ? stringDecoder : new DefaultDecoder(string);
        System.addPropertyAction("file.encoding", new Runnable(){

            public void run() {
                StringCoding.makeDefaultCoders(null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getAlias(String string) {
        if (quickAliases != null) return (String)quickAliases.get(string);
        Class<StringCoding> clazz = StringCoding.class;
        synchronized (StringCoding.class) {
            if (quickAliases != null) return (String)quickAliases.get(string);
            quickAliases = new HashMap();
            quickAliases.put("MS1252", "Cp1252");
            quickAliases.put("windows-1252", "Cp1252");
            quickAliases.put("iso-ir-100", "8859_1");
            quickAliases.put("ISO_8859-1", "8859_1");
            quickAliases.put("latin1", "8859_1");
            quickAliases.put("l1", "8859_1");
            quickAliases.put("IBM819", "8859_1");
            quickAliases.put("cp819", "8859_1");
            quickAliases.put("csISOLatin1", "8859_1");
            quickAliases.put("819", "8859_1");
            quickAliases.put("IBM-819", "8859_1");
            quickAliases.put("ISO8859_1", "8859_1");
            quickAliases.put("ISO_8859-1:1987", "8859_1");
            quickAliases.put("ISO_8859_1", "8859_1");
            quickAliases.put("8859_1", "8859_1");
            quickAliases.put("ISO8859-1", "8859_1");
            quickAliases.put("ISO-8859-1", "8859_1");
            quickAliases.put("iso-ir-6", "US_ASCII");
            quickAliases.put("ANSI_X3.4-1986", "US_ASCII");
            quickAliases.put("ISO_646.irv:1991", "US_ASCII");
            quickAliases.put("ASCII", "US_ASCII");
            quickAliases.put("ISO646-US", "US_ASCII");
            quickAliases.put("us", "US_ASCII");
            quickAliases.put("IBM367", "US_ASCII");
            quickAliases.put("cp367", "US_ASCII");
            quickAliases.put("csASCII", "US_ASCII");
            quickAliases.put("US-ASCII", "US_ASCII");
            quickAliases.put("646", "US_ASCII");
            quickAliases.put("iso_646.irv:1983", "US_ASCII");
            quickAliases.put("ANSI_X3.4-1968", "US_ASCII");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (String)quickAliases.get(string);
        }
    }

    private static StringEncoder getEncoder(String string, boolean bl) throws UnsupportedEncodingException {
        Object object;
        if (bl) {
            if (string.equals("Cp1252")) {
                return new MS1252SE(string);
            }
            if (string.equals("8859_1")) {
                return new ISO8859_1SE(string);
            }
            if (string.equals("US_ASCII")) {
                return new USASCIISE(string);
            }
            object = StringCoding.getAlias(string);
            if (object != null) {
                return StringCoding.getEncoder((String)object, bl);
            }
        }
        try {
            object = StringCoding.lookupCharset(string);
            if (object != null) {
                return new CharsetSE((Charset)object, string);
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            // empty catch block
        }
        return new ConverterSE(CharToByteConverter.getConverter((String)string), string);
    }

    private static StringDecoder getDecoder(String string, boolean bl) throws UnsupportedEncodingException {
        Object object;
        if (bl) {
            if (string.equals("Cp1252")) {
                return new MS1252SD(string);
            }
            if (string.equals("8859_1")) {
                return new ISO8859_1SD(string);
            }
            if (string.equals("US_ASCII")) {
                return new USASCIISD(string);
            }
            object = StringCoding.getAlias(string);
            if (object != null) {
                return StringCoding.getDecoder((String)object, bl);
            }
        }
        try {
            object = StringCoding.lookupCharset(string);
            if (object != null) {
                return new CharsetSD((Charset)object, string);
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            // empty catch block
        }
        return new ConverterSD(ByteToCharConverter.getConverter((String)string), string);
    }

    static {
        StringCoding.makeDefaultCoders(null);
    }

    private static class USASCIISD
    extends StringDecoder {
        String enc;

        protected USASCIISD(String string) {
            super(string);
        }

        String charsetName() {
            return "US_ASCII";
        }

        char[] decode(byte[] byArray, int n, int n2) {
            char[] cArray = new char[n2];
            int n3 = n + n2;
            int n4 = 0;
            for (int i = n; i < n3; ++i) {
                byte by = byArray[i];
                cArray[n4] = by >= 0 ? (int)by : 65533;
                ++n4;
            }
            return cArray;
        }

        boolean isThreadSafe() {
            return true;
        }
    }

    private static class USASCIISE
    extends StringEncoder {
        protected USASCIISE(String string) {
            super(string);
        }

        String charsetName() {
            return "US_ASCII";
        }

        byte[] encode(char[] cArray, int n, int n2) {
            int n3 = n + n2;
            byte[] byArray = new byte[n2];
            int n4 = 0;
            int n5 = n;
            while (n5 < n3) {
                char c = cArray[n5];
                if (c < '\u0080') {
                    byArray[n4] = (byte)c;
                } else if (c < '\ufffe') {
                    byArray[n4] = 63;
                } else {
                    byArray[n4] = 63;
                    return StringCoding.trim(byArray, n4 + 1);
                }
                ++n5;
                ++n4;
            }
            return byArray;
        }

        boolean isThreadSafe() {
            return true;
        }
    }

    private static class ISO8859_1SD
    extends StringDecoder {
        String enc;

        protected ISO8859_1SD(String string) {
            super(string);
        }

        String charsetName() {
            return "ISO8859_1";
        }

        char[] decode(byte[] byArray, int n, int n2) {
            char[] cArray = new char[n2];
            int n3 = n + n2;
            int n4 = 0;
            for (int i = n; i < n3; ++i) {
                cArray[n4] = (char)(byArray[i] & 0xFF);
                ++n4;
            }
            return cArray;
        }

        boolean isThreadSafe() {
            return true;
        }
    }

    private static class ISO8859_1SE
    extends StringEncoder {
        protected ISO8859_1SE(String string) {
            super(string);
        }

        String charsetName() {
            return "ISO8859_1";
        }

        byte[] encode(char[] cArray, int n, int n2) {
            int n3 = n + n2;
            byte[] byArray = new byte[n2];
            int n4 = 0;
            int n5 = n;
            while (n5 < n3) {
                char c = cArray[n5];
                if (c < '\u0100') {
                    byArray[n4] = (byte)c;
                } else if (c < '\ufffe') {
                    byArray[n4] = 63;
                } else {
                    byArray[n4] = 63;
                    return StringCoding.trim(byArray, n4 + 1);
                }
                ++n5;
                ++n4;
            }
            return byArray;
        }

        boolean isThreadSafe() {
            return true;
        }
    }

    private static class MS1252SD
    extends StringDecoder {
        String enc;
        private static final char[] cp1252c1chars = "\u20ac\ufffd\u201a\u0192\u201e\u2026\u2020\u2021\u02c6\u2030\u0160\u2039\u0152\ufffd\u017d\ufffd\ufffd\u2018\u2019\u201c\u201d\u2022\u2013\u2014\u02dc\u2122\u0161\u203a\u0153\ufffd\u017e\u0178".getValue();

        protected MS1252SD(String string) {
            super(string);
        }

        String charsetName() {
            return "Cp1252";
        }

        char[] decode(byte[] byArray, int n, int n2) {
            char[] cArray = new char[n2];
            int n3 = n2 + n;
            int n4 = 0;
            for (int i = n; i < n3; ++i) {
                char c = (char)(byArray[i] & 0xFF);
                cArray[n4] = c >= '\u0080' && c <= '\u009f' ? cp1252c1chars[c - 128] : c;
                ++n4;
            }
            return cArray;
        }

        boolean isThreadSafe() {
            return true;
        }
    }

    private static class MS1252SE
    extends StringEncoder {
        protected MS1252SE(String string) {
            super(string);
        }

        String charsetName() {
            return "Cp1252";
        }

        byte[] encode(char[] cArray, int n, int n2) {
            int n3 = n + n2;
            byte[] byArray = new byte[n2];
            int n4 = 0;
            int n5 = n;
            while (n5 < n3) {
                char c = cArray[n5];
                if (c < '\u0080' || c > '\u009f' && c < '\u0100') {
                    byArray[n4] = (byte)c;
                } else {
                    switch (c) {
                        case '\u20ac': {
                            byArray[n4] = -128;
                            break;
                        }
                        case '\u201a': {
                            byArray[n4] = -126;
                            break;
                        }
                        case '\u0192': {
                            byArray[n4] = -125;
                            break;
                        }
                        case '\u201e': {
                            byArray[n4] = -124;
                            break;
                        }
                        case '\u2026': {
                            byArray[n4] = -123;
                            break;
                        }
                        case '\u2020': {
                            byArray[n4] = -122;
                            break;
                        }
                        case '\u2021': {
                            byArray[n4] = -121;
                            break;
                        }
                        case '\u02c6': {
                            byArray[n4] = -120;
                            break;
                        }
                        case '\u2030': {
                            byArray[n4] = -119;
                            break;
                        }
                        case '\u0160': {
                            byArray[n4] = -118;
                            break;
                        }
                        case '\u2039': {
                            byArray[n4] = -117;
                            break;
                        }
                        case '\u0152': {
                            byArray[n4] = -116;
                            break;
                        }
                        case '\u017d': {
                            byArray[n4] = -114;
                            break;
                        }
                        case '\u2018': {
                            byArray[n4] = -111;
                            break;
                        }
                        case '\u2019': {
                            byArray[n4] = -110;
                            break;
                        }
                        case '\u201c': {
                            byArray[n4] = -109;
                            break;
                        }
                        case '\u201d': {
                            byArray[n4] = -108;
                            break;
                        }
                        case '\u2022': {
                            byArray[n4] = -107;
                            break;
                        }
                        case '\u2013': {
                            byArray[n4] = -106;
                            break;
                        }
                        case '\u2014': {
                            byArray[n4] = -105;
                            break;
                        }
                        case '\u02dc': {
                            byArray[n4] = -104;
                            break;
                        }
                        case '\u2122': {
                            byArray[n4] = -103;
                            break;
                        }
                        case '\u0161': {
                            byArray[n4] = -102;
                            break;
                        }
                        case '\u203a': {
                            byArray[n4] = -101;
                            break;
                        }
                        case '\u0153': {
                            byArray[n4] = -100;
                            break;
                        }
                        case '\u017e': {
                            byArray[n4] = -98;
                            break;
                        }
                        case '\u0178': {
                            byArray[n4] = -97;
                            break;
                        }
                        case '\ufffe': 
                        case '\uffff': {
                            byArray[n4] = 63;
                            return StringCoding.trim(byArray, n4 + 1);
                        }
                        default: {
                            byArray[n4] = 63;
                        }
                    }
                }
                ++n5;
                ++n4;
            }
            return byArray;
        }

        boolean isThreadSafe() {
            return true;
        }
    }

    private static class DefaultDecoder
    extends StringDecoder {
        String enc;

        protected DefaultDecoder(String string) {
            super(string);
            this.enc = string;
        }

        String charsetName() {
            return null;
        }

        char[] decode(byte[] byArray, int n, int n2) {
            try {
                return StringCoding.decode(this.enc, byArray, n, n2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                StringCoding.makeDefaultCoders(null);
                return StringCoding.decode(byArray, n, n2);
            }
        }
    }

    private static class DefaultEncoder
    extends StringEncoder {
        String enc;

        protected DefaultEncoder(String string) {
            super(string);
            this.enc = string;
        }

        String charsetName() {
            return null;
        }

        byte[] encode(char[] cArray, int n, int n2) {
            try {
                return StringCoding.encode(this.enc, cArray, n, n2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                StringCoding.makeDefaultCoders(null);
                return StringCoding.encode(cArray, n, n2);
            }
        }
    }

    private static class CharsetSE
    extends StringEncoder {
        private Charset cs;
        private CharsetEncoder ce;

        private CharsetSE(Charset charset, String string) {
            super(string);
            this.cs = charset;
            this.ce = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }

        String charsetName() {
            if (this.cs instanceof HistoricallyNamedCharset) {
                return ((HistoricallyNamedCharset)((Object)this.cs)).historicalName();
            }
            return this.cs.name();
        }

        byte[] encode(char[] cArray, int n, int n2) {
            int n3 = StringCoding.scale(n2, this.ce.maxBytesPerChar());
            byte[] byArray = new byte[n3];
            if (n2 == 0) {
                return byArray;
            }
            this.ce.reset();
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2);
            try {
                CoderResult coderResult = this.ce.encode(charBuffer, byteBuffer, true);
                if (!coderResult.isUnderflow()) {
                    coderResult.throwException();
                }
                if (!(coderResult = this.ce.flush(byteBuffer)).isUnderflow()) {
                    coderResult.throwException();
                }
            }
            catch (CharacterCodingException characterCodingException) {
                throw new Error(characterCodingException);
            }
            return StringCoding.trim(byArray, byteBuffer.position());
        }
    }

    private static class ConverterSE
    extends StringEncoder {
        private CharToByteConverter ctb;

        private ConverterSE(CharToByteConverter charToByteConverter, String string) {
            super(string);
            this.ctb = charToByteConverter;
        }

        String charsetName() {
            return this.ctb.getCharacterEncoding();
        }

        byte[] encode(char[] cArray, int n, int n2) {
            int n3 = StringCoding.scale(n2, this.ctb.getMaxBytesPerChar());
            byte[] byArray = new byte[n3];
            if (n2 == 0) {
                return byArray;
            }
            this.ctb.reset();
            try {
                int n4 = this.ctb.convertAny(cArray, n, n + n2, byArray, 0, n3);
            }
            catch (CharConversionException charConversionException) {
                throw new Error("Converter malfunction: " + this.ctb.getClass().getName(), charConversionException);
            }
            return StringCoding.trim(byArray, n4 += this.ctb.flushAny(byArray, this.ctb.nextByteIndex(), n3));
        }
    }

    private static class CharsetSD
    extends StringDecoder {
        private final Charset cs;
        private final CharsetDecoder cd;

        private CharsetSD(Charset charset, String string) {
            super(string);
            this.cs = charset;
            this.cd = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }

        String charsetName() {
            if (this.cs instanceof HistoricallyNamedCharset) {
                return ((HistoricallyNamedCharset)((Object)this.cs)).historicalName();
            }
            return this.cs.name();
        }

        char[] decode(byte[] byArray, int n, int n2) {
            int n3 = StringCoding.scale(n2, this.cd.maxCharsPerByte());
            char[] cArray = new char[n3];
            if (n2 == 0) {
                return cArray;
            }
            this.cd.reset();
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
            CharBuffer charBuffer = CharBuffer.wrap(cArray);
            try {
                CoderResult coderResult = this.cd.decode(byteBuffer, charBuffer, true);
                if (!coderResult.isUnderflow()) {
                    coderResult.throwException();
                }
                if (!(coderResult = this.cd.flush(charBuffer)).isUnderflow()) {
                    coderResult.throwException();
                }
            }
            catch (CharacterCodingException characterCodingException) {
                throw new Error(characterCodingException);
            }
            return StringCoding.trim(cArray, charBuffer.position());
        }
    }

    private static class ConverterSD
    extends StringDecoder {
        private ByteToCharConverter btc;

        private ConverterSD(ByteToCharConverter byteToCharConverter, String string) {
            super(string);
            this.btc = byteToCharConverter;
        }

        String charsetName() {
            return this.btc.getCharacterEncoding();
        }

        char[] decode(byte[] byArray, int n, int n2) {
            int n3 = StringCoding.scale(n2, this.btc.getMaxCharsPerByte());
            char[] cArray = new char[n3];
            if (n2 == 0) {
                return cArray;
            }
            this.btc.reset();
            int n4 = 0;
            try {
                n4 = this.btc.convert(byArray, n, n + n2, cArray, 0, n3);
                n4 += this.btc.flush(cArray, this.btc.nextCharIndex(), n3);
            }
            catch (CharConversionException charConversionException) {
                n4 = this.btc.nextCharIndex();
            }
            return StringCoding.trim(cArray, n4);
        }
    }

    private static abstract class StringDecoder
    extends Codec {
        protected StringDecoder(String string) {
            super(string);
        }

        abstract char[] decode(byte[] var1, int var2, int var3);
    }

    private static abstract class StringEncoder
    extends Codec {
        protected StringEncoder(String string) {
            super(string);
        }

        abstract byte[] encode(char[] var1, int var2, int var3);
    }

    private static abstract class Codec {
        private final String rcn;

        protected Codec(String string) {
            this.rcn = string;
        }

        final String requestedCharsetName() {
            return this.rcn;
        }

        abstract String charsetName();

        boolean isThreadSafe() {
            return false;
        }
    }
}

