/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.reflect.Field;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import jrockit.annotations.NativeField;
import jrockit.vm.Interruptible;
import jrockit.vm.Locks;
import jrockit.vm.Memory;
import jrockit.vm.Reflect;
import jrockit.vm.Threads;
import sun.misc.SoftCache;
import sun.security.util.SecurityConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Thread
implements Runnable {
    @NativeField(type="struct VMThread *")
    private int vmThread;
    private Object cwObj;
    private Object sleepHelpObj;
    private Object blockObj;
    private Thread waitNext;
    private Thread lockNext;
    private boolean interrupted = false;
    private boolean simulateStart = false;
    private boolean allowStop = true;
    private Object blockThreadStop;
    private AccessControlContext accessControlContext;
    private char[] name;
    private int priority;
    private boolean started;
    private boolean daemon = false;
    private Runnable target;
    private ThreadGroup group;
    private ClassLoader contextClassLoader;
    private AccessControlContext inheritedAccessControlContext;
    private static int threadInitNumber;
    ThreadLocal.ThreadLocalMap threadLocals = null;
    ThreadLocal.ThreadLocalMap inheritableThreadLocals = null;
    private long stackSize;
    private long tid;
    private static long threadSeqNumber;
    private int threadStatus = 0;
    private volatile Interruptible blocker;
    private Object blockerLock = new Object();
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;
    private static final StackTraceElement[] EMPTY_STACK_TRACE;
    private static final RuntimePermission SUBCLASS_IMPLEMENTATION_PERMISSION;
    private static final SoftCache subclassAudits;
    private volatile UncaughtExceptionHandler uncaughtExceptionHandler;
    private static volatile UncaughtExceptionHandler defaultUncaughtExceptionHandler;
    private static final int parkOffset;
    private Object parkObject = null;
    private boolean parkIsUnparked = false;

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    private static synchronized long nextThreadID() {
        return ++threadSeqNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void blockedOn(Interruptible interruptible) {
        Object object = this.blockerLock;
        synchronized (object) {
            this.blocker = interruptible;
        }
    }

    public static native Thread currentThread();

    public static native void yield();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sleep(long l) throws InterruptedException {
        if (l == 0L) {
            Thread.yield();
        } else {
            Thread thread = Thread.currentThread();
            if (thread.sleepHelpObj == null) {
                thread.sleepHelpObj = new Object();
            }
            Object object = thread.sleepHelpObj;
            synchronized (object) {
                Threads.setThreadStatus(thread, 225);
                thread.sleepHelpObj.wait(l);
            }
        }
    }

    public static void sleep(long l, int n) throws InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (n < 0 || n > 999999) {
            throw new IllegalArgumentException("nanosecond timeout value out of range");
        }
        if (n >= 500000 || n != 0 && l == 0L) {
            ++l;
        }
        Thread.sleep(l);
    }

    private void init(ThreadGroup threadGroup, Runnable runnable, String string, long l) {
        Thread thread = Thread.currentThread();
        SecurityManager securityManager = System.getSecurityManager();
        if (threadGroup == null) {
            if (securityManager != null) {
                threadGroup = securityManager.getThreadGroup();
            }
            if (threadGroup == null) {
                threadGroup = thread.getThreadGroup();
            }
        }
        threadGroup.checkAccess();
        if (securityManager != null && Thread.isCCLOverridden(this.getClass())) {
            securityManager.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        threadGroup.addUnstarted();
        this.group = threadGroup;
        this.daemon = thread.isDaemon();
        this.priority = thread.getPriority();
        this.name = string.toCharArray();
        this.contextClassLoader = securityManager == null || Thread.isCCLOverridden(thread.getClass()) ? thread.getContextClassLoader() : thread.contextClassLoader;
        this.inheritedAccessControlContext = AccessController.getContext();
        this.target = runnable;
        this.setPriority(this.priority);
        if (thread.inheritableThreadLocals != null) {
            this.inheritableThreadLocals = ThreadLocal.createInheritedMap(thread.inheritableThreadLocals);
        }
        this.stackSize = l;
        this.tid = Thread.nextThreadID();
    }

    public Thread() {
        this.init(null, null, "Thread-" + Thread.nextThreadNum(), 0L);
    }

    public Thread(Runnable runnable) {
        this.init(null, runnable, "Thread-" + Thread.nextThreadNum(), 0L);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable) {
        this.init(threadGroup, runnable, "Thread-" + Thread.nextThreadNum(), 0L);
    }

    public Thread(String string) {
        this.init(null, null, string, 0L);
    }

    public Thread(ThreadGroup threadGroup, String string) {
        this.init(threadGroup, null, string, 0L);
    }

    public Thread(Runnable runnable, String string) {
        this.init(null, runnable, string, 0L);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable, String string) {
        this.init(threadGroup, runnable, string, 0L);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable, String string, long l) {
        this.init(threadGroup, runnable, string, l);
    }

    public synchronized void start() {
        if (this.started) {
            throw new IllegalThreadStateException();
        }
        this.started = true;
        this.group.add(this);
        this.start0();
    }

    private native void start0();

    @Override
    public void run() {
        if (this.target != null) {
            this.target.run();
        }
    }

    private void exit() {
        if (this.group != null) {
            this.group.remove(this);
            this.group = null;
        }
        this.target = null;
        this.threadLocals = null;
        this.inheritableThreadLocals = null;
        this.inheritedAccessControlContext = null;
        this.blocker = null;
        this.uncaughtExceptionHandler = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void stop() {
        Thread thread = this;
        synchronized (thread) {
            if (!this.isAlive()) {
                return;
            }
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                this.checkAccess();
                if (this != Thread.currentThread()) {
                    securityManager.checkPermission(SecurityConstants.STOP_THREAD_PERMISSION);
                }
            }
            this.resume();
            this.stop0(new ThreadDeath());
        }
    }

    @Deprecated
    public final synchronized void stop(Throwable throwable) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            this.checkAccess();
            if (this != Thread.currentThread() || !(throwable instanceof ThreadDeath)) {
                securityManager.checkPermission(SecurityConstants.STOP_THREAD_PERMISSION);
            }
        }
        this.resume();
        this.stop0(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        if (this != Thread.currentThread()) {
            this.checkAccess();
        }
        Object object = this.blockerLock;
        synchronized (object) {
            Interruptible interruptible = this.blocker;
            if (interruptible != null) {
                this.interrupt0();
                interruptible.interrupt();
                return;
            }
        }
        this.interrupt0();
    }

    public static boolean interrupted() {
        return Thread.currentThread().isInterrupted(true);
    }

    public boolean isInterrupted() {
        return this.isInterrupted(false);
    }

    private boolean isInterrupted(boolean bl) {
        if (bl && this.interrupted) {
            this.interrupted = false;
            return true;
        }
        return this.interrupted;
    }

    @Deprecated
    public void destroy() {
        throw new NoSuchMethodError();
    }

    public final native boolean isAlive();

    @Deprecated
    public final void suspend() {
        this.checkAccess();
        this.suspend0();
    }

    @Deprecated
    public final void resume() {
        this.checkAccess();
        this.resume0();
    }

    public final void setPriority(int n) {
        this.checkAccess();
        if (n > 10 || n < 1) {
            throw new IllegalArgumentException();
        }
        if (n > this.group.getMaxPriority()) {
            n = this.group.getMaxPriority();
        }
        this.priority = n;
        this.setPriority0(this.priority);
    }

    public final int getPriority() {
        return this.priority;
    }

    public final void setName(String string) {
        this.checkAccess();
        this.name = string.toCharArray();
        this.setName0();
    }

    public final String getName() {
        return String.valueOf(this.name);
    }

    public final ThreadGroup getThreadGroup() {
        return this.group;
    }

    public static int activeCount() {
        return Thread.currentThread().getThreadGroup().activeCount();
    }

    public static int enumerate(Thread[] threadArray) {
        return Thread.currentThread().getThreadGroup().enumerate(threadArray);
    }

    @Deprecated
    public int countStackFrames() {
        if (!Threads.isThreadSuspended(this)) {
            throw new IllegalThreadStateException();
        }
        throw new NoSuchMethodError();
    }

    public final synchronized void join(long l) throws InterruptedException {
        long l2 = System.currentTimeMillis();
        long l3 = 0L;
        if (l < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (l == 0L) {
            while (this.isAlive()) {
                this.wait(0L);
            }
        } else {
            long l4;
            while (this.isAlive() && (l4 = l - l3) > 0L) {
                this.wait(l4);
                l3 = System.currentTimeMillis() - l2;
            }
        }
    }

    public final synchronized void join(long l, int n) throws InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (n < 0 || n > 999999) {
            throw new IllegalArgumentException("nanosecond timeout value out of range");
        }
        if (n >= 500000 || n != 0 && l == 0L) {
            ++l;
        }
        this.join(l);
    }

    public final void join() throws InterruptedException {
        this.join(0L);
    }

    public static void dumpStack() {
        new Exception("Stack trace").printStackTrace();
    }

    public final void setDaemon(boolean bl) {
        this.checkAccess();
        if (this.isAlive()) {
            throw new IllegalThreadStateException();
        }
        this.daemon = bl;
    }

    public final boolean isDaemon() {
        return this.daemon;
    }

    public final void checkAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkAccess(this);
        }
    }

    public String toString() {
        ThreadGroup threadGroup = this.getThreadGroup();
        if (threadGroup != null) {
            return "Thread[" + this.getName() + "," + this.getPriority() + "," + threadGroup.getName() + "]";
        }
        return "Thread[" + this.getName() + "," + this.getPriority() + "," + "" + "]";
    }

    public ClassLoader getContextClassLoader() {
        ClassLoader classLoader;
        if (this.contextClassLoader == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (classLoader = Reflect.getCallerClassLoader()) != null && classLoader != this.contextClassLoader && !this.contextClassLoader.isAncestor(classLoader)) {
            securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return this.contextClassLoader;
    }

    public void setContextClassLoader(ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("setContextClassLoader"));
        }
        this.contextClassLoader = classLoader;
    }

    public static boolean holdsLock(Object object) {
        return Locks.isCurrentThreadHoldingLock(object);
    }

    public StackTraceElement[] getStackTrace() {
        Thread[] threadArray;
        if (this != Thread.currentThread() && (threadArray = System.getSecurityManager()) != null) {
            threadArray.checkPermission(SecurityConstants.GET_STACK_TRACE_PERMISSION);
        }
        if (!this.isAlive()) {
            return EMPTY_STACK_TRACE;
        }
        threadArray = new Thread[]{this};
        StackTraceElement[][] stackTraceElementArray = Thread.dumpThreads(threadArray);
        return stackTraceElementArray[0];
    }

    public static Map<Thread, StackTraceElement[]> getAllStackTraces() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.GET_STACK_TRACE_PERMISSION);
            securityManager.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
        }
        Thread[] threadArray = Thread.getThreads();
        StackTraceElement[][] stackTraceElementArray = Thread.dumpThreads(threadArray);
        HashMap<Thread, StackTraceElement[]> hashMap = new HashMap<Thread, StackTraceElement[]>(threadArray.length);
        for (int i = 0; i < threadArray.length; ++i) {
            if (!threadArray[i].isAlive()) continue;
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray[i];
            if (stackTraceElementArray2 == null) {
                stackTraceElementArray2 = EMPTY_STACK_TRACE;
            }
            hashMap.put(threadArray[i], stackTraceElementArray2);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isCCLOverridden(Class clazz) {
        if (clazz == Thread.class) {
            return false;
        }
        Boolean bl = null;
        SoftCache softCache = subclassAudits;
        synchronized (softCache) {
            bl = (Boolean)subclassAudits.get((Object)clazz);
            if (bl == null) {
                bl = new Boolean(Thread.auditSubclass(clazz));
                subclassAudits.put((Object)clazz, (Object)bl);
            }
        }
        return bl;
    }

    private static boolean auditSubclass(final Class clazz) {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (Class clazz2 = clazz; clazz2 != Thread.class; clazz2 = clazz2.getSuperclass()) {
                    try {
                        clazz2.getDeclaredMethod("getContextClassLoader", new Class[0]);
                        return Boolean.TRUE;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        try {
                            Class[] classArray = new Class[]{ClassLoader.class};
                            clazz2.getDeclaredMethod("setContextClassLoader", classArray);
                            return Boolean.TRUE;
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {
                            continue;
                        }
                    }
                }
                return Boolean.FALSE;
            }
        });
        return bl;
    }

    private static native StackTraceElement[][] dumpThreads(Thread[] var0);

    private static native Thread[] getThreads();

    public long getId() {
        return this.tid;
    }

    public State getState() {
        return Threads.getEnumStateFromBitmapState(this.threadStatus);
    }

    public static void setDefaultUncaughtExceptionHandler(UncaughtExceptionHandler uncaughtExceptionHandler) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("setDefaultUncaughtExceptionHandler"));
        }
        defaultUncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    public static UncaughtExceptionHandler getDefaultUncaughtExceptionHandler() {
        return defaultUncaughtExceptionHandler;
    }

    public UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler != null ? this.uncaughtExceptionHandler : this.group;
    }

    public void setUncaughtExceptionHandler(UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.checkAccess();
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    private void dispatchUncaughtException(Throwable throwable) {
        this.getUncaughtExceptionHandler().uncaughtException(this, throwable);
    }

    private native void setPriority0(int var1);

    private native void stop0(Object var1);

    private native void suspend0();

    private native void resume0();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interrupt0() {
        int n;
        int n2;
        this.interrupted = true;
        Object object = this.cwObj;
        if (object != null) {
            Object object2 = object;
            synchronized (object2) {
                Locks.notifySpecific(object, this);
            }
        }
        if ((n2 = Threads.getVMThread(this)) != 0 && (n = Threads.getWaitingOnRawMonitor(n2)) != 0) {
            Locks.notifyRawMonitor(n2);
        }
    }

    private native void setName0();

    private static AccessControlContext getInheritedAccessControlContext() {
        return Thread.currentThread().inheritedAccessControlContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void whPark(boolean bl, long l) {
        Object object;
        Thread thread = Thread.currentThread();
        Object object2 = thread.parkObject;
        if (object2 == null && (object = Memory.cas((Object)thread, parkOffset, null, object2 = new Object())) != null) {
            object2 = object;
        }
        object = object2;
        synchronized (object) {
            if (thread.parkIsUnparked) {
                thread.parkIsUnparked = false;
            } else {
                try {
                    Threads.setThreadStatus(thread, 0x281 | (!bl && l == 0L ? 16 : 32));
                    if (bl) {
                        long l2 = l - System.currentTimeMillis();
                        if (l2 > 0L) {
                            object2.wait(l2);
                        }
                    } else if (l > 0L) {
                        long l3 = l / 1000000L;
                        int n = (int)(l % 1000000L);
                        object2.wait(l3, n);
                    } else if (l == 0L) {
                        object2.wait();
                    }
                    thread.parkIsUnparked = false;
                }
                catch (InterruptedException interruptedException) {
                    thread.interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void whUnpark(Thread thread) {
        Object object;
        Object object2 = thread.parkObject;
        if (object2 == null && (object = Memory.cas((Object)thread, parkOffset, null, object2 = new Object())) != null) {
            object2 = object;
        }
        object = object2;
        synchronized (object) {
            if (!thread.parkIsUnparked) {
                thread.parkIsUnparked = true;
                object2.notify();
            }
        }
    }

    static {
        EMPTY_STACK_TRACE = new StackTraceElement[0];
        SUBCLASS_IMPLEMENTATION_PERMISSION = new RuntimePermission("enableContextClassLoaderOverride");
        subclassAudits = new SoftCache(10);
        int n = 0;
        try {
            Field field = Thread.class.getDeclaredField("parkObject");
            n = Reflect.IField.getOffset(Reflect.IAccessibleObject.getID(field));
        }
        catch (Exception exception) {
            parkOffset = n;
            throw new Error(exception);
        }
        parkOffset = n;
    }

    public static interface UncaughtExceptionHandler {
        public void uncaughtException(Thread var1, Throwable var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NEW,
        RUNNABLE,
        BLOCKED,
        WAITING,
        TIMED_WAITING,
        TERMINATED;

    }
}

