/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.PrintStream;
import jrockit.vm.NativeFluff;

public class ThreadGroup
implements Thread.UncaughtExceptionHandler {
    ThreadGroup parent;
    String name;
    int maxPriority;
    boolean destroyed;
    boolean daemon;
    boolean vmAllowSuspension;
    int nUnstartedThreads = 0;
    int nthreads;
    Thread[] threads;
    int ngroups;
    ThreadGroup[] groups;

    ThreadGroup() {
        this.parent = null;
        this.name = "system";
        this.maxPriority = 10;
        this.destroyed = false;
        this.daemon = false;
        this.nthreads = 0;
        this.ngroups = 0;
    }

    public ThreadGroup(String string) {
        this(Thread.currentThread().getThreadGroup(), string);
    }

    public ThreadGroup(ThreadGroup threadGroup, String string) {
        if (threadGroup == null) {
            throw new NullPointerException();
        }
        threadGroup.checkAccess();
        this.name = string;
        this.maxPriority = threadGroup.maxPriority;
        this.daemon = threadGroup.daemon;
        this.vmAllowSuspension = threadGroup.vmAllowSuspension;
        this.parent = threadGroup;
        threadGroup.add(this);
    }

    public final String getName() {
        return this.name;
    }

    public final ThreadGroup getParent() {
        if (this.parent != null) {
            this.parent.checkAccess();
        }
        return this.parent;
    }

    public final int getMaxPriority() {
        return this.maxPriority;
    }

    public final boolean isDaemon() {
        return this.daemon;
    }

    public synchronized boolean isDestroyed() {
        return this.destroyed;
    }

    public final void setDaemon(boolean bl) {
        this.checkAccess();
        this.daemon = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMaxPriority(int n) {
        ThreadGroup[] threadGroupArray;
        int n2;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            if (n < 1) {
                this.maxPriority = 1;
            } else if (n < this.maxPriority) {
                this.maxPriority = n;
            }
            n2 = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n2];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n2);
            } else {
                threadGroupArray = null;
            }
        }
        for (int i = 0; i < n2; ++i) {
            threadGroupArray[i].setMaxPriority(n);
        }
    }

    public final boolean parentOf(ThreadGroup threadGroup) {
        while (threadGroup != null) {
            if (threadGroup == this) {
                return true;
            }
            threadGroup = threadGroup.parent;
        }
        return false;
    }

    public final void checkAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkAccess(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int activeCount() {
        ThreadGroup[] threadGroupArray;
        int n;
        int n2;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                return 0;
            }
            n2 = this.nthreads;
            n = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n);
            } else {
                threadGroupArray = null;
            }
        }
        for (int i = 0; i < n; ++i) {
            n2 += threadGroupArray[i].activeCount();
        }
        return n2;
    }

    public int enumerate(Thread[] threadArray) {
        this.checkAccess();
        return this.enumerate(threadArray, 0, true);
    }

    public int enumerate(Thread[] threadArray, boolean bl) {
        this.checkAccess();
        return this.enumerate(threadArray, 0, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int enumerate(Thread[] threadArray, int n, boolean bl) {
        int n2 = 0;
        ThreadGroup[] threadGroupArray = null;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                return 0;
            }
            int n3 = this.nthreads;
            if (n3 > threadArray.length - n) {
                n3 = threadArray.length - n;
            }
            for (int i = 0; i < n3; ++i) {
                if (!this.threads[i].isAlive()) continue;
                threadArray[n++] = this.threads[i];
            }
            if (bl) {
                n2 = this.ngroups;
                if (this.groups != null) {
                    threadGroupArray = new ThreadGroup[n2];
                    System.arraycopy(this.groups, 0, threadGroupArray, 0, n2);
                } else {
                    threadGroupArray = null;
                }
            }
        }
        if (bl) {
            for (int i = 0; i < n2; ++i) {
                n = threadGroupArray[i].enumerate(threadArray, n, true);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int activeGroupCount() {
        ThreadGroup[] threadGroupArray;
        int n;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                return 0;
            }
            n = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n);
            } else {
                threadGroupArray = null;
            }
        }
        int n2 = n;
        for (int i = 0; i < n; ++i) {
            n2 += threadGroupArray[i].activeGroupCount();
        }
        return n2;
    }

    public int enumerate(ThreadGroup[] threadGroupArray) {
        this.checkAccess();
        return this.enumerate(threadGroupArray, 0, true);
    }

    public int enumerate(ThreadGroup[] threadGroupArray, boolean bl) {
        this.checkAccess();
        return this.enumerate(threadGroupArray, 0, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int enumerate(ThreadGroup[] threadGroupArray, int n, boolean bl) {
        int n2 = 0;
        ThreadGroup[] threadGroupArray2 = null;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                return 0;
            }
            int n3 = this.ngroups;
            if (n3 > threadGroupArray.length - n) {
                n3 = threadGroupArray.length - n;
            }
            if (n3 > 0) {
                System.arraycopy(this.groups, 0, threadGroupArray, n, n3);
                n += n3;
            }
            if (bl) {
                n2 = this.ngroups;
                if (this.groups != null) {
                    threadGroupArray2 = new ThreadGroup[n2];
                    System.arraycopy(this.groups, 0, threadGroupArray2, 0, n2);
                } else {
                    threadGroupArray2 = null;
                }
            }
        }
        if (bl) {
            for (int i = 0; i < n2; ++i) {
                n = threadGroupArray2[i].enumerate(threadGroupArray, n, true);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void stop() {
        ThreadGroup[] threadGroupArray;
        int n;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            for (int i = 0; i < this.nthreads; ++i) {
                this.threads[i].stop();
            }
            n = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n);
            } else {
                threadGroupArray = null;
            }
        }
        for (int i = 0; i < n; ++i) {
            threadGroupArray[i].stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void interrupt() {
        ThreadGroup[] threadGroupArray;
        int n;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            for (int i = 0; i < this.nthreads; ++i) {
                this.threads[i].interrupt();
            }
            n = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n);
            } else {
                threadGroupArray = null;
            }
        }
        for (int i = 0; i < n; ++i) {
            threadGroupArray[i].interrupt();
        }
    }

    @Deprecated
    public final void suspend() {
        if (this.stopOrSuspend(true)) {
            Thread.currentThread().suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stopOrSuspend(boolean bl) {
        int n;
        boolean bl2 = false;
        Thread thread = Thread.currentThread();
        ThreadGroup[] threadGroupArray = null;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            for (int i = 0; i < this.nthreads; ++i) {
                if (this.threads[i] == thread) {
                    bl2 = true;
                    continue;
                }
                if (bl) {
                    this.threads[i].suspend();
                    continue;
                }
                this.threads[i].stop();
            }
            n = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n);
            }
        }
        for (int i = 0; i < n; ++i) {
            bl2 = threadGroupArray[i].stopOrSuspend(bl) || bl2;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void resume() {
        ThreadGroup[] threadGroupArray;
        int n;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            for (int i = 0; i < this.nthreads; ++i) {
                this.threads[i].resume();
            }
            n = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n);
            } else {
                threadGroupArray = null;
            }
        }
        for (int i = 0; i < n; ++i) {
            threadGroupArray[i].resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        ThreadGroup[] threadGroupArray;
        int n;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            if (this.destroyed || this.nthreads > 0) {
                throw new IllegalThreadStateException();
            }
            n = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n);
            } else {
                threadGroupArray = null;
            }
            if (this.parent != null) {
                this.destroyed = true;
                this.ngroups = 0;
                this.groups = null;
                this.nthreads = 0;
                this.threads = null;
            }
        }
        for (int i = 0; i < n; ++i) {
            threadGroupArray[i].destroy();
        }
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void add(ThreadGroup threadGroup) {
        ThreadGroup threadGroup2 = this;
        synchronized (threadGroup2) {
            if (this.destroyed) {
                throw new IllegalThreadStateException();
            }
            if (this.groups == null) {
                this.groups = new ThreadGroup[4];
            } else if (this.ngroups == this.groups.length) {
                ThreadGroup[] threadGroupArray = new ThreadGroup[this.ngroups * 2];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, this.ngroups);
                this.groups = threadGroupArray;
            }
            this.groups[this.ngroups] = threadGroup;
            ++this.ngroups;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(ThreadGroup threadGroup) {
        ThreadGroup threadGroup2 = this;
        synchronized (threadGroup2) {
            if (this.destroyed) {
                return;
            }
            for (int i = 0; i < this.ngroups; ++i) {
                if (this.groups[i] != threadGroup) continue;
                --this.ngroups;
                System.arraycopy(this.groups, i + 1, this.groups, i, this.ngroups - i);
                this.groups[this.ngroups] = null;
                break;
            }
            if (this.nthreads == 0) {
                this.notifyAll();
            }
            if (this.daemon && this.nthreads == 0 && this.nUnstartedThreads == 0 && this.ngroups == 0) {
                this.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addUnstarted() {
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                throw new IllegalThreadStateException();
            }
            ++this.nUnstartedThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(Thread thread) {
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                throw new IllegalThreadStateException();
            }
            if (this.threads == null) {
                this.threads = new Thread[4];
            } else if (this.nthreads == this.threads.length) {
                Thread[] threadArray = new Thread[this.nthreads * 2];
                System.arraycopy(this.threads, 0, threadArray, 0, this.nthreads);
                this.threads = threadArray;
            }
            this.threads[this.nthreads] = thread;
            ++this.nthreads;
            --this.nUnstartedThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(Thread thread) {
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                return;
            }
            for (int i = 0; i < this.nthreads; ++i) {
                if (this.threads[i] != thread) continue;
                System.arraycopy(this.threads, i + 1, this.threads, i, --this.nthreads - i);
                this.threads[this.nthreads] = null;
                break;
            }
            if (this.nthreads == 0) {
                this.notifyAll();
            }
            if (this.daemon && this.nthreads == 0 && this.nUnstartedThreads == 0 && this.ngroups == 0) {
                this.destroy();
            }
        }
    }

    public void list() {
        this.list(System.out, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void list(PrintStream printStream, int n) {
        ThreadGroup[] threadGroupArray;
        int n2;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                printStream.print(" ");
            }
            printStream.println(this);
            n += 4;
            for (n3 = 0; n3 < this.nthreads; ++n3) {
                for (int i = 0; i < n; ++i) {
                    printStream.print(" ");
                }
                printStream.println(this.threads[n3]);
            }
            n2 = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n2];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n2);
            } else {
                threadGroupArray = null;
            }
        }
        for (int i = 0; i < n2; ++i) {
            threadGroupArray[i].list(printStream, n);
        }
    }

    public void uncaughtException(Thread thread, Throwable throwable) {
        if (this.parent != null) {
            this.parent.uncaughtException(thread, throwable);
        } else {
            if (throwable instanceof OutOfMemoryError) {
                NativeFluff.printString("OutOfMemoryError\n-------end of stacktrace\n");
                return;
            }
            Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
            if (uncaughtExceptionHandler != null) {
                uncaughtExceptionHandler.uncaughtException(thread, throwable);
            } else if (!(throwable instanceof ThreadDeath)) {
                throwable.printStackTrace(System.err);
            }
        }
    }

    @Deprecated
    public boolean allowThreadSuspension(boolean bl) {
        this.vmAllowSuspension = bl;
        if (!bl) {
            // empty if block
        }
        return true;
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this.getName() + ",maxpri=" + this.maxPriority + "]";
    }
}

