/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import jrockit.annotations.ThrowCycle;

public class Throwable
implements Serializable {
    private static final long serialVersionUID = -3042686055658047285L;
    private static final int MAX_FRAMES = 32;
    private transient int[] backtrace;
    private transient int noBackTrace;
    String detailMessage;
    Throwable cause = this;
    private StackTraceElement[] stackTrace;

    public Throwable() {
        this.fillInStackTrace1();
    }

    @ThrowCycle
    public Throwable(String string) {
        this.fillInStackTrace1();
        this.detailMessage = string;
    }

    @ThrowCycle
    public Throwable(String string, Throwable throwable) {
        this.fillInStackTrace1();
        this.detailMessage = string;
        this.cause = throwable;
    }

    @ThrowCycle
    public Throwable(Throwable throwable) {
        this.fillInStackTrace1();
        this.detailMessage = throwable == null ? null : throwable.toString();
        this.cause = throwable;
    }

    public String getMessage() {
        return this.detailMessage;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public Throwable getCause() {
        return this.cause == this ? null : this.cause;
    }

    public synchronized Throwable initCause(Throwable throwable) {
        if (this.cause != this) {
            throw new IllegalStateException("Can't overwrite cause");
        }
        if (throwable == this) {
            throw new IllegalArgumentException("Self-causation not permitted");
        }
        this.cause = throwable;
        return this;
    }

    public String toString() {
        String string = this.getClass().getName();
        String string2 = this.getLocalizedMessage();
        return string2 != null ? string + ": " + string2 : string;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            printStream.println(this);
            StackTraceElement[] stackTraceElementArray = this.getOurStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                if (stackTraceElementArray[i] == null) {
                    printStream.println("\tat <unloaded method>");
                    continue;
                }
                printStream.println("\tat " + stackTraceElementArray[i]);
            }
            Throwable throwable = this.getCause();
            if (throwable != null) {
                throwable.printStackTraceAsCause(printStream, stackTraceElementArray);
            }
        }
    }

    private void printStackTraceAsCause(PrintStream printStream, StackTraceElement[] stackTraceElementArray) {
        Throwable throwable;
        StackTraceElement[] stackTraceElementArray2 = this.getOurStackTrace();
        int n = stackTraceElementArray2.length - 1;
        for (int i = stackTraceElementArray.length - 1; n >= 0 && i >= 0 && stackTraceElementArray2[n].equals(stackTraceElementArray[i]); --n, --i) {
        }
        int n2 = stackTraceElementArray2.length - 1 - n;
        printStream.println("Caused by: " + this);
        for (int i = 0; i <= n; ++i) {
            printStream.println("\tat " + stackTraceElementArray2[i]);
        }
        if (n2 != 0) {
            printStream.println("\t... " + n2 + " more");
        }
        if ((throwable = this.getCause()) != null) {
            throwable.printStackTraceAsCause(printStream, stackTraceElementArray2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter printWriter) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            printWriter.println(this);
            StackTraceElement[] stackTraceElementArray = this.getOurStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                printWriter.println("\tat " + stackTraceElementArray[i]);
            }
            Throwable throwable = this.getCause();
            if (throwable != null) {
                throwable.printStackTraceAsCause(printWriter, stackTraceElementArray);
            }
        }
    }

    private void printStackTraceAsCause(PrintWriter printWriter, StackTraceElement[] stackTraceElementArray) {
        Throwable throwable;
        StackTraceElement[] stackTraceElementArray2 = this.getOurStackTrace();
        int n = stackTraceElementArray2.length - 1;
        for (int i = stackTraceElementArray.length - 1; n >= 0 && i >= 0 && stackTraceElementArray2[n].equals(stackTraceElementArray[i]); --n, --i) {
        }
        int n2 = stackTraceElementArray2.length - 1 - n;
        printWriter.println("Caused by: " + this);
        for (int i = 0; i <= n; ++i) {
            printWriter.println("\tat " + stackTraceElementArray2[i]);
        }
        if (n2 != 0) {
            printWriter.println("\t... " + n2 + " more");
        }
        if ((throwable = this.getCause()) != null) {
            throwable.printStackTraceAsCause(printWriter, stackTraceElementArray2);
        }
    }

    @ThrowCycle
    public synchronized Throwable fillInStackTrace() {
        this.fillInStackTrace1();
        return this;
    }

    @ThrowCycle
    private void fillInStackTrace1() {
        if (this.noBackTrace == 0) {
            this.backtrace = new int[64];
            Throwable.fillInStackTrace0(this.backtrace);
        }
    }

    @ThrowCycle
    private static native void fillInStackTrace0(int[] var0);

    public StackTraceElement[] getStackTrace() {
        return (StackTraceElement[])this.getOurStackTrace().clone();
    }

    private synchronized StackTraceElement[] getOurStackTrace() {
        if (this.stackTrace == null) {
            this.stackTrace = this.getOurStackTrace0();
        }
        return this.stackTrace;
    }

    private native StackTraceElement[] getOurStackTrace0();

    public void setStackTrace(StackTraceElement[] stackTraceElementArray) {
        StackTraceElement[] stackTraceElementArray2 = (StackTraceElement[])stackTraceElementArray.clone();
        for (int i = 0; i < stackTraceElementArray2.length; ++i) {
            if (stackTraceElementArray2[i] != null) continue;
            throw new NullPointerException("stackTrace[" + i + "]");
        }
        this.stackTrace = stackTraceElementArray2;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.getOurStackTrace();
        objectOutputStream.defaultWriteObject();
    }
}

