/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.AbstractSocketImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;

class PlainSocketImpl
extends AbstractSocketImpl {
    private boolean closing = false;

    PlainSocketImpl() {
    }

    PlainSocketImpl(FileDescriptor fileDescriptor) {
        super(fileDescriptor);
    }

    protected synchronized void create(boolean bl) throws IOException {
        if (this.serverSocket != null) {
            super.create(bl, true);
        } else {
            super.create(bl);
        }
        if (this.socket != null) {
            this.socket.setCreated();
        }
        if (this.serverSocket != null) {
            this.serverSocket.setCreated();
        }
    }

    protected void connect(SocketAddress socketAddress, int n) throws IOException {
        if (socketAddress == null || !(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("unsupported address type");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (inetSocketAddress.isUnresolved()) {
            throw new UnknownHostException(inetSocketAddress.getHostName());
        }
        this.port = inetSocketAddress.getPort();
        this.address = inetSocketAddress.getAddress();
        try {
            this.connectToAddress(this.address, this.port, n);
            return;
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    void connectToAddress(InetAddress inetAddress, int n, int n2) throws IOException {
        if (inetAddress.isAnyLocalAddress()) {
            this.doConnect(InetAddress.getLocalHost(), n, n2);
        } else {
            this.doConnect(inetAddress, n, n2);
        }
    }

    void doConnect(InetAddress inetAddress, int n, int n2) throws IOException {
        super.doConnect(inetAddress, n, n2);
        if (this.socket != null) {
            this.socket.setBound();
            this.socket.setConnected();
        }
    }

    protected synchronized void bind(InetAddress inetAddress, int n) throws IOException {
        super.bind(inetAddress, n);
        if (this.socket != null) {
            this.socket.setBound();
        }
        if (this.serverSocket != null) {
            this.serverSocket.setBound();
        }
    }

    protected boolean supportsUrgentData() {
        return true;
    }

    protected void sendUrgentData(int n) throws IOException {
        if (this.isClosedOrPending()) {
            throw new IOException("Socket Closed");
        }
        nd.sendUrgentData(this.fd, n);
    }

    protected void implClose() throws IOException {
        if (!this.closing) {
            this.closing = true;
            if (this.socket != null) {
                if (!this.socket.isClosed()) {
                    this.socket.close();
                }
            } else {
                this.close();
            }
            this.closing = false;
        }
    }
}

