/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteBufferAsCharBufferRB;
import java.nio.ByteBufferAsCharBufferRL;
import java.nio.ByteBufferAsDoubleBufferRB;
import java.nio.ByteBufferAsDoubleBufferRL;
import java.nio.ByteBufferAsFloatBufferRB;
import java.nio.ByteBufferAsFloatBufferRL;
import java.nio.ByteBufferAsIntBufferRB;
import java.nio.ByteBufferAsIntBufferRL;
import java.nio.ByteBufferAsLongBufferRB;
import java.nio.ByteBufferAsLongBufferRL;
import java.nio.ByteBufferAsShortBufferRB;
import java.nio.ByteBufferAsShortBufferRL;
import java.nio.CharBuffer;
import java.nio.DirectByteBuffer;
import java.nio.DirectCharBufferRS;
import java.nio.DirectCharBufferRU;
import java.nio.DirectDoubleBufferRS;
import java.nio.DirectDoubleBufferRU;
import java.nio.DirectFloatBufferRS;
import java.nio.DirectFloatBufferRU;
import java.nio.DirectIntBufferRS;
import java.nio.DirectIntBufferRU;
import java.nio.DirectLongBufferRS;
import java.nio.DirectLongBufferRU;
import java.nio.DirectShortBufferRS;
import java.nio.DirectShortBufferRU;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;
import jrockit.io.IOMemory;
import jrockit.nio.ch.DirectBuffer;
import jrockit.nio.ch.FileChannelImpl;
import jrockit.vm.Memory;

class DirectByteBufferR
extends DirectByteBuffer
implements DirectBuffer,
IOMemory {
    public int acquire() {
        return this.address() + this.position();
    }

    public void release(int n) {
        if (n > 0) {
            this.position(this.position() + n);
        }
    }

    DirectByteBufferR(int n) {
        super(n);
    }

    DirectByteBufferR(int n, int n2, int n3, boolean bl) {
        super(n, n2, n3, bl);
    }

    DirectByteBufferR(DirectBuffer directBuffer, int n, int n2, int n3, int n4, int n5) {
        super(directBuffer, n, n2, n3, n4, n5);
    }

    public ByteBuffer slice() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n << 0;
        assert (n4 >= 0);
        return new DirectByteBufferR(this, -1, 0, n3, n3, n4);
    }

    public ByteBuffer duplicate() {
        return new DirectByteBufferR(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public ByteBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    public ByteBuffer put(byte by) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer put(int n, byte by) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer put(ByteBuffer byteBuffer) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    public boolean isDirect() {
        return true;
    }

    public boolean isReadOnly() {
        return true;
    }

    byte _get(int n) {
        return Memory.getByte(this.address + n);
    }

    void _put(int n, byte by) {
        throw new ReadOnlyBufferException();
    }

    protected void finalize() {
        if (this.allocated) {
            this.free();
        } else if (this.isAMappedBuffer && this.viewedBuffer == null) {
            FileChannelImpl.unmap(this);
            this.isAMappedBuffer = false;
        }
    }

    synchronized void free() {
        if (this.allocated) {
            Memory.freeMemory(this.address);
            Memory.unreserveDirectMemory(this.capacity());
            this.allocated = false;
        }
    }

    private ByteBuffer _putLong(int n, long l) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putLong(long l) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putLong(int n, long l) {
        throw new ReadOnlyBufferException();
    }

    public LongBuffer asLongBuffer() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n3 >> 3;
        if (!unaligned && (this.address + n) % 8 != 0) {
            return this.bigEndian ? new ByteBufferAsLongBufferRB(this, -1, 0, n4, n4, n) : new ByteBufferAsLongBufferRL(this, -1, 0, n4, n4, n);
        }
        return this.nativeByteOrder ? new DirectLongBufferRU(this, -1, 0, n4, n4, n) : new DirectLongBufferRS(this, -1, 0, n4, n4, n);
    }

    private ByteBuffer _putInt(int n, int n2) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putInt(int n) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putInt(int n, int n2) {
        throw new ReadOnlyBufferException();
    }

    public IntBuffer asIntBuffer() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n3 >> 2;
        if (!unaligned && (this.address + n) % 4 != 0) {
            return this.bigEndian ? new ByteBufferAsIntBufferRB(this, -1, 0, n4, n4, n) : new ByteBufferAsIntBufferRL(this, -1, 0, n4, n4, n);
        }
        return this.nativeByteOrder ? new DirectIntBufferRU(this, -1, 0, n4, n4, n) : new DirectIntBufferRS(this, -1, 0, n4, n4, n);
    }

    private ByteBuffer _putShort(int n, short s) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putShort(short s) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putShort(int n, short s) {
        throw new ReadOnlyBufferException();
    }

    public ShortBuffer asShortBuffer() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n3 >> 1;
        if (!unaligned && (this.address + n) % 2 != 0) {
            return this.bigEndian ? new ByteBufferAsShortBufferRB(this, -1, 0, n4, n4, n) : new ByteBufferAsShortBufferRL(this, -1, 0, n4, n4, n);
        }
        return this.nativeByteOrder ? new DirectShortBufferRU(this, -1, 0, n4, n4, n) : new DirectShortBufferRS(this, -1, 0, n4, n4, n);
    }

    private ByteBuffer _putChar(int n, char c) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putChar(char c) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putChar(int n, char c) {
        throw new ReadOnlyBufferException();
    }

    public CharBuffer asCharBuffer() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n3 >> 1;
        if (!unaligned && (this.address + n) % 2 != 0) {
            return this.bigEndian ? new ByteBufferAsCharBufferRB(this, -1, 0, n4, n4, n) : new ByteBufferAsCharBufferRL(this, -1, 0, n4, n4, n);
        }
        return this.nativeByteOrder ? new DirectCharBufferRU(this, -1, 0, n4, n4, n) : new DirectCharBufferRS(this, -1, 0, n4, n4, n);
    }

    private ByteBuffer _putDouble(int n, double d) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putDouble(double d) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putDouble(int n, double d) {
        throw new ReadOnlyBufferException();
    }

    public DoubleBuffer asDoubleBuffer() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n3 >> 3;
        if (!unaligned && (this.address + n) % 8 != 0) {
            return this.bigEndian ? new ByteBufferAsDoubleBufferRB(this, -1, 0, n4, n4, n) : new ByteBufferAsDoubleBufferRL(this, -1, 0, n4, n4, n);
        }
        return this.nativeByteOrder ? new DirectDoubleBufferRU(this, -1, 0, n4, n4, n) : new DirectDoubleBufferRS(this, -1, 0, n4, n4, n);
    }

    private ByteBuffer _putFloat(int n, float f) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putFloat(float f) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putFloat(int n, float f) {
        throw new ReadOnlyBufferException();
    }

    public FloatBuffer asFloatBuffer() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n3 >> 2;
        if (!unaligned && (this.address + n) % 4 != 0) {
            return this.bigEndian ? new ByteBufferAsFloatBufferRB(this, -1, 0, n4, n4, n) : new ByteBufferAsFloatBufferRL(this, -1, 0, n4, n4, n);
        }
        return this.nativeByteOrder ? new DirectFloatBufferRU(this, -1, 0, n4, n4, n) : new DirectFloatBufferRS(this, -1, 0, n4, n4, n);
    }
}

