/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DirectByteBuffer;
import java.nio.DirectIntBufferRU;
import java.nio.IntBuffer;
import jrockit.io.IOMemory;
import jrockit.nio.ch.DirectBuffer;
import jrockit.vm.Memory;
import jrockit.vm.Threads;

class DirectIntBufferU
extends IntBuffer
implements DirectBuffer,
IOMemory {
    protected static final boolean unaligned = Bits.unaligned();
    protected boolean allocated;
    protected Object viewedBuffer = null;

    public int acquire() {
        return this.address() + this.position();
    }

    public void release(int n) {
        if (n > 0) {
            this.position(this.position() + n);
        }
    }

    public Object viewedBuffer() {
        return this.viewedBuffer;
    }

    DirectIntBufferU(DirectByteBuffer directByteBuffer) {
        super(-1, 0, directByteBuffer.remaining() >> 2, directByteBuffer.remaining() >> 2);
        int n = this.capacity();
        this.limit(n);
        int n2 = this.position();
        assert (n2 <= n);
        this.address = directByteBuffer.address() + n2;
        this.allocated = false;
        this.viewedBuffer = directByteBuffer;
    }

    DirectIntBufferU(DirectBuffer directBuffer, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4);
        this.address = directBuffer.address() + n5;
        this.allocated = false;
        this.viewedBuffer = directBuffer;
    }

    public IntBuffer slice() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n << 2;
        assert (n4 >= 0);
        return new DirectIntBufferU(this, -1, 0, n3, n3, n4);
    }

    public IntBuffer duplicate() {
        return new DirectIntBufferU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public IntBuffer asReadOnlyBuffer() {
        return new DirectIntBufferRU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public int address() {
        return this.address;
    }

    private int ix(int n) {
        return this.address + (n << 2);
    }

    public int get() {
        return Memory.getInt(this.ix(this.nextGetIndex()));
    }

    public int get(int n) {
        return Memory.getInt(this.ix(this.checkIndex(n)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntBuffer get(int[] nArray, int n, int n2) {
        int n3 = n2 << 2;
        int n4 = nArray.length << 2;
        ByteOrder byteOrder = this.order();
        if (byteOrder != Bits.byteOrder() || n3 > 128) {
            int n5;
            DirectIntBufferU.checkBounds(n, n2, nArray.length);
            int n6 = this.position();
            int n7 = this.limit();
            assert (n6 <= n7);
            int n8 = n5 = n6 <= n7 ? n7 - n6 : 0;
            if (n2 > n5) {
                throw new BufferUnderflowException();
            }
            if (byteOrder != Bits.byteOrder()) {
                int n9 = this.ix(n6);
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    for (int i = 0; i < n2; ++i) {
                        nArray[i + n] = Bits.getIntB(n9 + (i << 2));
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        nArray[i + n] = Bits.getIntL(n9 + (i << 2));
                    }
                }
                this.nextGetIndex(n2);
                return this;
            }
            int n10 = Threads.getCurrentVMThread();
            Threads.pinObject(n10, nArray);
            try {
                int n11 = Memory.getArrayData(nArray, n);
                Memory.copyMemory(n11, this.ix(this.nextGetIndex(n2)), n3);
                DirectIntBufferU directIntBufferU = this;
                return directIntBufferU;
            }
            finally {
                Threads.unpinLastObject(n10);
            }
        }
        return super.get(nArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntBuffer put(int[] nArray, int n, int n2) {
        int n3 = n2 << 2;
        int n4 = nArray.length << 2;
        ByteOrder byteOrder = this.order();
        if (byteOrder != Bits.byteOrder() || n3 > 128) {
            int n5;
            DirectIntBufferU.checkBounds(n, n2, nArray.length);
            int n6 = this.position();
            int n7 = this.limit();
            assert (n6 <= n7);
            int n8 = n5 = n6 <= n7 ? n7 - n6 : 0;
            if (n2 > n5) {
                throw new BufferUnderflowException();
            }
            if (byteOrder != Bits.byteOrder()) {
                int n9 = this.ix(n6);
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    for (int i = 0; i < n2; ++i) {
                        Bits.putIntB(n9 + (i << 2), nArray[i + n]);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        Bits.putIntL(n9 + (i << 2), nArray[i + n]);
                    }
                }
                this.nextGetIndex(n2);
                return this;
            }
            int n10 = Threads.getCurrentVMThread();
            Threads.pinObject(n10, nArray);
            try {
                int n11 = Memory.getArrayData(nArray, n);
                Memory.copyMemory(this.ix(this.nextGetIndex(n2)), n11, n3);
                DirectIntBufferU directIntBufferU = this;
                return directIntBufferU;
            }
            finally {
                Threads.unpinLastObject(n10);
            }
        }
        return super.put(nArray, n, n2);
    }

    public IntBuffer put(int n) {
        Memory.setInt(this.ix(this.nextPutIndex()), n);
        return this;
    }

    public IntBuffer put(int n, int n2) {
        Memory.setInt(this.ix(this.checkIndex(n)), n2);
        return this;
    }

    public IntBuffer put(IntBuffer intBuffer) {
        if (intBuffer instanceof DirectIntBufferU) {
            int n;
            if (intBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectIntBufferU directIntBufferU = (DirectIntBufferU)intBuffer;
            int n2 = directIntBufferU.position();
            int n3 = directIntBufferU.limit();
            assert (n2 <= n3);
            int n4 = n2 <= n3 ? n3 - n2 : 0;
            int n5 = this.position();
            int n6 = this.limit();
            assert (n5 <= n6);
            int n7 = n = n5 <= n6 ? n6 - n5 : 0;
            if (n4 > n) {
                throw new BufferOverflowException();
            }
            Memory.copyMemory(this.ix(n5), directIntBufferU.ix(n2), n4 << 2);
            directIntBufferU.position(n2 + n4);
            this.position(n5 + n4);
        } else if (!intBuffer.isDirect()) {
            int n = intBuffer.position();
            int n8 = intBuffer.limit();
            assert (n <= n8);
            int n9 = n <= n8 ? n8 - n : 0;
            this.put(intBuffer.array(), intBuffer.arrayOffset() + n, n9);
            intBuffer.position(n + n9);
        } else {
            super.put(intBuffer);
        }
        return this;
    }

    public IntBuffer compact() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        Memory.copyMemory(this.ix(0), this.ix(n), n3 << 2);
        this.position(n3);
        this.limit(this.capacity());
        return this;
    }

    public boolean isDirect() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

