/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DirectByteBuffer;
import java.nio.DirectShortBufferRU;
import java.nio.ShortBuffer;
import jrockit.io.IOMemory;
import jrockit.nio.ch.DirectBuffer;
import jrockit.vm.Memory;
import jrockit.vm.Threads;

class DirectShortBufferU
extends ShortBuffer
implements DirectBuffer,
IOMemory {
    protected static final boolean unaligned = Bits.unaligned();
    protected boolean allocated;
    protected Object viewedBuffer = null;

    public int acquire() {
        return this.address() + this.position();
    }

    public void release(int n) {
        if (n > 0) {
            this.position(this.position() + n);
        }
    }

    public Object viewedBuffer() {
        return this.viewedBuffer;
    }

    DirectShortBufferU(DirectByteBuffer directByteBuffer) {
        super(-1, 0, directByteBuffer.remaining() >> 1, directByteBuffer.remaining() >> 1);
        int n = this.capacity();
        this.limit(n);
        int n2 = this.position();
        assert (n2 <= n);
        this.address = directByteBuffer.address() + n2;
        this.allocated = false;
        this.viewedBuffer = directByteBuffer;
    }

    DirectShortBufferU(DirectBuffer directBuffer, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4);
        this.address = directBuffer.address() + n5;
        this.allocated = false;
        this.viewedBuffer = directBuffer;
    }

    public ShortBuffer slice() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n << 1;
        assert (n4 >= 0);
        return new DirectShortBufferU(this, -1, 0, n3, n3, n4);
    }

    public ShortBuffer duplicate() {
        return new DirectShortBufferU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public ShortBuffer asReadOnlyBuffer() {
        return new DirectShortBufferRU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public int address() {
        return this.address;
    }

    private int ix(int n) {
        return this.address + (n << 1);
    }

    public short get() {
        return Memory.getShort(this.ix(this.nextGetIndex()));
    }

    public short get(int n) {
        return Memory.getShort(this.ix(this.checkIndex(n)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShortBuffer get(short[] sArray, int n, int n2) {
        int n3 = n2 << 1;
        int n4 = sArray.length << 1;
        ByteOrder byteOrder = this.order();
        if (byteOrder != Bits.byteOrder() || n3 > 128) {
            int n5;
            DirectShortBufferU.checkBounds(n, n2, sArray.length);
            int n6 = this.position();
            int n7 = this.limit();
            assert (n6 <= n7);
            int n8 = n5 = n6 <= n7 ? n7 - n6 : 0;
            if (n2 > n5) {
                throw new BufferUnderflowException();
            }
            if (byteOrder != Bits.byteOrder()) {
                int n9 = this.ix(n6);
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    for (int i = 0; i < n2; ++i) {
                        sArray[i + n] = Bits.getShortB(n9 + (i << 1));
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        sArray[i + n] = Bits.getShortL(n9 + (i << 1));
                    }
                }
                this.nextGetIndex(n2);
                return this;
            }
            int n10 = Threads.getCurrentVMThread();
            Threads.pinObject(n10, sArray);
            try {
                int n11 = Memory.getArrayData(sArray, n);
                Memory.copyMemory(n11, this.ix(this.nextGetIndex(n2)), n3);
                DirectShortBufferU directShortBufferU = this;
                return directShortBufferU;
            }
            finally {
                Threads.unpinLastObject(n10);
            }
        }
        return super.get(sArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShortBuffer put(short[] sArray, int n, int n2) {
        int n3 = n2 << 1;
        int n4 = sArray.length << 1;
        ByteOrder byteOrder = this.order();
        if (byteOrder != Bits.byteOrder() || n3 > 128) {
            int n5;
            DirectShortBufferU.checkBounds(n, n2, sArray.length);
            int n6 = this.position();
            int n7 = this.limit();
            assert (n6 <= n7);
            int n8 = n5 = n6 <= n7 ? n7 - n6 : 0;
            if (n2 > n5) {
                throw new BufferUnderflowException();
            }
            if (byteOrder != Bits.byteOrder()) {
                int n9 = this.ix(n6);
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    for (int i = 0; i < n2; ++i) {
                        Bits.putShortB(n9 + (i << 1), sArray[i + n]);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        Bits.putShortL(n9 + (i << 1), sArray[i + n]);
                    }
                }
                this.nextGetIndex(n2);
                return this;
            }
            int n10 = Threads.getCurrentVMThread();
            Threads.pinObject(n10, sArray);
            try {
                int n11 = Memory.getArrayData(sArray, n);
                Memory.copyMemory(this.ix(this.nextGetIndex(n2)), n11, n3);
                DirectShortBufferU directShortBufferU = this;
                return directShortBufferU;
            }
            finally {
                Threads.unpinLastObject(n10);
            }
        }
        return super.put(sArray, n, n2);
    }

    public ShortBuffer put(short s) {
        Memory.setShort(this.ix(this.nextPutIndex()), s);
        return this;
    }

    public ShortBuffer put(int n, short s) {
        Memory.setShort(this.ix(this.checkIndex(n)), s);
        return this;
    }

    public ShortBuffer put(ShortBuffer shortBuffer) {
        if (shortBuffer instanceof DirectShortBufferU) {
            int n;
            if (shortBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectShortBufferU directShortBufferU = (DirectShortBufferU)shortBuffer;
            int n2 = directShortBufferU.position();
            int n3 = directShortBufferU.limit();
            assert (n2 <= n3);
            int n4 = n2 <= n3 ? n3 - n2 : 0;
            int n5 = this.position();
            int n6 = this.limit();
            assert (n5 <= n6);
            int n7 = n = n5 <= n6 ? n6 - n5 : 0;
            if (n4 > n) {
                throw new BufferOverflowException();
            }
            Memory.copyMemory(this.ix(n5), directShortBufferU.ix(n2), n4 << 1);
            directShortBufferU.position(n2 + n4);
            this.position(n5 + n4);
        } else if (!shortBuffer.isDirect()) {
            int n = shortBuffer.position();
            int n8 = shortBuffer.limit();
            assert (n <= n8);
            int n9 = n <= n8 ? n8 - n : 0;
            this.put(shortBuffer.array(), shortBuffer.arrayOffset() + n, n9);
            shortBuffer.position(n + n9);
        } else {
            super.put(shortBuffer);
        }
        return this;
    }

    public ShortBuffer compact() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        Memory.copyMemory(this.ix(0), this.ix(n), n3 << 1);
        this.position(n3);
        this.limit(this.capacity());
        return this;
    }

    public boolean isDirect() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

