/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;
import java.util.Arrays;
import jrockit.vm.Memory;

public class AtomicIntegerArray
implements Serializable {
    private static final long serialVersionUID = 2862133569453604235L;
    private static final int base = Memory.arrayHeaderSize();
    private static final int scale = 4;
    private final int[] array;

    private final int rawIndex(int n) {
        if (n < 0 || n >= this.array.length) {
            throw new IndexOutOfBoundsException("index " + n);
        }
        return base + n * 4;
    }

    public AtomicIntegerArray(int n) {
        this.array = new int[n];
        if (n > 0) {
            this.set(0, 0);
        }
    }

    public AtomicIntegerArray(int[] nArray) {
        if (nArray == null) {
            throw new NullPointerException();
        }
        int n = nArray.length;
        this.array = new int[n];
        if (n > 0) {
            int n2 = n - 1;
            for (int i = 0; i < n2; ++i) {
                this.array[i] = nArray[i];
            }
            this.set(n2, nArray[n2]);
        }
    }

    public final int length() {
        return this.array.length;
    }

    public final int get(int n) {
        return Memory.getIntVolatile(this.array, this.rawIndex(n));
    }

    public final void set(int n, int n2) {
        Memory.setIntVolatile(this.array, this.rawIndex(n), n2);
    }

    public final int getAndSet(int n, int n2) {
        int n3;
        while (!this.compareAndSet(n, n3 = this.get(n), n2)) {
        }
        return n3;
    }

    public final boolean compareAndSet(int n, int n2, int n3) {
        return Memory.cas((Object)this.array, this.rawIndex(n), n2, n3) == n2;
    }

    public final boolean weakCompareAndSet(int n, int n2, int n3) {
        return this.compareAndSet(n, n2, n3);
    }

    public final int getAndIncrement(int n) {
        int n2;
        int n3;
        while (!this.compareAndSet(n, n3 = this.get(n), n2 = n3 + 1)) {
        }
        return n3;
    }

    public final int getAndDecrement(int n) {
        int n2;
        int n3;
        while (!this.compareAndSet(n, n3 = this.get(n), n2 = n3 - 1)) {
        }
        return n3;
    }

    public final int getAndAdd(int n, int n2) {
        int n3;
        int n4;
        while (!this.compareAndSet(n, n4 = this.get(n), n3 = n4 + n2)) {
        }
        return n4;
    }

    public final int incrementAndGet(int n) {
        int n2;
        int n3;
        while (!this.compareAndSet(n, n3 = this.get(n), n2 = n3 + 1)) {
        }
        return n2;
    }

    public final int decrementAndGet(int n) {
        int n2;
        int n3;
        while (!this.compareAndSet(n, n3 = this.get(n), n2 = n3 - 1)) {
        }
        return n2;
    }

    public final int addAndGet(int n, int n2) {
        int n3;
        int n4;
        while (!this.compareAndSet(n, n4 = this.get(n), n3 = n4 + n2)) {
        }
        return n3;
    }

    public String toString() {
        if (this.array.length > 0) {
            this.get(0);
        }
        return Arrays.toString(this.array);
    }
}

