/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import jrockit.vm.Memory;
import jrockit.vm.Reflect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AtomicIntegerFieldUpdater<T> {
    public static <U> AtomicIntegerFieldUpdater<U> newUpdater(Class<U> clazz, String string) {
        return new AtomicIntegerFieldUpdaterImpl<U>(clazz, string);
    }

    protected AtomicIntegerFieldUpdater() {
    }

    public abstract boolean compareAndSet(T var1, int var2, int var3);

    public abstract boolean weakCompareAndSet(T var1, int var2, int var3);

    public abstract void set(T var1, int var2);

    public abstract int get(T var1);

    public int getAndSet(T t, int n) {
        int n2;
        while (!this.compareAndSet(t, n2 = this.get(t), n)) {
        }
        return n2;
    }

    public int getAndIncrement(T t) {
        int n;
        int n2;
        while (!this.compareAndSet(t, n2 = this.get(t), n = n2 + 1)) {
        }
        return n2;
    }

    public int getAndDecrement(T t) {
        int n;
        int n2;
        while (!this.compareAndSet(t, n2 = this.get(t), n = n2 - 1)) {
        }
        return n2;
    }

    public int getAndAdd(T t, int n) {
        int n2;
        int n3;
        while (!this.compareAndSet(t, n3 = this.get(t), n2 = n3 + n)) {
        }
        return n3;
    }

    public int incrementAndGet(T t) {
        int n;
        int n2;
        while (!this.compareAndSet(t, n2 = this.get(t), n = n2 + 1)) {
        }
        return n;
    }

    public int decrementAndGet(T t) {
        int n;
        int n2;
        while (!this.compareAndSet(t, n2 = this.get(t), n = n2 - 1)) {
        }
        return n;
    }

    public int addAndGet(T t, int n) {
        int n2;
        int n3;
        while (!this.compareAndSet(t, n3 = this.get(t), n2 = n3 + n)) {
        }
        return n2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AtomicIntegerFieldUpdaterImpl<T>
    extends AtomicIntegerFieldUpdater<T> {
        private final int offset;
        private final Class<T> tclass;

        AtomicIntegerFieldUpdaterImpl(Class<T> clazz, String string) {
            Field field = null;
            try {
                field = clazz.getDeclaredField(string);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            Class<?> clazz2 = field.getType();
            if (clazz2 != Integer.TYPE) {
                throw new IllegalArgumentException("Must be integer type");
            }
            if (!Modifier.isVolatile(field.getModifiers())) {
                throw new IllegalArgumentException("Must be volatile type");
            }
            this.tclass = clazz;
            this.offset = Reflect.IField.getOffset(field);
        }

        @Override
        public boolean compareAndSet(T t, int n, int n2) {
            if (!this.tclass.isInstance(t)) {
                throw new ClassCastException();
            }
            return Memory.cas(t, this.offset, n, n2) == n;
        }

        @Override
        public boolean weakCompareAndSet(T t, int n, int n2) {
            return this.compareAndSet(t, n, n2);
        }

        @Override
        public void set(T t, int n) {
            if (!this.tclass.isInstance(t)) {
                throw new ClassCastException();
            }
            Memory.setIntVolatile(t, this.offset, n);
        }

        @Override
        public final int get(T t) {
            if (!this.tclass.isInstance(t)) {
                throw new ClassCastException();
            }
            return Memory.getIntVolatile(t, this.offset);
        }
    }
}

