/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.zip.DataFormatException;
import jrockit.vm.Memory;
import jrockit.vm.Reflect;
import jrockit.vm.Threads;

public class Inflater {
    private final int strm;
    private boolean open;
    private byte[] buf = new byte[0];
    private int off;
    private int len;
    private boolean finished;
    private boolean needDict;

    public Inflater(boolean bl) {
        this.strm = Inflater.init(bl);
        this.open = this.strm != 0;
    }

    public Inflater() {
        this(false);
    }

    public synchronized void setInput(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n > byArray.length - n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.buf = byArray;
        this.off = n;
        this.len = n2;
    }

    public void setInput(byte[] byArray) {
        this.setInput(byArray, 0, byArray.length);
    }

    public synchronized void setDictionary(byte[] byArray, int n, int n2) {
        if (!this.open || byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n > byArray.length - n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Inflater.setDictionary(this.strm, byArray, n, n2);
        this.needDict = false;
    }

    public void setDictionary(byte[] byArray) {
        this.setDictionary(byArray, 0, byArray.length);
    }

    public synchronized int getRemaining() {
        return this.len;
    }

    public synchronized boolean needsInput() {
        return this.len <= 0;
    }

    public synchronized boolean needsDictionary() {
        return this.needDict;
    }

    public synchronized boolean finished() {
        return this.finished;
    }

    public synchronized int inflate(byte[] byArray, int n, int n2) throws DataFormatException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n > byArray.length - n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.inflateBytes(byArray, n, n2);
    }

    public int inflate(byte[] byArray) throws DataFormatException {
        return this.inflate(byArray, 0, byArray.length);
    }

    public synchronized int getAdler() {
        this.ensureOpen();
        return Inflater.getAdler(this.strm);
    }

    public int getTotalIn() {
        return (int)this.getBytesRead();
    }

    public synchronized long getBytesRead() {
        this.ensureOpen();
        return Inflater.getBytesRead(this.strm);
    }

    public int getTotalOut() {
        return (int)this.getBytesWritten();
    }

    public synchronized long getBytesWritten() {
        this.ensureOpen();
        return Inflater.getBytesWritten(this.strm);
    }

    public synchronized void reset() {
        this.ensureOpen();
        Inflater.reset(this.strm);
        this.finished = false;
        this.needDict = false;
        this.len = 0;
        this.off = 0;
    }

    public synchronized void end() {
        if (this.open) {
            Inflater.end(this.strm);
            this.open = false;
        }
    }

    protected void finalize() {
        this.end();
    }

    private void ensureOpen() {
        if (!this.open) {
            throw new NullPointerException();
        }
    }

    private static native int init(boolean var0);

    private static native void setDictionary(int var0, byte[] var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int inflateBytes(byte[] byArray, int n, int n2) throws DataFormatException {
        int n3 = Threads.getCurrentVMThread();
        try {
            Threads.pinObject(n3, byArray);
            Threads.pinObject(n3, this.buf);
            int n4 = Memory.getArrayData(byArray, n);
            int n5 = Memory.getArrayData(this.buf, this.off);
            int n6 = Inflater.inflateFast(this.strm, n5, this.len, n4, n2);
            int n7 = Reflect.IZStream.getAvailIn(this.strm);
            int n8 = Reflect.IZStream.getAvailOut(this.strm);
            switch (n6) {
                case 1: {
                    this.finished = true;
                }
                case 0: {
                    this.off = this.off + this.len - n7;
                    this.len = n7;
                    n6 = n2 - n8;
                    return n6;
                }
                case 2: {
                    this.needDict = true;
                    this.off = this.off + this.len - n7;
                    this.len = n7;
                }
                case -5: 
                case -4: {
                    n6 = 0;
                    return n6;
                }
                default: {
                    throw new InternalError("Z inflate should have provided exception!");
                }
            }
        }
        finally {
            Threads.unpinLastObject(n3);
            Threads.unpinLastObject(n3);
        }
    }

    private static native int inflateFast(int var0, int var1, int var2, int var3, int var4) throws DataFormatException;

    private static native int getAdler(int var0);

    private static native long getBytesRead(int var0);

    private static native long getBytesWritten(int var0);

    private static native void reset(int var0);

    private static native void end(int var0);
}

