/*
 * Decompiled with CFR 0.152.
 */
package jrockit.ext;

import com.bea.jvm.PerformanceCounter;
import java.lang.reflect.Field;
import jrockit.vm.Memory;
import jrockit.vm.Reflect;

public final class FastPerformanceCounter
extends PerformanceCounter {
    private static final int offset;
    private final String name;
    private volatile long value;

    public FastPerformanceCounter(String string, long l) {
        this.name = string;
        this.value = l;
    }

    public final String getName() {
        return this.name;
    }

    public final long get() {
        return this.value;
    }

    public final void set(long l) {
        this.value = l;
    }

    public final long getAndSet(long l) {
        long l2;
        while (Memory.cas((Object)this, offset, l2 = this.get(), l) != l2) {
        }
        return l2;
    }

    public final long getAndIncrement() {
        long l;
        long l2;
        while (Memory.cas((Object)this, offset, l2 = this.get(), l = l2 + 1L) != l2) {
        }
        return l2;
    }

    public final long getAndDecrement() {
        long l;
        long l2;
        while (Memory.cas((Object)this, offset, l2 = this.get(), l = l2 - 1L) != l2) {
        }
        return l2;
    }

    public final long getAndAdd(long l) {
        long l2;
        long l3;
        while (Memory.cas((Object)this, offset, l3 = this.get(), l2 = l3 + l) != l3) {
        }
        return l3;
    }

    public final long incrementAndGet() {
        long l;
        long l2;
        while (Memory.cas((Object)this, offset, l2 = this.get(), l = l2 + 1L) != l2) {
        }
        return l;
    }

    public final long decrementAndGet() {
        long l;
        long l2;
        while (Memory.cas((Object)this, offset, l2 = this.get(), l = l2 - 1L) != l2) {
        }
        return l;
    }

    public final long addAndGet(long l) {
        long l2;
        long l3;
        while (Memory.cas((Object)this, offset, l3 = this.get(), l2 = l3 + l) != l3) {
        }
        return l2;
    }

    static {
        int n = 0;
        try {
            Field field = FastPerformanceCounter.class.getDeclaredField("value");
            n = Reflect.IField.getOffset(Reflect.IAccessibleObject.getID(field));
        }
        catch (Exception exception) {
            offset = n;
            throw new Error(exception);
        }
        offset = n;
    }
}

