/*
 * Decompiled with CFR 0.152.
 */
package jrockit.ext.counter;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.AllPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.management.counter.Counter;
import sun.management.counter.perf.PerfInstrumentation;
import sun.misc.Perf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Counters {
    private static final Counters instance = new Counters(0);
    private int vmid;
    private PerfInstrumentation perfInstr = null;
    private boolean noPerfData = false;
    private List<Counter> counters;

    private Counters(int n) {
        this.vmid = n;
        this.perfInstr = this.getPerfInstrumentation(n);
    }

    private synchronized PerfInstrumentation getPerfInstrumentation(int n) {
        if (this.noPerfData || this.perfInstr != null) {
            return this.perfInstr;
        }
        Perf perf = (Perf)AccessController.doPrivileged(new Perf.GetPerfAction());
        try {
            ByteBuffer byteBuffer = perf.attach(n, "r");
            if (byteBuffer.capacity() == 0) {
                this.noPerfData = true;
                return null;
            }
            this.perfInstr = new PerfInstrumentation(byteBuffer);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.noPerfData = true;
        }
        catch (IOException iOException) {
            throw new InternalError(iOException.getMessage());
        }
        return this.perfInstr;
    }

    public static Counters acquire() {
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(new AllPermission());
        }
        return instance;
    }

    public static Counters acquire(int n) {
        if (n == 0) {
            return Counters.acquire();
        }
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(new AllPermission());
        }
        return new Counters(n);
    }

    public synchronized List<Counter> getPerformanceCounters(boolean bl) {
        if (this.counters == null || bl) {
            if (this.perfInstr == null) {
                this.counters = Collections.EMPTY_LIST;
                return this.counters;
            }
            this.counters = Collections.unmodifiableList(this.perfInstr.getAllCounters());
        }
        return this.counters;
    }

    public synchronized List<Counter> getPerformanceCounters() {
        return this.getPerformanceCounters(false);
    }

    public Counter getPerformanceCounter(String string) {
        for (Counter counter : this.getPerformanceCounters()) {
            if (!string.equals(counter.getName())) continue;
            return counter;
        }
        return null;
    }

    public List<Counter> findPerformanceCounters(String string) {
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher("");
        ArrayList<Counter> arrayList = new ArrayList<Counter>();
        for (Counter counter : this.getPerformanceCounters()) {
            String string2 = counter.getName();
            matcher.reset(string2);
            if (!matcher.lookingAt()) continue;
            arrayList.add(counter);
        }
        return arrayList;
    }

    public String toString() {
        return "Counters for VM " + this.vmid;
    }
}

