/*
 * Decompiled with CFR 0.152.
 */
package jrockit.ext.epoll;

import jrockit.vm.Memory;
import jrockit.vm.Reflect;

public final class EPollEventBuffer {
    int buffer;
    int nElems;

    private EPollEventBuffer(int n) {
        this.nElems = n;
        this.buffer = Memory.allocateMemory(n * Reflect.offset(3584));
    }

    public int getID(int n) {
        return Memory.getInt(this.buffer, Reflect.offset(3584) * n + Reflect.offset(3586));
    }

    public int getEvent(int n) {
        return Memory.getInt(this.buffer, Reflect.offset(3584) * n + Reflect.offset(3585));
    }

    public int getSize() {
        return this.nElems;
    }

    public static EPollEventBuffer allocEventBuffer(int n) {
        EPollEventBuffer ePollEventBuffer = new EPollEventBuffer(n);
        return ePollEventBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeEventBuffer(EPollEventBuffer ePollEventBuffer) {
        EPollEventBuffer ePollEventBuffer2 = ePollEventBuffer;
        synchronized (ePollEventBuffer2) {
            if (ePollEventBuffer.buffer != 0) {
                Memory.freeMemory(ePollEventBuffer.buffer);
                ePollEventBuffer.buffer = 0;
            }
        }
    }

    protected void finalize() {
        if (this.buffer != 0) {
            EPollEventBuffer.freeEventBuffer(this);
        }
    }
}

