/*
 * Decompiled with CFR 0.152.
 */
package jrockit.io;

import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.SyncFailedException;
import jrockit.io.NativeIO;

public final class FileNativeIO
extends NativeIO {
    private static FileNativeIO instance = new FileNativeIO();
    private static NativeIO.OutOfHandlesLock mapHandleLock = new NativeIO.OutOfHandlesLock();
    public static final int MAP_RO = 0;
    public static final int MAP_RW = 1;
    public static final int MAP_PV = 2;
    public static final int NO_LOCK = -1;
    public static final int LOCKED = 0;
    public static final int RET_EX_LOCK = 1;
    public static final int INTERRUPTED = 2;
    public static final int STDIN = 0;
    public static final int STDOUT = 1;
    public static final int STDERR = 2;
    public static final int OPEN_READONLY = 1;
    public static final int OPEN_WRITEONLY = 4;
    public static final int OPEN_ALWAYS = 8;
    public static final int OPEN_EXISTING = 16;
    public static final int CREATE_ALWAYS = 32;
    public static final int CREATE_NEW = 64;
    public static final int OPEN_SEEK_END = 128;
    public static final int OPEN_SYNC = 256;
    public static final int OPEN_TEMP = 512;
    public static final int SHARE_READ = 1024;
    public static final int SHARE_WRITE = 2048;
    public static final int SHARE_DELETE = 4096;

    private FileNativeIO() {
    }

    public static synchronized FileNativeIO getInstance() {
        return instance;
    }

    public static native int getMemoryMapGranularity();

    public void sync(FileDescriptor fileDescriptor) throws SyncFailedException {
        try {
            FileNativeIO.force(FileNativeIO.fh(fileDescriptor), true);
        }
        catch (IOException iOException) {
            throw new SyncFailedException(iOException.getMessage());
        }
    }

    protected native int read(int var1, int var2, int var3) throws IOException;

    protected native int pread(int var1, int var2, int var3, long var4) throws IOException;

    protected native long readv(int var1, int var2, int var3) throws IOException;

    protected native int write(int var1, int var2, int var3) throws IOException;

    protected native int pwrite(int var1, int var2, int var3, long var4) throws IOException;

    protected native long writev(int var1, int var2, int var3) throws IOException;

    protected native void close(int var1, boolean var2) throws IOException;

    protected native int available(int var1) throws IOException;

    private static native int lock(int var0, boolean var1, long var2, long var4, boolean var6) throws IOException;

    private static native void release(int var0, long var1, long var3) throws IOException;

    private static native int map(int var0, int var1, long var2, long var4) throws IOException;

    private static native void force(int var0, boolean var1) throws IOException;

    private static native void truncate(int var0, long var1) throws IOException;

    private static native int transferTo(int var0, long var1, int var3, int var4) throws IOException;

    private static native long position(int var0, long var1, boolean var3) throws IOException;

    private static native long size(int var0) throws IOException;

    public int lock(FileDescriptor fileDescriptor, boolean bl, long l, long l2, boolean bl2) throws IOException {
        return FileNativeIO.lock(FileNativeIO.fh(fileDescriptor), bl, l, l2, bl2);
    }

    public void release(FileDescriptor fileDescriptor, long l, long l2) throws IOException {
        FileNativeIO.release(FileNativeIO.fh(fileDescriptor), l, l2);
    }

    public int map(FileDescriptor fileDescriptor, int n, long l, long l2) throws IOException {
        int n2 = 0;
        boolean bl = false;
        while ((n2 = FileNativeIO.map(FileNativeIO.fh(fileDescriptor), n, l, l2)) == 0) {
            if (bl || !mapHandleLock.waitForRelease()) {
                throw new IOException("map: no memory available");
            }
            bl = true;
        }
        return n2;
    }

    public static native void unmap0(int var0, int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unmap(int n, int n2) {
        try {
            FileNativeIO.unmap0(n, n2);
        }
        finally {
            mapHandleLock.signalRelease();
        }
    }

    public void force(FileDescriptor fileDescriptor, boolean bl) throws IOException {
        FileNativeIO.force(FileNativeIO.fh(fileDescriptor), bl);
    }

    public void truncate(FileDescriptor fileDescriptor, long l) throws IOException {
        FileNativeIO.truncate(FileNativeIO.fh(fileDescriptor), l);
    }

    public int transferTo(FileDescriptor fileDescriptor, long l, int n, FileDescriptor fileDescriptor2) throws IOException {
        return FileNativeIO.transferTo(FileNativeIO.fh(fileDescriptor), l, n, FileNativeIO.fh(fileDescriptor2));
    }

    public long position(FileDescriptor fileDescriptor, long l, boolean bl) throws IOException {
        if (bl && l < 0L) {
            throw new IOException("position: cannot do relative query");
        }
        return FileNativeIO.position(FileNativeIO.fh(fileDescriptor), l, bl);
    }

    public long size(FileDescriptor fileDescriptor) throws IOException {
        return FileNativeIO.size(FileNativeIO.fh(fileDescriptor));
    }

    private static native int open0(String var0, int var1) throws FileNotFoundException;

    public static FileDescriptor open(String string, int n) throws FileNotFoundException {
        int n2;
        if (string == null) {
            throw new NullPointerException();
        }
        boolean bl = false;
        while ((n2 = FileNativeIO.open0(string, n)) == -1) {
            if (bl || !handleLock.waitForRelease()) {
                throw new FileNotFoundException(string + " : too many open files");
            }
            bl = true;
        }
        return FileNativeIO.newFD(n2);
    }

    private static native int getStdHandle0(int var0);

    public static FileDescriptor getStdHandle(int n) {
        return FileNativeIO.newFD(FileNativeIO.getStdHandle0(n));
    }
}

