/*
 * Decompiled with CFR 0.152.
 */
package jrockit.license;

import java.io.File;
import java.io.IOException;
import jrockit.license.License;
import jrockit.license.LicenseException;

public class LicenseManager {
    private static License license;
    private static File licenseFile;
    private static final String JROCKIT_LICENSE_PATH_PROPERTY = "jrockit.license.path";
    private static final String JROCKIT_LICENSE_DEFAULT_FILENAME = "jrockit.license";

    public static String getLicenseProperty(String string) {
        return license == null ? null : license.getProperty(string);
    }

    public static boolean hasLicenseProperty(String string) {
        return license == null ? false : license.getProperty(string) != null;
    }

    private static void initialize0(String[] stringArray) throws LicenseException {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                licenseFile = new File(stringArray[i]);
                if (licenseFile.exists()) {
                    bl = true;
                }
                license = new License(licenseFile);
            }
            catch (Exception exception) {
                continue;
            }
            try {
                if (!license.verify()) {
                    String string = "License not valid: " + license.getErrorCode();
                    license = null;
                    throw new LicenseException(string);
                }
                break;
            }
            catch (Exception exception) {
                throw new LicenseException(exception);
            }
        }
        if (!bl) {
            throw new LicenseException("No license file found.");
        }
    }

    public static void initialize() throws LicenseException, IOException {
        String[] stringArray = new String[]{System.getProperty(JROCKIT_LICENSE_PATH_PROPERTY), System.getProperty("java.home") + File.separator + JROCKIT_LICENSE_DEFAULT_FILENAME, System.getProperty("java.home") + File.separator + ".." + File.separator + JROCKIT_LICENSE_DEFAULT_FILENAME, JROCKIT_LICENSE_DEFAULT_FILENAME};
        LicenseManager.initialize0(stringArray);
    }

    public static void initialize(String string) throws LicenseException, IOException {
        String[] stringArray = new String[]{string};
        LicenseManager.initialize0(stringArray);
    }
}

