/*
 * Decompiled with CFR 0.152.
 */
package jrockit.management;

import java.security.AccessController;
import java.security.PrivilegedAction;
import jrockit.management.CompilationMXBean;
import jrockit.management.Toolkit;
import sun.management.MXBeanSupport;

public class Compilation
extends MXBeanSupport
implements CompilationMXBean {
    private static Compilation m_singleton;

    public Compilation() {
        super(CompilationMXBean.class);
    }

    public String getName() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("sun.management.compiler");
            }
        });
        return string;
    }

    public boolean isCompilationTimeMonitoringSupported() {
        return true;
    }

    public long getTotalCompilationTime() {
        return Compilation.getCodeGenTime(0);
    }

    public static synchronized CompilationMXBean getCompilationMXBean() {
        if (m_singleton == null) {
            m_singleton = new Compilation();
        }
        return m_singleton;
    }

    public long getJITCompilationTime() {
        return Compilation.getCodeGenTime(2);
    }

    public long getOptimizingTime() {
        return Compilation.getCodeGenTime(1);
    }

    public boolean isVerbose() {
        return Compilation.isVerbose0();
    }

    public void setVerbose(boolean bl) {
        Toolkit.checkControl();
        Compilation.setVerbose0(bl);
    }

    private static native int getCodeGenTime(int var0);

    private static native void setVerbose0(boolean var0);

    private static native boolean isVerbose0();
}

