/*
 * Decompiled with CFR 0.152.
 */
package jrockit.management;

import com.bea.jvm.JVMFactory;
import com.bea.jvm.NotAvailableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jrockit.management.GarbageCollectorMXBean;
import jrockit.management.HeapMemoryPool;
import jrockit.mapi.GarbageCollectorImpl;
import sun.management.MXBeanSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GarbageCollector
extends MXBeanSupport
implements GarbageCollectorMXBean {
    private static GarbageCollectorMXBean m_garbageCollectorMBean;
    private static List<java.lang.management.GarbageCollectorMXBean> m_garbageCollectorMBeans;
    private static GarbageCollectorImpl m_gc;

    public GarbageCollector() {
        super(GarbageCollectorMXBean.class);
    }

    @Override
    public long getCollectionCount() {
        return m_gc.getTotalGarbageCollectionCount();
    }

    @Override
    public long getCollectionTime() {
        return m_gc.getTotalGarbageCollectionTime();
    }

    @Override
    public String getName() {
        return "Dynamic GC";
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public String[] getMemoryPoolNames() {
        String[] stringArray = new String[]{HeapMemoryPool.getHeapMemoryPoolMXBean().getName()};
        return stringArray;
    }

    @Override
    public long getNurserySize() {
        try {
            return m_gc.getNurserySize();
        }
        catch (NotAvailableException notAvailableException) {
            return 0L;
        }
    }

    @Override
    public void setNurserySize(long l) {
        m_gc.setNurserySize(l);
    }

    public static synchronized GarbageCollectorMXBean getGarbageCollectorMXBean() {
        if (m_garbageCollectorMBean == null) {
            m_gc = (GarbageCollectorImpl)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return JVMFactory.getJVM().getMemorySystem().getGarbageCollector();
                }
            });
            m_garbageCollectorMBean = new GarbageCollector();
        }
        return m_garbageCollectorMBean;
    }

    public static synchronized List<java.lang.management.GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        if (m_garbageCollectorMBeans == null) {
            m_garbageCollectorMBeans = new ArrayList<java.lang.management.GarbageCollectorMXBean>(1);
            m_garbageCollectorMBeans.add(GarbageCollector.getGarbageCollectorMXBean());
            m_garbageCollectorMBeans = Collections.unmodifiableList(m_garbageCollectorMBeans);
        }
        return m_garbageCollectorMBeans;
    }
}

