/*
 * Decompiled with CFR 0.152.
 */
package jrockit.management;

import com.bea.jvm.ClassLibrary;
import com.bea.jvm.GarbageCollector;
import com.bea.jvm.JVMFactory;
import com.bea.jvm.event.GarbageCollectionEvent;
import com.bea.jvm.event.GarbageCollectionListener;
import com.bea.jvm.event.GarbageCollectionStrategyChangeEvent;
import com.bea.jvm.event.GarbageCollectionStrategyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.zip.GZIPOutputStream;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import jrockit.internal.CtrlBreakHandler;
import jrockit.jra.JraSystem;
import jrockit.license.LicenseException;
import jrockit.management.GarbageCollectionStrategy;
import jrockit.management.JRockitConsoleMXBean;
import jrockit.management.JRockitConsoleNotificationInfo;
import jrockit.management.Runtime;
import jrockit.management.Toolkit;
import jrockit.mapi.GCEventImpl;
import sun.management.NotificationEmitterSupport;

public class JRockitConsole
extends NotificationEmitterSupport
implements JRockitConsoleMXBean {
    private static final CompositeType COMPOSITE_TYPE;
    private static final String GC_START_TIME = "startTime";
    private static final String GC_END_TIME = "endTime";
    private static final String GC_IS_MAJOR = "isMajorGC";
    private static final String GC_OLD_HEAP = "oldHeap";
    private static final String GC_NEW_HEAP = "newHeap";
    private static final String GC_MAX_HEAP = "maxHeap";
    private static final String GC_START_PAGEFAULTS = "startPageFaults";
    private static final String GC_END_PAGEFAULTS = "endPageFaults";
    private static final String[] GC_EVENT_ITEM_NAMES;
    private static final OpenType[] GC_EVENT_OPEN_TYPES;
    private static final int JRA_BUF_SIZE = 4096;
    private static JRockitConsole m_singleton;
    private static JRAFile m_jraFile;
    private static ClassLibrary m_library;
    private static long m_seqNumber;
    private static ObjectName m_objectName;
    private static MBeanNotificationInfo[] m_notificationInfo;
    private static final String m_notificationName = "javax.management.Notification";
    private static final String[] m_notificationTypes;
    private JRGarbageCollectionStrategyListener m_strategyChangeListener;
    private JRGarbageCollectionListener m_gcListener;

    public JRockitConsole() {
        super(JRockitConsoleMXBean.class);
    }

    private static long getNextSeqNumber() {
        return ++m_seqNumber;
    }

    public long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public boolean isThrowable(String string) {
        try {
            Collection collection = m_library.getAllClasses(string);
            return Throwable.class.isAssignableFrom((Class)collection.iterator().next());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static synchronized JRockitConsoleMXBean getJRockitConsoleMXBean() {
        if (m_singleton == null) {
            m_singleton = new JRockitConsole();
            m_library = (ClassLibrary)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return JVMFactory.getJVM().getClassLibrary();
                }
            });
        }
        return m_singleton;
    }

    public boolean startJRARecording(int n, String string, boolean bl, boolean bl2, boolean bl3) {
        Toolkit.checkMonitor();
        return JraSystem.startRecording(n, string, !bl, !bl2, !bl3);
    }

    public boolean startJRARecording(int n, boolean bl, boolean bl2, boolean bl3) throws IOException {
        Toolkit.checkMonitor();
        this.closeJRARecording();
        File file = File.createTempFile("jrockit", ".jra");
        file.deleteOnExit();
        JraSystem.setZipRecording(false);
        if (!JraSystem.startRecording(n, file.getAbsolutePath(), !bl, !bl2, !bl3)) {
            file.delete();
            return false;
        }
        m_jraFile = new JRAFile(file);
        return true;
    }

    public byte[] readJRARecording() throws IOException {
        if (m_jraFile == null) {
            throw new IOException("No current JRA recording");
        }
        return m_jraFile.read();
    }

    public void closeJRARecording() throws IOException {
        if (m_jraFile != null) {
            m_jraFile.close();
            m_jraFile = null;
        }
    }

    public boolean stopJRARecording() {
        Toolkit.checkMonitor();
        return JraSystem.stopRecording();
    }

    public void runCtrlBreakHandler(String string) {
        Toolkit.checkControl();
        CtrlBreakHandler.execute(string);
    }

    public String runCtrlBreakHandlerWithResult(String string) {
        Toolkit.checkControl();
        return CtrlBreakHandler.executeWithResult(string);
    }

    public GarbageCollectionStrategy getGarbageCollectionStrategy() {
        Toolkit.checkMonitor();
        com.bea.jvm.GarbageCollectionStrategy garbageCollectionStrategy = Runtime.getJVM().getMemorySystem().getGarbageCollector().getGarbageCollectionStrategy();
        boolean bl = "true".equals(garbageCollectionStrategy.getStrategyProperties().getProperty("generational"));
        boolean bl2 = "concurrent".equals(garbageCollectionStrategy.getStrategyProperties().getProperty("mark"));
        boolean bl3 = "concurrent".equals(garbageCollectionStrategy.getStrategyProperties().getProperty("sweep"));
        return new GarbageCollectionStrategy(bl, bl2, bl3);
    }

    public void setGarbageCollectionStrategy(GarbageCollectionStrategy garbageCollectionStrategy) {
        Toolkit.checkControl();
        Collection collection = Runtime.getJVM().getMemorySystem().getGarbageCollector().getGarbageCollectionStrategies();
        for (com.bea.jvm.GarbageCollectionStrategy garbageCollectionStrategy2 : collection) {
            if (!this.isMatching(garbageCollectionStrategy2, garbageCollectionStrategy)) continue;
            Runtime.getJVM().getMemorySystem().getGarbageCollector().suggestGarbageCollectionStrategy(garbageCollectionStrategy2);
            break;
        }
    }

    private boolean isMatching(com.bea.jvm.GarbageCollectionStrategy garbageCollectionStrategy, GarbageCollectionStrategy garbageCollectionStrategy2) {
        boolean bl = "true".equals(garbageCollectionStrategy.getStrategyProperties().getProperty("generational"));
        boolean bl2 = "concurrent".equals(garbageCollectionStrategy.getStrategyProperties().getProperty("mark"));
        boolean bl3 = "concurrent".equals(garbageCollectionStrategy.getStrategyProperties().getProperty("sweep"));
        return garbageCollectionStrategy2.isGenerational() == bl && garbageCollectionStrategy2.isConcurrentMark() == bl2 && garbageCollectionStrategy2.isConcurrentSweep() == bl3;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        if (m_notificationInfo == null) {
            m_notificationInfo = new MBeanNotificationInfo[1];
            JRockitConsole.m_notificationInfo[0] = new MBeanNotificationInfo(m_notificationTypes, m_notificationName, "JRockit specific notification");
        }
        return m_notificationInfo;
    }

    private static synchronized ObjectName getObjectName() {
        if (m_objectName != null) {
            return m_objectName;
        }
        try {
            m_objectName = new ObjectName("java.lang:type=Memory");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        return m_objectName;
    }

    static synchronized void createNotification(GarbageCollectionStrategy garbageCollectionStrategy) {
        JRockitConsole jRockitConsole = (JRockitConsole)JRockitConsole.getJRockitConsoleMXBean();
        if (!jRockitConsole.hasListeners()) {
            return;
        }
        long l = System.currentTimeMillis();
        Notification notification = new Notification("jrockit.management.garbage_collection_strategy_change", JRockitConsole.getObjectName(), JRockitConsole.getNextSeqNumber(), l, "GarbageCollectionStrategy changed!");
        JRockitConsoleNotificationInfo jRockitConsoleNotificationInfo = new JRockitConsoleNotificationInfo(garbageCollectionStrategy);
        CompositeData compositeData = JRockitConsoleNotificationInfo.toCompositeData(jRockitConsoleNotificationInfo);
        notification.setUserData(compositeData);
        jRockitConsole.sendNotification(notification);
    }

    static synchronized void createNotification(GarbageCollectionEvent garbageCollectionEvent) {
        JRockitConsole jRockitConsole = (JRockitConsole)JRockitConsole.getJRockitConsoleMXBean();
        if (!jRockitConsole.hasListeners()) {
            return;
        }
        long l = System.currentTimeMillis();
        Notification notification = new Notification("jrockit.management.garbage_collection", JRockitConsole.getObjectName(), JRockitConsole.getNextSeqNumber(), l, "Garbage collection performed.");
        CompositeData compositeData = JRockitConsole.convertGCEventToComposite(garbageCollectionEvent);
        notification.setUserData(compositeData);
        jRockitConsole.sendNotification(notification);
    }

    public boolean startApplicationProfileRecording(boolean bl, boolean bl2) {
        Toolkit.checkMonitor();
        return JraSystem.startApplicationProfileRecording(!bl, !bl2);
    }

    public String stopApplicationProfileRecording() throws FileNotFoundException, IOException {
        int n;
        Toolkit.checkMonitor();
        String string = JraSystem.stopApplicationProfileRecording();
        if ("".equals(string)) {
            throw new FileNotFoundException("Temporary recording file name was empty");
        }
        File file = new File(string);
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        StringWriter stringWriter = new StringWriter();
        while ((n = bufferedReader.read()) != -1) {
            stringWriter.write(n);
        }
        fileReader.close();
        bufferedReader.close();
        if (file.delete()) {
            System.out.println("[JRockit] Deleted temporary recording file " + string);
        } else {
            System.out.println("[JRockit] Could not delete temporary recording file " + string);
        }
        return stringWriter.toString();
    }

    public synchronized void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        super.addNotificationListener(notificationListener, notificationFilter, object);
        this.checkAddListeners();
    }

    public synchronized void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        super.removeNotificationListener(notificationListener, notificationFilter, object);
        this.checkRemoveListeners();
    }

    public synchronized void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        super.removeNotificationListener(notificationListener);
        this.checkRemoveListeners();
    }

    private void checkRemoveListeners() {
        if (!this.hasListeners()) {
            GarbageCollector garbageCollector = (GarbageCollector)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Runtime.getJVM().getMemorySystem().getGarbageCollector();
                }
            });
            if (this.m_strategyChangeListener != null) {
                garbageCollector.removeGarbageCollectionStrategyChangeListener((GarbageCollectionStrategyChangeListener)this.m_strategyChangeListener);
                this.m_strategyChangeListener = null;
            }
            if (this.m_gcListener != null) {
                garbageCollector.removeGarbageCollectionListener((GarbageCollectionListener)this.m_gcListener);
                this.m_gcListener = null;
            }
        }
    }

    private void checkAddListeners() {
        if (this.hasListeners()) {
            GarbageCollector garbageCollector = (GarbageCollector)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Runtime.getJVM().getMemorySystem().getGarbageCollector();
                }
            });
            if (this.m_strategyChangeListener == null) {
                this.m_strategyChangeListener = new JRGarbageCollectionStrategyListener();
                garbageCollector.addGarbageCollectionStrategyChangeListener((GarbageCollectionStrategyChangeListener)this.m_strategyChangeListener);
            }
            if (this.m_gcListener == null) {
                this.m_gcListener = new JRGarbageCollectionListener();
                garbageCollector.addGarbageCollectionListener((GarbageCollectionListener)this.m_gcListener);
            }
        }
    }

    private static CompositeData convertGCEventToComposite(GarbageCollectionEvent garbageCollectionEvent) {
        if (garbageCollectionEvent instanceof GCEventImpl) {
            GCEventImpl gCEventImpl = (GCEventImpl)garbageCollectionEvent;
            Object[] objectArray = new Object[]{new Long(gCEventImpl.getStartTime()), new Long(gCEventImpl.getEndTime()), new Boolean(gCEventImpl.getEventType() == 0), new Long(gCEventImpl.getOldUsedHeapSize()), new Long(gCEventImpl.getUsedHeapSize()), new Long(gCEventImpl.getMaxHeapSize()), new Long(gCEventImpl.getStartPageFaults()), new Long(gCEventImpl.getEndPageFaults())};
            try {
                return new CompositeDataSupport(COMPOSITE_TYPE, GC_EVENT_ITEM_NAMES, objectArray);
            }
            catch (OpenDataException openDataException) {
                throw new InternalError(openDataException.toString());
            }
        }
        return null;
    }

    public int startMLS(int n, int n2) throws IllegalAccessException, Exception {
        Toolkit.checkControl();
        int n3 = -5;
        try {
            n3 = JRockitConsole.startMLS0(n, n2);
        }
        catch (LicenseException licenseException) {
            throw new IllegalAccessException(licenseException.getMessage());
        }
        catch (IOException iOException) {
            throw new IllegalAccessException(iOException.getMessage());
        }
        if (n3 == -3) {
            throw new Exception("The requested API version (" + n + ") is not supported by the server.");
        }
        if (n3 == -4) {
            throw new Exception("Another client is already connected, only one client can be connected at a time.");
        }
        if (n3 <= 0) {
            throw new Exception("Server start returned error: " + n3);
        }
        return n3;
    }

    public void shutDownMLS() {
        Toolkit.checkControl();
        JRockitConsole.shutDownMLS0();
    }

    public int getMLSPort() {
        Toolkit.checkControl();
        return JRockitConsole.getMLSPort0();
    }

    public int[] getMLSVersions() {
        Toolkit.checkControl();
        return JRockitConsole.getMLSVersions0();
    }

    private static native int startMLS0(int var0, int var1) throws Exception;

    private static native void shutDownMLS0();

    private static native int getMLSPort0();

    private static native int[] getMLSVersions0();

    static {
        GC_EVENT_ITEM_NAMES = new String[]{GC_START_TIME, GC_END_TIME, GC_IS_MAJOR, GC_OLD_HEAP, GC_NEW_HEAP, GC_MAX_HEAP, GC_START_PAGEFAULTS, GC_END_PAGEFAULTS};
        GC_EVENT_OPEN_TYPES = new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.BOOLEAN, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG};
        m_notificationTypes = new String[]{"jrockit.management.garbage_collection_strategy_change", "jrockit.management.garbage_collection"};
        CompositeType compositeType = null;
        try {
            compositeType = new CompositeType("jrockit.management.garbage_collection", "Garbage collection callback", GC_EVENT_ITEM_NAMES, GC_EVENT_ITEM_NAMES, GC_EVENT_OPEN_TYPES);
        }
        catch (OpenDataException openDataException) {
            // empty catch block
        }
        COMPOSITE_TYPE = compositeType;
    }

    private static class JRAFile {
        private Thread m_providerThread;
        private final File m_file;
        private InputStream m_stream;
        private byte[] m_buffer;

        JRAFile(File file) {
            this.m_file = file;
        }

        byte[] read() throws IOException {
            int n;
            if (this.m_stream == null) {
                this.open();
            }
            if ((n = this.m_stream.read(this.m_buffer)) == 4096) {
                return this.m_buffer;
            }
            if (n > 0) {
                byte[] byArray = new byte[n];
                System.arraycopy(this.m_buffer, 0, byArray, 0, n);
                return byArray;
            }
            return null;
        }

        void close() throws IOException {
            if (JraSystem.isRecording()) {
                JraSystem.stopRecording();
            }
            if (this.m_stream != null) {
                if (this.m_providerThread != null) {
                    this.m_providerThread.interrupt();
                }
                this.m_stream.close();
                this.m_stream = null;
                this.m_buffer = null;
            }
            this.m_file.delete();
        }

        void open() throws IOException {
            if (JraSystem.isRecording()) {
                JraSystem.stopRecording();
            }
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            this.m_buffer = new byte[4096];
            this.m_stream = new PipedInputStream(pipedOutputStream);
            final FileInputStream fileInputStream = new FileInputStream(this.m_file);
            final GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(pipedOutputStream);
            this.m_providerThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        int n;
                        byte[] byArray = new byte[1024];
                        while ((n = fileInputStream.read(byArray)) > 0) {
                            gZIPOutputStream.write(byArray, 0, n);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    finally {
                        try {
                            gZIPOutputStream.close();
                        }
                        catch (IOException iOException) {}
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {}
                        JRAFile.this.m_providerThread = null;
                    }
                }
            };
            this.m_providerThread.start();
        }
    }

    private class JRGarbageCollectionListener
    implements GarbageCollectionListener {
        private JRGarbageCollectionListener() {
        }

        public void onGarbageCollection(GarbageCollectionEvent garbageCollectionEvent) {
            JRockitConsole.createNotification(garbageCollectionEvent);
        }
    }

    private class JRGarbageCollectionStrategyListener
    implements GarbageCollectionStrategyChangeListener {
        private JRGarbageCollectionStrategyListener() {
        }

        public void onGarbageCollectionStrategyChange(GarbageCollectionStrategyChangeEvent garbageCollectionStrategyChangeEvent) {
            JRockitConsole.createNotification(JRockitConsole.this.getGarbageCollectionStrategy());
        }
    }
}

