/*
 * Decompiled with CFR 0.152.
 */
package jrockit.management;

import com.bea.jvm.CPU;
import java.util.List;
import jrockit.management.OperatingSystemMXBean;
import jrockit.management.Runtime;
import jrockit.management.Toolkit;
import sun.management.MXBeanSupport;

public class OperatingSystem
extends MXBeanSupport
implements OperatingSystemMXBean {
    private static OperatingSystem m_singleton;

    public OperatingSystem() {
        super(OperatingSystemMXBean.class);
    }

    public String getName() {
        return System.getProperty("os.name", Toolkit.UNKNOWN_STRING_ATTRIBUTE_VALUE);
    }

    public String getArch() {
        return System.getProperty("os.arch", Toolkit.UNKNOWN_STRING_ATTRIBUTE_VALUE);
    }

    public String getVersion() {
        return System.getProperty("os.version", Toolkit.UNKNOWN_STRING_ATTRIBUTE_VALUE);
    }

    public int getAvailableProcessors() {
        return java.lang.Runtime.getRuntime().availableProcessors();
    }

    public static synchronized OperatingSystemMXBean getOperatingSystemMBean() {
        if (m_singleton == null) {
            m_singleton = new OperatingSystem();
        }
        return m_singleton;
    }

    public float getCPULoad() {
        double d = 0.0;
        List list = Runtime.getJVM().getMachine().getCPUs();
        for (CPU cPU : list) {
            d += cPU.getLoad();
        }
        return (float)Math.min(100.0, (d /= (double)list.size()) * 100.0);
    }

    public float getVMGeneratedCPULoad() {
        return (float)Math.min(100.0, Runtime.getJVM().getJVMLoad() * 100.0);
    }
}

