/*
 * Decompiled with CFR 0.152.
 */
package jrockit.management;

import com.bea.jvm.CPU;
import com.bea.jvm.JVM;
import com.bea.jvm.JVMFactory;
import com.bea.jvm.NotAvailableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jrockit.management.RuntimeMXBean;
import jrockit.management.Toolkit;
import sun.management.MXBeanSupport;

public class Runtime
extends MXBeanSupport
implements RuntimeMXBean {
    private static Runtime m_singleton;
    private static JVM m_jvm;

    public Runtime() {
        super(RuntimeMXBean.class);
    }

    public String getClassPath() {
        return System.getProperty("java.class.path");
    }

    public String getName() {
        return Toolkit.getPrivilegedProperty("java.vm.name", "JRockit");
    }

    public String getVmName() {
        return System.getProperty("java.vm.name");
    }

    public String getVmVendor() {
        return System.getProperty("java.vm.vendor");
    }

    public String getVmVersion() {
        return System.getProperty("java.vm.version");
    }

    public String getSpecName() {
        return System.getProperty("java.vm.specification.name");
    }

    public String getSpecVendor() {
        return System.getProperty("java.vm.specification.vendor");
    }

    public String getSpecVersion() {
        return System.getProperty("java.vm.specification.version");
    }

    public String getManagementSpecVersion() {
        return "1.0";
    }

    public String getLibraryPath() {
        return System.getProperty("java.library.path");
    }

    public boolean isBootClassPathSupported() {
        return true;
    }

    public String getBootClassPath() throws SecurityException {
        Toolkit.checkMonitor();
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("sun.boot.class.path");
            }
        });
    }

    public long getUptime() {
        return System.currentTimeMillis() - m_jvm.getStartTime();
    }

    public long getStartTime() {
        return m_jvm.getStartTime();
    }

    public Map getSystemProperties() {
        return System.getProperties();
    }

    public List getInputArguments() throws SecurityException {
        Toolkit.checkMonitor();
        String[] stringArray = this.getInputArguments0();
        if (stringArray == null || stringArray.length == 0) {
            return new LinkedList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    public void setProcessAffinity(int[] nArray) {
        Toolkit.checkControl();
        boolean bl = false;
        int n = JVMFactory.getJVM().getMachine().getCPUs().size();
        if (nArray.length * 32 < n) {
            throw new IllegalArgumentException("Need to call setProcessAffinity with an array of at least length " + (n + 0));
        }
        ArrayList<CPU> arrayList = new ArrayList<CPU>(32 * nArray.length + 16);
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < 32; ++j) {
                long l = (long)Math.pow(2.0, j) & (long)nArray[i];
                if (l <= 0L) continue;
                int n2 = 32 * i + j;
                if (m_jvm.getMachine().getCPUs().size() > n2) {
                    arrayList.add((CPU)m_jvm.getMachine().getCPUs().get(n2));
                    continue;
                }
                throw new IllegalArgumentException("Called setProcessAffinity with bit set on non existent cpu position!");
            }
        }
        if (arrayList.size() > 0) {
            m_jvm.suggestProcessAffinity(arrayList);
        }
    }

    public int[] getProcessAffinity() {
        int n = JVMFactory.getJVM().getMachine().getCPUs().size();
        int[] nArray = new int[(n + 31) / 32];
        try {
            Collection collection = JVMFactory.getJVM().getProcessAffinity();
            List list = JVMFactory.getJVM().getMachine().getCPUs();
            for (int i = 0; i < list.size(); ++i) {
                nArray[i / 32] = nArray[i / 32] | (collection.contains(list.get(i)) ? (int)Math.pow(2.0, i % 32) : 0);
            }
        }
        catch (NotAvailableException notAvailableException) {
            return null;
        }
        return nArray;
    }

    public static synchronized RuntimeMXBean getRuntimeMBean() {
        if (m_singleton == null) {
            m_jvm = (JVM)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return JVMFactory.getJVM();
                }
            });
            m_singleton = new Runtime();
        }
        return m_singleton;
    }

    static JVM getJVM() {
        return m_jvm;
    }

    private native String[] getInputArguments0();
}

