/*
 * Decompiled with CFR 0.152.
 */
package jrockit.management;

import java.lang.management.ManagementPermission;
import java.security.Permission;
import java.security.PrivilegedAction;
import jrockit.ext.counter.Counters;
import jrockit.vm.AccessController;
import sun.management.counter.LongCounter;

final class Toolkit {
    static String UNKNOWN_STRING_ATTRIBUTE_VALUE = "Unknown";
    private static ManagementPermission CONTROL_PERMISSION = new ManagementPermission("control");
    private static ManagementPermission MONITOR_PERMISSION = new ManagementPermission("monitor");

    private Toolkit() {
    }

    private static void check(Permission permission) throws SecurityException {
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(permission);
        }
    }

    static void checkControl() throws SecurityException {
        Toolkit.check(CONTROL_PERMISSION);
    }

    static void checkMonitor() throws SecurityException {
        Toolkit.check(MONITOR_PERMISSION);
    }

    static String getPrivilegedProperty(String string, String string2) {
        final String string3 = string;
        final String string4 = string2;
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string3, string4);
            }
        });
    }

    static InternalError newInternalError(Exception exception) {
        InternalError internalError = new InternalError(exception.getMessage());
        internalError.initCause(exception);
        return internalError;
    }

    static LongCounter getPrivilegedLongCounter(String string) {
        final String string2 = string;
        return (LongCounter)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return (LongCounter)Counters.acquire().getPerformanceCounter(string2);
            }
        });
    }
}

