/*
 * Decompiled with CFR 0.152.
 */
package jrockit.mapi;

import com.bea.jvm.CPU;
import com.bea.jvm.NotAvailableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jrockit.mapi.DescribableImpl;

public class CPUImpl
extends DescribableImpl
implements CPU {
    private static final int CPU_ID_ALL = -1;
    private int id;
    private long freq;
    private String desc;
    private static Object totalLoadLock = new Object();
    private static CPUImpl[] cpus;

    private CPUImpl(int n, String string, long l) {
        this.id = n;
        this.freq = l;
        this.desc = string;
    }

    private CPUImpl() {
        this.init();
    }

    public synchronized double getLoad() throws NotAvailableException {
        return CPUImpl.getCPULoad(this.id);
    }

    public long getClockFrequency() throws NotAvailableException {
        return this.freq;
    }

    public StringBuffer toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.desc);
        stringBuffer.append('@');
        stringBuffer.append(this.freq / 0x100000L);
        stringBuffer.append("Mhz");
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static double getTotalCPULoad() {
        Object object = totalLoadLock;
        synchronized (object) {
            return CPUImpl.getCPULoad(-1);
        }
    }

    static List getAll() {
        if (cpus == null) {
            CPUImpl cPUImpl = new CPUImpl();
            cpus = new CPUImpl[cPUImpl.id];
            for (int i = 0; i < cpus.length; ++i) {
                CPUImpl.cpus[i] = new CPUImpl(i, cPUImpl.desc, cPUImpl.freq);
            }
        }
        return Arrays.asList(cpus);
    }

    public static Collection getProcessAffinity() {
        long l = CPUImpl.getProcessAffinity0();
        ArrayList<CPUImpl> arrayList = new ArrayList<CPUImpl>();
        for (CPUImpl cPUImpl : CPUImpl.getAll()) {
            if ((l & (long)(1 << cPUImpl.id)) == 0L) continue;
            arrayList.add(cPUImpl);
        }
        return arrayList;
    }

    public static void suggestProcessAffinity(Collection collection) throws NotAvailableException {
        long l = 0L;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            l |= (long)(1 << ((CPUImpl)iterator.next()).id);
        }
        CPUImpl.suggestProcessAffinity0(l);
    }

    static native long getStartTime();

    private native void init();

    private static native long getProcessAffinity0();

    private static native void suggestProcessAffinity0(long var0);

    private static native double getCPULoad(int var0);
}

