/*
 * Decompiled with CFR 0.152.
 */
package jrockit.mapi;

import com.bea.jvm.Machine;
import com.bea.jvm.NotAvailableException;
import com.bea.jvm.PhysicalMemory;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jrockit.mapi.CPUImpl;
import jrockit.mapi.NICImpl;
import jrockit.mapi.PhysicalMemoryImpl;
import jrockit.mapi.Toolkit;

public class MachineImpl
implements Machine {
    private String desc;
    private PhysicalMemoryImpl physicalMemory = new PhysicalMemoryImpl();

    public MachineImpl() {
        Toolkit.checkCreate();
        this.desc = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("os.arch", "Unknown");
            }
        });
    }

    public List getCPUs() throws NotAvailableException {
        return CPUImpl.getAll();
    }

    public PhysicalMemory getPhysicalMemory() throws NotAvailableException {
        return this.physicalMemory;
    }

    public Collection getHardwareComponents() throws NotAvailableException {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(this.getPhysicalMemory());
        List list = this.getCPUs();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            linkedList.add(iterator.next());
        }
        linkedList.addAll(this.getNICs());
        return linkedList;
    }

    public ByteOrder getByteOrder() throws NotAvailableException {
        return ByteOrder.nativeOrder();
    }

    public Collection getNICs() throws NotAvailableException {
        return NICImpl.getAll();
    }

    public String getDescription() {
        return this.desc;
    }
}

