/*
 * Decompiled with CFR 0.152.
 */
package jrockit.mapi;

import com.bea.jvm.NIC;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import jrockit.mapi.DescribableImpl;
import jrockit.vm.Access;

public class NICImpl
extends DescribableImpl
implements NIC {
    private NetworkInterface nif;

    public NICImpl(NetworkInterface networkInterface) {
        this.nif = networkInterface;
    }

    public NetworkInterface getNetworkInterface() {
        return this.nif;
    }

    public String getMAC() {
        return Access.net().getNetworkInterfaceMAC(this.nif);
    }

    public long getMTU() {
        return Access.net().getNetworkInterfaceMTU(this.nif);
    }

    public StringBuffer toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.nif.toString());
        stringBuffer.append(" MAC=");
        stringBuffer.append(this.getMAC());
        stringBuffer.append(" MTU=");
        stringBuffer.append(this.getMTU());
        return stringBuffer;
    }

    static List getAll() {
        ArrayList<NICImpl> arrayList = new ArrayList<NICImpl>();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                arrayList.add(new NICImpl(networkInterface));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }
}

